/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.metrics.MetricsComponent;

/**
 * Collect various metrics directly from Camel routes using the DropWizard
 * metrics library.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface MetricsComponentBuilderFactory {

    /**
     * Metrics (camel-metrics)
     * Collect various metrics directly from Camel routes using the DropWizard
     * metrics library.
     * 
     * Category: monitoring
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-metrics
     */
    static MetricsComponentBuilder metrics() {
        return new MetricsComponentBuilderImpl();
    }

    /**
     * Builder for the Metrics component.
     */
    interface MetricsComponentBuilder
            extends
                ComponentBuilder<MetricsComponent> {
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default MetricsComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        @Deprecated
        default MetricsComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom configured MetricRegistry.
         * 
         * The option is a: <code>com.codahale.metrics.MetricRegistry</code>
         * type.
         * 
         * Group: advanced
         */
        default MetricsComponentBuilder metricRegistry(
                com.codahale.metrics.MetricRegistry metricRegistry) {
            doSetProperty("metricRegistry", metricRegistry);
            return this;
        }
    }

    class MetricsComponentBuilderImpl
            extends
                AbstractComponentBuilder<MetricsComponent>
            implements
                MetricsComponentBuilder {
        @Override
        protected MetricsComponent buildConcreteComponent() {
            return new MetricsComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "lazyStartProducer": ((MetricsComponent) component).setLazyStartProducer((boolean) value); return true;
            case "basicPropertyBinding": ((MetricsComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "metricRegistry": ((MetricsComponent) component).setMetricRegistry((com.codahale.metrics.MetricRegistry) value); return true;
            default: return false;
            }
        }
    }
}