/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.crypto.cms.util;

import java.security.cert.X509Certificate;

import org.apache.camel.Exchange;
import org.apache.camel.component.crypto.cms.common.OriginatorInformationProvider;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.OriginatorInfoGenerator;
import org.bouncycastle.cms.OriginatorInformation;

import static org.junit.jupiter.api.Assertions.assertNotNull;

public class TestOriginatorInformationProvider implements OriginatorInformationProvider {

    @Override
    public OriginatorInformation getOriginatorInformation(Exchange exchange) throws CryptoCmsException {

        try {
            KeyStoreParameters keyStorePas = KeystoreUtil.getKeyStoreParameters("test.jks");
            assertNotNull(keyStorePas);
            X509Certificate cert = (X509Certificate) keyStorePas.createKeyStore().getCertificate("test user keystore test");
            assertNotNull(cert);
            X509CertificateHolder origCert = new X509CertificateHolder(cert.getEncoded());
            return new OriginatorInfoGenerator(origCert).generate();
        } catch (Exception e) {
            throw new CryptoCmsException(e);
        }

    }

}
