/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Communicate with OData 2.0 services using Apache Olingo.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Olingo2EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Olingo2 component.
     */
    public interface Olingo2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedOlingo2EndpointConsumerBuilder advanced() {
            return (AdvancedOlingo2EndpointConsumerBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder connectTimeout(int connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: application/json;charset=utf-8
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Custom entity provider read properties applied to all read
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderReadProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderReadProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder entityProviderReadProperties(
                org.apache.olingo.odata2.api.ep.EntityProviderReadProperties entityProviderReadProperties) {
            doSetProperty("entityProviderReadProperties", entityProviderReadProperties);
            return this;
        }
        /**
         * Custom entity provider read properties applied to all read
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderReadProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderReadProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder entityProviderReadProperties(
                String entityProviderReadProperties) {
            doSetProperty("entityProviderReadProperties", entityProviderReadProperties);
            return this;
        }
        /**
         * Custom entity provider write properties applied to create, update,
         * patch, batch and merge operations. For instance users can skip the
         * Json object wrapper or enable content only mode when sending request
         * data. A service URI set in the properties will always be overwritten
         * by the serviceUri configuration parameter. Please consider to using
         * the serviceUri configuration parameter instead of setting the
         * respective write property here.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderWriteProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder entityProviderWriteProperties(
                org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties entityProviderWriteProperties) {
            doSetProperty("entityProviderWriteProperties", entityProviderWriteProperties);
            return this;
        }
        /**
         * Custom entity provider write properties applied to create, update,
         * patch, batch and merge operations. For instance users can skip the
         * Json object wrapper or enable content only mode when sending request
         * data. A service URI set in the properties will always be overwritten
         * by the serviceUri configuration parameter. Please consider to using
         * the serviceUri configuration parameter instead of setting the
         * respective write property here.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderWriteProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder entityProviderWriteProperties(
                String entityProviderWriteProperties) {
            doSetProperty("entityProviderWriteProperties", entityProviderWriteProperties);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param filterAlreadySeen the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            doSetProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param filterAlreadySeen the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            doSetProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpHeaders the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder httpHeaders(
                Map<java.lang.String, java.lang.String> httpHeaders) {
            doSetProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpHeaders the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder httpHeaders(String httpHeaders) {
            doSetProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: &lt;code&gt;org.apache.http.HttpHost&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param proxy the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder proxy(
                org.apache.http.HttpHost proxy) {
            doSetProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.HttpHost&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxy the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder proxy(String proxy) {
            doSetProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUri the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder serviceUri(String serviceUri) {
            doSetProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder socketTimeout(int socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder socketTimeout(
                String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * For endpoints that return an array or collection, a consumer endpoint
         * will map every element to distinct messages, unless splitResult is
         * set to false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param splitResult the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder splitResult(boolean splitResult) {
            doSetProperty("splitResult", splitResult);
            return this;
        }
        /**
         * For endpoints that return an array or collection, a consumer endpoint
         * will map every element to distinct messages, unless splitResult is
         * set to false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param splitResult the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder splitResult(String splitResult) {
            doSetProperty("splitResult", splitResult);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Olingo2 component.
     */
    public interface AdvancedOlingo2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Olingo2EndpointConsumerBuilder basic() {
            return (Olingo2EndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.impl.nio.client.HttpAsyncClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpAsyncClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder httpAsyncClientBuilder(
                org.apache.http.impl.nio.client.HttpAsyncClientBuilder httpAsyncClientBuilder) {
            doSetProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.impl.nio.client.HttpAsyncClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpAsyncClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            doSetProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.impl.client.HttpClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder httpClientBuilder(
                org.apache.http.impl.client.HttpClientBuilder httpClientBuilder) {
            doSetProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.impl.client.HttpClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointConsumerBuilder httpClientBuilder(
                String httpClientBuilder) {
            doSetProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Olingo2 component.
     */
    public interface Olingo2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOlingo2EndpointProducerBuilder advanced() {
            return (AdvancedOlingo2EndpointProducerBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder connectTimeout(int connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: application/json;charset=utf-8
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Custom entity provider read properties applied to all read
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderReadProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderReadProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder entityProviderReadProperties(
                org.apache.olingo.odata2.api.ep.EntityProviderReadProperties entityProviderReadProperties) {
            doSetProperty("entityProviderReadProperties", entityProviderReadProperties);
            return this;
        }
        /**
         * Custom entity provider read properties applied to all read
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderReadProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderReadProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder entityProviderReadProperties(
                String entityProviderReadProperties) {
            doSetProperty("entityProviderReadProperties", entityProviderReadProperties);
            return this;
        }
        /**
         * Custom entity provider write properties applied to create, update,
         * patch, batch and merge operations. For instance users can skip the
         * Json object wrapper or enable content only mode when sending request
         * data. A service URI set in the properties will always be overwritten
         * by the serviceUri configuration parameter. Please consider to using
         * the serviceUri configuration parameter instead of setting the
         * respective write property here.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderWriteProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder entityProviderWriteProperties(
                org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties entityProviderWriteProperties) {
            doSetProperty("entityProviderWriteProperties", entityProviderWriteProperties);
            return this;
        }
        /**
         * Custom entity provider write properties applied to create, update,
         * patch, batch and merge operations. For instance users can skip the
         * Json object wrapper or enable content only mode when sending request
         * data. A service URI set in the properties will always be overwritten
         * by the serviceUri configuration parameter. Please consider to using
         * the serviceUri configuration parameter instead of setting the
         * respective write property here.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderWriteProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder entityProviderWriteProperties(
                String entityProviderWriteProperties) {
            doSetProperty("entityProviderWriteProperties", entityProviderWriteProperties);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param filterAlreadySeen the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            doSetProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param filterAlreadySeen the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            doSetProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpHeaders the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder httpHeaders(
                Map<java.lang.String, java.lang.String> httpHeaders) {
            doSetProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpHeaders the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder httpHeaders(String httpHeaders) {
            doSetProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: &lt;code&gt;org.apache.http.HttpHost&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param proxy the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder proxy(
                org.apache.http.HttpHost proxy) {
            doSetProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.HttpHost&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxy the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder proxy(String proxy) {
            doSetProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUri the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder serviceUri(String serviceUri) {
            doSetProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder socketTimeout(int socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder socketTimeout(
                String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Olingo2 component.
     */
    public interface AdvancedOlingo2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Olingo2EndpointProducerBuilder basic() {
            return (Olingo2EndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.impl.nio.client.HttpAsyncClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpAsyncClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointProducerBuilder httpAsyncClientBuilder(
                org.apache.http.impl.nio.client.HttpAsyncClientBuilder httpAsyncClientBuilder) {
            doSetProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.impl.nio.client.HttpAsyncClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpAsyncClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointProducerBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            doSetProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.impl.client.HttpClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointProducerBuilder httpClientBuilder(
                org.apache.http.impl.client.HttpClientBuilder httpClientBuilder) {
            doSetProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.impl.client.HttpClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointProducerBuilder httpClientBuilder(
                String httpClientBuilder) {
            doSetProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Olingo2 component.
     */
    public interface Olingo2EndpointBuilder
            extends
                Olingo2EndpointConsumerBuilder,
                Olingo2EndpointProducerBuilder {
        default AdvancedOlingo2EndpointBuilder advanced() {
            return (AdvancedOlingo2EndpointBuilder) this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder connectTimeout(int connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * HTTP connection creation timeout in milliseconds, defaults to 30,000
         * (30 seconds).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder connectTimeout(String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Content-Type header value can be used to specify JSON or XML message
         * format, defaults to application/json;charset=utf-8.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: application/json;charset=utf-8
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Custom entity provider read properties applied to all read
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderReadProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderReadProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder entityProviderReadProperties(
                org.apache.olingo.odata2.api.ep.EntityProviderReadProperties entityProviderReadProperties) {
            doSetProperty("entityProviderReadProperties", entityProviderReadProperties);
            return this;
        }
        /**
         * Custom entity provider read properties applied to all read
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderReadProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderReadProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder entityProviderReadProperties(
                String entityProviderReadProperties) {
            doSetProperty("entityProviderReadProperties", entityProviderReadProperties);
            return this;
        }
        /**
         * Custom entity provider write properties applied to create, update,
         * patch, batch and merge operations. For instance users can skip the
         * Json object wrapper or enable content only mode when sending request
         * data. A service URI set in the properties will always be overwritten
         * by the serviceUri configuration parameter. Please consider to using
         * the serviceUri configuration parameter instead of setting the
         * respective write property here.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderWriteProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder entityProviderWriteProperties(
                org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties entityProviderWriteProperties) {
            doSetProperty("entityProviderWriteProperties", entityProviderWriteProperties);
            return this;
        }
        /**
         * Custom entity provider write properties applied to create, update,
         * patch, batch and merge operations. For instance users can skip the
         * Json object wrapper or enable content only mode when sending request
         * data. A service URI set in the properties will always be overwritten
         * by the serviceUri configuration parameter. Please consider to using
         * the serviceUri configuration parameter instead of setting the
         * respective write property here.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param entityProviderWriteProperties the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder entityProviderWriteProperties(
                String entityProviderWriteProperties) {
            doSetProperty("entityProviderWriteProperties", entityProviderWriteProperties);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param filterAlreadySeen the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder filterAlreadySeen(
                boolean filterAlreadySeen) {
            doSetProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Set this to true to filter out results that have already been
         * communicated by this component.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param filterAlreadySeen the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder filterAlreadySeen(
                String filterAlreadySeen) {
            doSetProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpHeaders the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder httpHeaders(
                Map<java.lang.String, java.lang.String> httpHeaders) {
            doSetProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Custom HTTP headers to inject into every request, this could include
         * OAuth tokens, etc.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param httpHeaders the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder httpHeaders(String httpHeaders) {
            doSetProperty("httpHeaders", httpHeaders);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option is a: &lt;code&gt;org.apache.http.HttpHost&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param proxy the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder proxy(org.apache.http.HttpHost proxy) {
            doSetProperty("proxy", proxy);
            return this;
        }
        /**
         * HTTP proxy server configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.HttpHost&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxy the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder proxy(String proxy) {
            doSetProperty("proxy", proxy);
            return this;
        }
        /**
         * Target OData service base URI, e.g.
         * http://services.odata.org/OData/OData.svc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUri the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder serviceUri(String serviceUri) {
            doSetProperty("serviceUri", serviceUri);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder socketTimeout(int socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * HTTP request timeout in milliseconds, defaults to 30,000 (30
         * seconds).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder socketTimeout(String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Olingo2 component.
     */
    public interface AdvancedOlingo2EndpointBuilder
            extends
                AdvancedOlingo2EndpointConsumerBuilder,
                AdvancedOlingo2EndpointProducerBuilder {
        default Olingo2EndpointBuilder basic() {
            return (Olingo2EndpointBuilder) this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.impl.nio.client.HttpAsyncClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpAsyncClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointBuilder httpAsyncClientBuilder(
                org.apache.http.impl.nio.client.HttpAsyncClientBuilder httpAsyncClientBuilder) {
            doSetProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP async client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.impl.nio.client.HttpAsyncClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpAsyncClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointBuilder httpAsyncClientBuilder(
                String httpAsyncClientBuilder) {
            doSetProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.impl.client.HttpClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointBuilder httpClientBuilder(
                org.apache.http.impl.client.HttpClientBuilder httpClientBuilder) {
            doSetProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
        /**
         * Custom HTTP client builder for more complex HTTP client
         * configuration, overrides connectionTimeout, socketTimeout, proxy and
         * sslContext. Note that a socketTimeout MUST be specified in the
         * builder, otherwise OData requests could block indefinitely.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.impl.client.HttpClientBuilder&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClientBuilder the value to set
         * @return the dsl builder
         */
        default AdvancedOlingo2EndpointBuilder httpClientBuilder(
                String httpClientBuilder) {
            doSetProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }
    }

    public interface Olingo2Builders {
        /**
         * Olingo2 (camel-olingo2)
         * Communicate with OData 2.0 services using Apache Olingo.
         * 
         * Category: cloud
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-olingo2
         * 
         * @return the dsl builder for the headers' name.
         */
        default Olingo2HeaderNameBuilder olingo2() {
            return Olingo2HeaderNameBuilder.INSTANCE;
        }
        /**
         * Olingo2 (camel-olingo2)
         * Communicate with OData 2.0 services using Apache Olingo.
         * 
         * Category: cloud
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-olingo2
         * 
         * Syntax: <code>olingo2:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 1 enums and the value can be one of: DEFAULT
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder olingo2(String path) {
            return Olingo2EndpointBuilderFactory.endpointBuilder("olingo2", path);
        }
        /**
         * Olingo2 (camel-olingo2)
         * Communicate with OData 2.0 services using Apache Olingo.
         * 
         * Category: cloud
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-olingo2
         * 
         * Syntax: <code>olingo2:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 1 enums and the value can be one of: DEFAULT
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default Olingo2EndpointBuilder olingo2(String componentName, String path) {
            return Olingo2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Olingo2 component.
     */
    public static class Olingo2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Olingo2HeaderNameBuilder INSTANCE = new Olingo2HeaderNameBuilder();

        /**
         * The response Http headers.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Olingo2.responseHttpHeaders}.
         */
        public String olingo2Responsehttpheaders() {
            return "CamelOlingo2.responseHttpHeaders";
        }
    }
    static Olingo2EndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class Olingo2EndpointBuilderImpl extends AbstractEndpointBuilder implements Olingo2EndpointBuilder, AdvancedOlingo2EndpointBuilder {
            public Olingo2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Olingo2EndpointBuilderImpl(path);
    }
}