/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jms.issues;

import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.AbstractJMSTest;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class JmsInOutRepeatedInvocationsTest extends AbstractJMSTest {

    @Test
    public void testInOutRepeatSequentialInvocations() throws Exception {
        MockEndpoint mock = getMockEndpoint("mock:finished");
        mock.setAssertPeriod(2000);
        mock.expectedMessageCount(1);
        String outPayload = template.requestBody("direct:test", "test", String.class);
        assertEquals("Some reply", outPayload);
        mock.assertIsSatisfied();
    }

    @Override
    protected String getComponentName() {
        return "activemq";
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder() {
            public void configure() {

                from("direct:test")
                        .to(ExchangePattern.InOut, "activemq:queue:JmsInOutRepeatedInvocationsTest?requestTimeout=200")
                        .to(ExchangePattern.InOut, "activemq:queue:JmsInOutRepeatedInvocationsTest?requestTimeout=200")
                        .to(ExchangePattern.InOut, "activemq:queue:JmsInOutRepeatedInvocationsTest?requestTimeout=200")
                        .to("mock:finished");

                from("activemq:queue:JmsInOutRepeatedInvocationsTest")
                        .log("Received on queue JmsInOutRepeatedInvocationsTest")
                        .setBody().constant("Some reply");

            }
        };
    }

}
