/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Access OpenStack Neutron for network services.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface NeutronEndpointBuilderFactory {


    /**
     * Builder for endpoint for the OpenStack Neutron component.
     */
    public interface NeutronEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedNeutronEndpointBuilder advanced() {
            return (AdvancedNeutronEndpointBuilder) this;
        }
        /**
         * OpenStack API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: V3
         * Group: producer
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * OpenStack configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.openstack4j.core.transport.Config&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param config the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder config(
                org.openstack4j.core.transport.Config config) {
            doSetProperty("config", config);
            return this;
        }
        /**
         * OpenStack configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.openstack4j.core.transport.Config&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param config the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder config(String config) {
            doSetProperty("config", config);
            return this;
        }
        /**
         * Authentication domain.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: default
         * Group: producer
         * 
         * @param domain the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder domain(String domain) {
            doSetProperty("domain", domain);
            return this;
        }
        /**
         * The operation to do.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * OpenStack password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * The project ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param project the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder project(String project) {
            doSetProperty("project", project);
            return this;
        }
        /**
         * OpenStack Neutron subsystem.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param subsystem the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder subsystem(String subsystem) {
            doSetProperty("subsystem", subsystem);
            return this;
        }
        /**
         * OpenStack username.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default NeutronEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the OpenStack Neutron component.
     */
    public interface AdvancedNeutronEndpointBuilder
            extends
                EndpointProducerBuilder {
        default NeutronEndpointBuilder basic() {
            return (NeutronEndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNeutronEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNeutronEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface NeutronBuilders {
        /**
         * OpenStack Neutron (camel-openstack)
         * Access OpenStack Neutron for network services.
         * 
         * Category: cloud,paas
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-openstack
         * 
         * @return the dsl builder for the headers' name.
         */
        default NeutronHeaderNameBuilder openstackNeutron() {
            return NeutronHeaderNameBuilder.INSTANCE;
        }
        /**
         * OpenStack Neutron (camel-openstack)
         * Access OpenStack Neutron for network services.
         * 
         * Category: cloud,paas
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-openstack
         * 
         * Syntax: <code>openstack-neutron:host</code>
         * 
         * Path parameter: host (required)
         * OpenStack host url
         * 
         * @param path host
         * @return the dsl builder
         */
        default NeutronEndpointBuilder openstackNeutron(String path) {
            return NeutronEndpointBuilderFactory.endpointBuilder("openstack-neutron", path);
        }
        /**
         * OpenStack Neutron (camel-openstack)
         * Access OpenStack Neutron for network services.
         * 
         * Category: cloud,paas
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-openstack
         * 
         * Syntax: <code>openstack-neutron:host</code>
         * 
         * Path parameter: host (required)
         * OpenStack host url
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host
         * @return the dsl builder
         */
        default NeutronEndpointBuilder openstackNeutron(
                String componentName,
                String path) {
            return NeutronEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the OpenStack Neutron component.
     */
    public static class NeutronHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final NeutronHeaderNameBuilder INSTANCE = new NeutronHeaderNameBuilder();

        /**
         * Tenant ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: network port router
         * 
         * @return the name of the header {@code tenantId}.
         */
        public String tenantId() {
            return "tenantId";
        }

        /**
         * Network ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: subnet port
         * 
         * @return the name of the header {@code networkId}.
         */
        public String networkId() {
            return "networkId";
        }

        /**
         * AdminStateUp header.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: network
         * 
         * @return the name of the header {@code adminStateUp}.
         */
        public String adminStateUp() {
            return "adminStateUp";
        }

        /**
         * Network type.
         * 
         * The option is a: {@code org.openstack4j.model.network.NetworkType}
         * type.
         * 
         * Group: network
         * 
         * @return the name of the header {@code networkType}.
         */
        public String networkType() {
            return "networkType";
        }

        /**
         * Physical network.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: network
         * 
         * @return the name of the header {@code physicalNetwork}.
         */
        public String physicalNetwork() {
            return "physicalNetwork";
        }

        /**
         * Segment ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: network
         * 
         * @return the name of the header {@code segmentId}.
         */
        public String segmentId() {
            return "segmentId";
        }

        /**
         * Is shared.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: network
         * 
         * @return the name of the header {@code isShared}.
         */
        public String isShared() {
            return "isShared";
        }

        /**
         * Is router external.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: network
         * 
         * @return the name of the header {@code isRouterExternal}.
         */
        public String isRouterExternal() {
            return "isRouterExternal";
        }

        /**
         * Enable DHCP.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: subnet
         * 
         * @return the name of the header {@code enableDHCP}.
         */
        public String enableDHCP() {
            return "enableDHCP";
        }

        /**
         * Gateway.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: subnet
         * 
         * @return the name of the header {@code gateway}.
         */
        public String gateway() {
            return "gateway";
        }

        /**
         * IP version.
         * 
         * The option is a: {@code org.openstack4j.model.network.IPVersionType}
         * type.
         * 
         * Group: subnet
         * 
         * @return the name of the header {@code ipVersion}.
         */
        public String ipVersion() {
            return "ipVersion";
        }

        /**
         * The cidr representing the IP range for this subnet, based on IP
         * version.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: subnet
         * 
         * @return the name of the header {@code cidr}.
         */
        public String cidr() {
            return "cidr";
        }

        /**
         * The allocation pool.
         * 
         * The option is a: {@code
         * org.openstack4j.openstack.networking.domain.NeutronPool} type.
         * 
         * Group: subnet
         * 
         * @return the name of the header {@code subnetPools}.
         */
        public String subnetPools() {
            return "subnetPools";
        }

        /**
         * Device ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: port
         * 
         * @return the name of the header {@code deviceId}.
         */
        public String deviceId() {
            return "deviceId";
        }

        /**
         * MAC address.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: port
         * 
         * @return the name of the header {@code macAddress}.
         */
        public String macAddress() {
            return "macAddress";
        }

        /**
         * Router ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: router
         * 
         * @return the name of the header {@code routerId}.
         */
        public String routerId() {
            return "routerId";
        }

        /**
         * Subnet ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: router subnet
         * 
         * @return the name of the header {@code subnetId}.
         */
        public String subnetId() {
            return "subnetId";
        }

        /**
         * Port ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: port router
         * 
         * @return the name of the header {@code portId}.
         */
        public String portId() {
            return "portId";
        }

        /**
         * Interface type.
         * 
         * The option is a: {@code
         * org.openstack4j.model.network.AttachInterfaceType} type.
         * 
         * Group: router
         * 
         * @return the name of the header {@code interfaceType}.
         */
        public String interfaceType() {
            return "interfaceType";
        }

        /**
         * The operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code operation}.
         */
        public String operation() {
            return "operation";
        }

        /**
         * The ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code ID}.
         */
        public String iD() {
            return "ID";
        }

        /**
         * The name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code name}.
         */
        public String name() {
            return "name";
        }
    }
    static NeutronEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class NeutronEndpointBuilderImpl extends AbstractEndpointBuilder implements NeutronEndpointBuilder, AdvancedNeutronEndpointBuilder {
            public NeutronEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new NeutronEndpointBuilderImpl(path);
    }
}