/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send messages to WhatsApp.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WhatsAppEndpointBuilderFactory {


    /**
     * Builder for endpoint for the WhatsApp component.
     */
    public interface WhatsAppEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedWhatsAppEndpointBuilder advanced() {
            return (AdvancedWhatsAppEndpointBuilder) this;
        }
        /**
         * The authorization access token taken from whatsapp-business
         * dashboard.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: security
         * 
         * @param authorizationToken the value to set
         * @return the dsl builder
         */
        default WhatsAppEndpointBuilder authorizationToken(
                String authorizationToken) {
            doSetProperty("authorizationToken", authorizationToken);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the WhatsApp component.
     */
    public interface AdvancedWhatsAppEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WhatsAppEndpointBuilder basic() {
            return (WhatsAppEndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Facebook graph api version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param apiVersion the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Can be used to set an alternative base URI, e.g. when you want to
         * test the component against a mock WhatsApp API.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param baseUri the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder baseUri(String baseUri) {
            doSetProperty("baseUri", baseUri);
            return this;
        }
        /**
         * HttpClient implementation.
         * 
         * The option is a: &lt;code&gt;java.net.http.HttpClient&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder httpClient(
                java.net.http.HttpClient httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * HttpClient implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.http.HttpClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param httpClient the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder httpClient(String httpClient) {
            doSetProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Webhook path.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: webhook
         * Group: advanced
         * 
         * @param webhookPath the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder webhookPath(String webhookPath) {
            doSetProperty("webhookPath", webhookPath);
            return this;
        }
        /**
         * Webhook verify token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param webhookVerifyToken the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder webhookVerifyToken(
                String webhookVerifyToken) {
            doSetProperty("webhookVerifyToken", webhookVerifyToken);
            return this;
        }
        /**
         * WhatsApp service implementation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.whatsapp.WhatsAppService&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param whatsappService the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder whatsappService(
                org.apache.camel.component.whatsapp.WhatsAppService whatsappService) {
            doSetProperty("whatsappService", whatsappService);
            return this;
        }
        /**
         * WhatsApp service implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.whatsapp.WhatsAppService&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param whatsappService the value to set
         * @return the dsl builder
         */
        default AdvancedWhatsAppEndpointBuilder whatsappService(
                String whatsappService) {
            doSetProperty("whatsappService", whatsappService);
            return this;
        }
    }

    public interface WhatsAppBuilders {
        /**
         * WhatsApp (camel-whatsapp)
         * Send messages to WhatsApp.
         * 
         * Category: cloud,api,chat
         * Since: 3.19
         * Maven coordinates: org.apache.camel:camel-whatsapp
         * 
         * @return the dsl builder for the headers' name.
         */
        default WhatsAppHeaderNameBuilder whatsapp() {
            return WhatsAppHeaderNameBuilder.INSTANCE;
        }
        /**
         * WhatsApp (camel-whatsapp)
         * Send messages to WhatsApp.
         * 
         * Category: cloud,api,chat
         * Since: 3.19
         * Maven coordinates: org.apache.camel:camel-whatsapp
         * 
         * Syntax: <code>whatsapp:phoneNumberId</code>
         * 
         * Path parameter: phoneNumberId (required)
         * The phone number ID taken from whatsapp-business dashboard.
         * 
         * @param path phoneNumberId
         * @return the dsl builder
         */
        default WhatsAppEndpointBuilder whatsapp(String path) {
            return WhatsAppEndpointBuilderFactory.endpointBuilder("whatsapp", path);
        }
        /**
         * WhatsApp (camel-whatsapp)
         * Send messages to WhatsApp.
         * 
         * Category: cloud,api,chat
         * Since: 3.19
         * Maven coordinates: org.apache.camel:camel-whatsapp
         * 
         * Syntax: <code>whatsapp:phoneNumberId</code>
         * 
         * Path parameter: phoneNumberId (required)
         * The phone number ID taken from whatsapp-business dashboard.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path phoneNumberId
         * @return the dsl builder
         */
        default WhatsAppEndpointBuilder whatsapp(
                String componentName,
                String path) {
            return WhatsAppEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the WhatsApp component.
     */
    public static class WhatsAppHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WhatsAppHeaderNameBuilder INSTANCE = new WhatsAppHeaderNameBuilder();

        /**
         * Phone Number ID taken from WhatsApp Meta for Developers Dashboard.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code WhatsAppPhoneNumberId}.
         */
        public String whatsAppPhoneNumberId() {
            return "CamelWhatsAppPhoneNumberId";
        }

        /**
         * Recipient phone number associated with Phone Number ID.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * WhatsAppRecipientPhoneNumberId}.
         */
        public String whatsAppRecipientPhoneNumberId() {
            return "CamelWhatsAppRecipientPhoneNumberId";
        }
    }
    static WhatsAppEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class WhatsAppEndpointBuilderImpl extends AbstractEndpointBuilder implements WhatsAppEndpointBuilder, AdvancedWhatsAppEndpointBuilder {
            public WhatsAppEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WhatsAppEndpointBuilderImpl(path);
    }
}