/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send requests to Facebook APIs supported by Facebook4J.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface FacebookEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Facebook component.
     */
    public interface FacebookEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedFacebookEndpointConsumerBuilder advanced() {
            return (AdvancedFacebookEndpointConsumerBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param achievementURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder achievementURL(
                java.net.URL achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param achievementURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder achievementURL(
                String achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param albumId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder albumId(String albumId) {
            doSetProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.AlbumUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param albumUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder albumUpdate(
                facebook4j.AlbumUpdate albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.AlbumUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param albumUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder albumUpdate(String albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param appId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder appId(String appId) {
            doSetProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: &lt;code&gt;facebook4j.GeoLocation&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param center the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder center(
                facebook4j.GeoLocation center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.GeoLocation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param center the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder center(String center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param checkinId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder checkinId(String checkinId) {
            doSetProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: &lt;code&gt;facebook4j.CheckinUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param checkinUpdate the value to set
         * @return the dsl builder
         */
        @Deprecated
        default FacebookEndpointConsumerBuilder checkinUpdate(
                facebook4j.CheckinUpdate checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.CheckinUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param checkinUpdate the value to set
         * @return the dsl builder
         */
        @Deprecated
        default FacebookEndpointConsumerBuilder checkinUpdate(
                String checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder clientURL(String clientURL) {
            doSetProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientVersion the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder clientVersion(
                String clientVersion) {
            doSetProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param commentId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder commentId(String commentId) {
            doSetProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.CommentUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param commentUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder commentUpdate(
                facebook4j.CommentUpdate commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.CommentUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param commentUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder commentUpdate(
                String commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param debugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder debugEnabled(
                Boolean debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param debugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder debugEnabled(String debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param description the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder description(String description) {
            doSetProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param distance the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder distance(Integer distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param distance the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder distance(String distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder domainId(String domainId) {
            doSetProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainNames the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder domainNames(
                List<java.lang.String> domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainNames the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder domainNames(String domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.EventUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param eventUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder eventUpdate(
                facebook4j.EventUpdate eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.EventUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder eventUpdate(String eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder friendId(String friendId) {
            doSetProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendlistId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder friendlistId(String friendlistId) {
            doSetProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendlistName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder friendlistName(
                String friendlistName) {
            doSetProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder friendUserId(String friendUserId) {
            doSetProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param groupId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder groupId(String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param gzipEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder gzipEnabled(Boolean gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param gzipEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder gzipEnabled(String gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param httpDefaultMaxPerRoute the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param httpDefaultMaxPerRoute the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: common
         * 
         * @param httpMaxTotalConnections the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: common
         * 
         * @param httpMaxTotalConnections the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param httpReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpReadTimeout(
                Integer httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param httpReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpReadTimeout(
                String httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param httpRetryCount the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpRetryCount(
                Integer httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param httpRetryCount the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpRetryCount(
                String httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpRetryIntervalSeconds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpRetryIntervalSeconds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: common
         * 
         * @param httpStreamingReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: common
         * 
         * @param httpStreamingReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder ids(List<java.lang.String> ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeRead the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder includeRead(Boolean includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeRead the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder includeRead(String includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param isHidden the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder isHidden(Boolean isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param isHidden the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder isHidden(String isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param jsonStoreEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param jsonStoreEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder jsonStoreEnabled(
                String jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param link the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder link(java.net.URL link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param link the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder link(String link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param linkId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder linkId(String linkId) {
            doSetProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: &lt;code&gt;java.util.Locale&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder locale(Locale locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Locale&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder locale(String locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param mbeanEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder mbeanEnabled(
                Boolean mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param mbeanEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder mbeanEnabled(String mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param message the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder message(String message) {
            doSetProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param metric the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder metric(String metric) {
            doSetProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param milestoneId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder milestoneId(String milestoneId) {
            doSetProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param name the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param noteId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder noteId(String noteId) {
            doSetProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notificationId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder notificationId(
                String notificationId) {
            doSetProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param objectId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder objectId(String objectId) {
            doSetProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param offerId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder offerId(String offerId) {
            doSetProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param optionDescription the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder optionDescription(
                String optionDescription) {
            doSetProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder pageId(String pageId) {
            doSetProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permissionName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder permissionName(
                String permissionName) {
            doSetProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permissions the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder permissions(String permissions) {
            doSetProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param photoId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder photoId(String photoId) {
            doSetProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder pictureId(Integer pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder pictureId(String pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder pictureId2(Integer pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder pictureId2(String pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: &lt;code&gt;facebook4j.PictureSize&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param pictureSize the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder pictureSize(
                facebook4j.PictureSize pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PictureSize&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureSize the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder pictureSize(String pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param placeId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder placeId(String placeId) {
            doSetProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder postId(String postId) {
            doSetProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: &lt;code&gt;facebook4j.PostUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder postUpdate(
                facebook4j.PostUpdate postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PostUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder postUpdate(String postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyDebugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyDebugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queries the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder queries(
                Map<java.lang.String, java.lang.String> queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queries the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder queries(String queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param questionId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder questionId(String questionId) {
            doSetProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: &lt;code&gt;facebook4j.Reading&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reading the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder reading(
                facebook4j.Reading reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.Reading&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reading the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder reading(String reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the readingOptions(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder readingOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("readingOptions", "reading." + key, value);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the readingOptions(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder readingOptions(Map values) {
            doSetMultiValueProperties("readingOptions", "reading.", values);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph.facebook.com/
         * Group: common
         * 
         * @param restBaseURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder restBaseURL(String restBaseURL) {
            doSetProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scoreValue the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder scoreValue(Integer scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scoreValue the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder scoreValue(String scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: &lt;code&gt;facebook4j.PictureSize&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param size the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder size(facebook4j.PictureSize size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PictureSize&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param size the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder size(String size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: &lt;code&gt;facebook4j.Media&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param source the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder source(facebook4j.Media source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.Media&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param source the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder source(String source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tabId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder tabId(String tabId) {
            doSetProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: &lt;code&gt;facebook4j.TagUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder tagUpdate(
                facebook4j.TagUpdate tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TagUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder tagUpdate(String tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder testUser1(
                facebook4j.TestUser testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder testUser1(String testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder testUser2(
                facebook4j.TestUser testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder testUser2(String testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder testUserId(String testUserId) {
            doSetProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param title the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder title(String title) {
            doSetProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder toUserId(String toUserId) {
            doSetProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder toUserIds(
                List<java.lang.String> toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder toUserIds(String toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder userId1(String userId1) {
            doSetProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder userId2(String userId2) {
            doSetProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder userIds(
                List<java.lang.String> userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder userIds(String userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userLocale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder userLocale(String userLocale) {
            doSetProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param useSSL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder useSSL(Boolean useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param useSSL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder useSSL(String useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph-video.facebook.com/
         * Group: common
         * 
         * @param videoBaseURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder videoBaseURL(String videoBaseURL) {
            doSetProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param videoId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder videoId(String videoId) {
            doSetProperty("videoId", videoId);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyHost the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpProxyHost(
                String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPassword the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpProxyPassword(
                String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPort the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpProxyPort(
                Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPort the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpProxyPort(
                String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyUser the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder httpProxyUser(
                String httpProxyUser) {
            doSetProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAccessToken the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder oAuthAccessToken(
                String oAuthAccessToken) {
            doSetProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph.facebook.com/oauth/access_token
         * Group: security
         * 
         * @param oAuthAccessTokenURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            doSetProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAppId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder oAuthAppId(String oAuthAppId) {
            doSetProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAppSecret the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder oAuthAppSecret(
                String oAuthAppSecret) {
            doSetProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://www.facebook.com/dialog/oauth
         * Group: security
         * 
         * @param oAuthAuthorizationURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            doSetProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthPermissions the value to set
         * @return the dsl builder
         */
        default FacebookEndpointConsumerBuilder oAuthPermissions(
                String oAuthPermissions) {
            doSetProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Facebook component.
     */
    public interface AdvancedFacebookEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default FacebookEndpointConsumerBuilder basic() {
            return (FacebookEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFacebookEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFacebookEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFacebookEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFacebookEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedFacebookEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedFacebookEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Facebook component.
     */
    public interface FacebookEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedFacebookEndpointProducerBuilder advanced() {
            return (AdvancedFacebookEndpointProducerBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param achievementURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder achievementURL(
                java.net.URL achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param achievementURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder achievementURL(
                String achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param albumId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder albumId(String albumId) {
            doSetProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.AlbumUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param albumUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder albumUpdate(
                facebook4j.AlbumUpdate albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.AlbumUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param albumUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder albumUpdate(String albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param appId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder appId(String appId) {
            doSetProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: &lt;code&gt;facebook4j.GeoLocation&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param center the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder center(
                facebook4j.GeoLocation center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.GeoLocation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param center the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder center(String center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param checkinId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder checkinId(String checkinId) {
            doSetProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: &lt;code&gt;facebook4j.CheckinUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param checkinUpdate the value to set
         * @return the dsl builder
         */
        @Deprecated
        default FacebookEndpointProducerBuilder checkinUpdate(
                facebook4j.CheckinUpdate checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.CheckinUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param checkinUpdate the value to set
         * @return the dsl builder
         */
        @Deprecated
        default FacebookEndpointProducerBuilder checkinUpdate(
                String checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder clientURL(String clientURL) {
            doSetProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientVersion the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder clientVersion(
                String clientVersion) {
            doSetProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param commentId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder commentId(String commentId) {
            doSetProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.CommentUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param commentUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder commentUpdate(
                facebook4j.CommentUpdate commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.CommentUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param commentUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder commentUpdate(
                String commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param debugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder debugEnabled(
                Boolean debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param debugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder debugEnabled(String debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param description the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder description(String description) {
            doSetProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param distance the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder distance(Integer distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param distance the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder distance(String distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder domainId(String domainId) {
            doSetProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainNames the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder domainNames(
                List<java.lang.String> domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainNames the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder domainNames(String domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.EventUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param eventUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder eventUpdate(
                facebook4j.EventUpdate eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.EventUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder eventUpdate(String eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder friendId(String friendId) {
            doSetProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendlistId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder friendlistId(String friendlistId) {
            doSetProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendlistName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder friendlistName(
                String friendlistName) {
            doSetProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder friendUserId(String friendUserId) {
            doSetProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param groupId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder groupId(String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param gzipEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder gzipEnabled(Boolean gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param gzipEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder gzipEnabled(String gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param httpDefaultMaxPerRoute the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param httpDefaultMaxPerRoute the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: common
         * 
         * @param httpMaxTotalConnections the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: common
         * 
         * @param httpMaxTotalConnections the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param httpReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpReadTimeout(
                Integer httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param httpReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpReadTimeout(
                String httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param httpRetryCount the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpRetryCount(
                Integer httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param httpRetryCount the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpRetryCount(
                String httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpRetryIntervalSeconds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpRetryIntervalSeconds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: common
         * 
         * @param httpStreamingReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: common
         * 
         * @param httpStreamingReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder ids(List<java.lang.String> ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeRead the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder includeRead(Boolean includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeRead the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder includeRead(String includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param isHidden the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder isHidden(Boolean isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param isHidden the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder isHidden(String isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param jsonStoreEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param jsonStoreEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder jsonStoreEnabled(
                String jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param link the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder link(java.net.URL link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param link the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder link(String link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param linkId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder linkId(String linkId) {
            doSetProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: &lt;code&gt;java.util.Locale&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder locale(Locale locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Locale&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder locale(String locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param mbeanEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder mbeanEnabled(
                Boolean mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param mbeanEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder mbeanEnabled(String mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param message the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder message(String message) {
            doSetProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param metric the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder metric(String metric) {
            doSetProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param milestoneId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder milestoneId(String milestoneId) {
            doSetProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param name the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param noteId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder noteId(String noteId) {
            doSetProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notificationId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder notificationId(
                String notificationId) {
            doSetProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param objectId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder objectId(String objectId) {
            doSetProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param offerId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder offerId(String offerId) {
            doSetProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param optionDescription the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder optionDescription(
                String optionDescription) {
            doSetProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder pageId(String pageId) {
            doSetProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permissionName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder permissionName(
                String permissionName) {
            doSetProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permissions the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder permissions(String permissions) {
            doSetProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param photoId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder photoId(String photoId) {
            doSetProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder pictureId(Integer pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder pictureId(String pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder pictureId2(Integer pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder pictureId2(String pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: &lt;code&gt;facebook4j.PictureSize&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param pictureSize the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder pictureSize(
                facebook4j.PictureSize pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PictureSize&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureSize the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder pictureSize(String pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param placeId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder placeId(String placeId) {
            doSetProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder postId(String postId) {
            doSetProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: &lt;code&gt;facebook4j.PostUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder postUpdate(
                facebook4j.PostUpdate postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PostUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder postUpdate(String postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyDebugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyDebugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queries the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder queries(
                Map<java.lang.String, java.lang.String> queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queries the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder queries(String queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param questionId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder questionId(String questionId) {
            doSetProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: &lt;code&gt;facebook4j.Reading&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reading the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder reading(
                facebook4j.Reading reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.Reading&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reading the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder reading(String reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the readingOptions(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder readingOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("readingOptions", "reading." + key, value);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the readingOptions(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder readingOptions(Map values) {
            doSetMultiValueProperties("readingOptions", "reading.", values);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph.facebook.com/
         * Group: common
         * 
         * @param restBaseURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder restBaseURL(String restBaseURL) {
            doSetProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scoreValue the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder scoreValue(Integer scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scoreValue the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder scoreValue(String scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: &lt;code&gt;facebook4j.PictureSize&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param size the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder size(facebook4j.PictureSize size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PictureSize&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param size the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder size(String size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: &lt;code&gt;facebook4j.Media&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param source the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder source(facebook4j.Media source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.Media&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param source the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder source(String source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tabId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder tabId(String tabId) {
            doSetProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: &lt;code&gt;facebook4j.TagUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder tagUpdate(
                facebook4j.TagUpdate tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TagUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder tagUpdate(String tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder testUser1(
                facebook4j.TestUser testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder testUser1(String testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder testUser2(
                facebook4j.TestUser testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder testUser2(String testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder testUserId(String testUserId) {
            doSetProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param title the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder title(String title) {
            doSetProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder toUserId(String toUserId) {
            doSetProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder toUserIds(
                List<java.lang.String> toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder toUserIds(String toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder userId1(String userId1) {
            doSetProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder userId2(String userId2) {
            doSetProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder userIds(
                List<java.lang.String> userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder userIds(String userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userLocale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder userLocale(String userLocale) {
            doSetProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param useSSL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder useSSL(Boolean useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param useSSL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder useSSL(String useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph-video.facebook.com/
         * Group: common
         * 
         * @param videoBaseURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder videoBaseURL(String videoBaseURL) {
            doSetProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param videoId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder videoId(String videoId) {
            doSetProperty("videoId", videoId);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyHost the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpProxyHost(
                String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPassword the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpProxyPassword(
                String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPort the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpProxyPort(
                Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPort the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpProxyPort(
                String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyUser the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder httpProxyUser(
                String httpProxyUser) {
            doSetProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAccessToken the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder oAuthAccessToken(
                String oAuthAccessToken) {
            doSetProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph.facebook.com/oauth/access_token
         * Group: security
         * 
         * @param oAuthAccessTokenURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            doSetProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAppId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder oAuthAppId(String oAuthAppId) {
            doSetProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAppSecret the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder oAuthAppSecret(
                String oAuthAppSecret) {
            doSetProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://www.facebook.com/dialog/oauth
         * Group: security
         * 
         * @param oAuthAuthorizationURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            doSetProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthPermissions the value to set
         * @return the dsl builder
         */
        default FacebookEndpointProducerBuilder oAuthPermissions(
                String oAuthPermissions) {
            doSetProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Facebook component.
     */
    public interface AdvancedFacebookEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default FacebookEndpointProducerBuilder basic() {
            return (FacebookEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedFacebookEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedFacebookEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Facebook component.
     */
    public interface FacebookEndpointBuilder
            extends
                FacebookEndpointConsumerBuilder,
                FacebookEndpointProducerBuilder {
        default AdvancedFacebookEndpointBuilder advanced() {
            return (AdvancedFacebookEndpointBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param achievementURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder achievementURL(
                java.net.URL achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param achievementURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder achievementURL(String achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param albumId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder albumId(String albumId) {
            doSetProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.AlbumUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param albumUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder albumUpdate(
                facebook4j.AlbumUpdate albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.AlbumUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param albumUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder albumUpdate(String albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param appId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder appId(String appId) {
            doSetProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: &lt;code&gt;facebook4j.GeoLocation&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param center the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder center(facebook4j.GeoLocation center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.GeoLocation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param center the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder center(String center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param checkinId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder checkinId(String checkinId) {
            doSetProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: &lt;code&gt;facebook4j.CheckinUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param checkinUpdate the value to set
         * @return the dsl builder
         */
        @Deprecated
        default FacebookEndpointBuilder checkinUpdate(
                facebook4j.CheckinUpdate checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.CheckinUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param checkinUpdate the value to set
         * @return the dsl builder
         */
        @Deprecated
        default FacebookEndpointBuilder checkinUpdate(String checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder clientURL(String clientURL) {
            doSetProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientVersion the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder clientVersion(String clientVersion) {
            doSetProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param commentId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder commentId(String commentId) {
            doSetProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.CommentUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param commentUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder commentUpdate(
                facebook4j.CommentUpdate commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.CommentUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param commentUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder commentUpdate(String commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param debugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder debugEnabled(Boolean debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param debugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder debugEnabled(String debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param description the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder description(String description) {
            doSetProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param distance the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder distance(Integer distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param distance the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder distance(String distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder domainId(String domainId) {
            doSetProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainNames the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder domainNames(
                List<java.lang.String> domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainNames the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder domainNames(String domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: &lt;code&gt;facebook4j.EventUpdate&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param eventUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder eventUpdate(
                facebook4j.EventUpdate eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.EventUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder eventUpdate(String eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder friendId(String friendId) {
            doSetProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendlistId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder friendlistId(String friendlistId) {
            doSetProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendlistName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder friendlistName(String friendlistName) {
            doSetProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param friendUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder friendUserId(String friendUserId) {
            doSetProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param groupId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder groupId(String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param gzipEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder gzipEnabled(Boolean gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param gzipEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder gzipEnabled(String gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: common
         * 
         * @param httpConnectionTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param httpDefaultMaxPerRoute the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param httpDefaultMaxPerRoute the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: common
         * 
         * @param httpMaxTotalConnections the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: common
         * 
         * @param httpMaxTotalConnections the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param httpReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpReadTimeout(Integer httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: common
         * 
         * @param httpReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpReadTimeout(String httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param httpRetryCount the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpRetryCount(Integer httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param httpRetryCount the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpRetryCount(String httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpRetryIntervalSeconds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: common
         * 
         * @param httpRetryIntervalSeconds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: common
         * 
         * @param httpStreamingReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 40000
         * Group: common
         * 
         * @param httpStreamingReadTimeout the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder ids(List<java.lang.String> ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ids the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeRead the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder includeRead(Boolean includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includeRead the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder includeRead(String includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param isHidden the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder isHidden(Boolean isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param isHidden the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder isHidden(String isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param jsonStoreEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param jsonStoreEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder jsonStoreEnabled(String jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param link the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder link(java.net.URL link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URL&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param link the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder link(String link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param linkId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder linkId(String linkId) {
            doSetProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: &lt;code&gt;java.util.Locale&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder locale(Locale locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Locale&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param locale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder locale(String locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param mbeanEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder mbeanEnabled(Boolean mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param mbeanEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder mbeanEnabled(String mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param message the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder message(String message) {
            doSetProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param metric the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder metric(String metric) {
            doSetProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param milestoneId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder milestoneId(String milestoneId) {
            doSetProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param name the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param noteId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder noteId(String noteId) {
            doSetProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param notificationId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder notificationId(String notificationId) {
            doSetProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param objectId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder objectId(String objectId) {
            doSetProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param offerId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder offerId(String offerId) {
            doSetProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param optionDescription the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder optionDescription(
                String optionDescription) {
            doSetProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pageId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder pageId(String pageId) {
            doSetProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permissionName the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder permissionName(String permissionName) {
            doSetProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permissions the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder permissions(String permissions) {
            doSetProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param photoId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder photoId(String photoId) {
            doSetProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder pictureId(Integer pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder pictureId(String pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder pictureId2(Integer pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder pictureId2(String pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: &lt;code&gt;facebook4j.PictureSize&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param pictureSize the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder pictureSize(
                facebook4j.PictureSize pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PictureSize&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pictureSize the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder pictureSize(String pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param placeId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder placeId(String placeId) {
            doSetProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder postId(String postId) {
            doSetProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: &lt;code&gt;facebook4j.PostUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder postUpdate(
                facebook4j.PostUpdate postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PostUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param postUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder postUpdate(String postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyDebugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param prettyDebugEnabled the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queries the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder queries(
                Map<java.lang.String, java.lang.String> queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param queries the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder queries(String queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param questionId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder questionId(String questionId) {
            doSetProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: &lt;code&gt;facebook4j.Reading&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reading the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder reading(facebook4j.Reading reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.Reading&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reading the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder reading(String reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the readingOptions(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default FacebookEndpointBuilder readingOptions(String key, Object value) {
            doSetMultiValueProperty("readingOptions", "reading." + key, value);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the readingOptions(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         * 
         * @param values the values
         * @return the dsl builder
         */
        default FacebookEndpointBuilder readingOptions(Map values) {
            doSetMultiValueProperties("readingOptions", "reading.", values);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph.facebook.com/
         * Group: common
         * 
         * @param restBaseURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder restBaseURL(String restBaseURL) {
            doSetProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scoreValue the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder scoreValue(Integer scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param scoreValue the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder scoreValue(String scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: &lt;code&gt;facebook4j.PictureSize&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param size the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder size(facebook4j.PictureSize size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.PictureSize&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param size the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder size(String size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: &lt;code&gt;facebook4j.Media&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param source the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder source(facebook4j.Media source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.Media&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param source the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder source(String source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tabId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder tabId(String tabId) {
            doSetProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: &lt;code&gt;facebook4j.TagUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder tagUpdate(facebook4j.TagUpdate tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TagUpdate&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagUpdate the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder tagUpdate(String tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder testUser1(facebook4j.TestUser testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder testUser1(String testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder testUser2(facebook4j.TestUser testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a
         * &lt;code&gt;facebook4j.TestUser&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUser2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder testUser2(String testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param testUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder testUserId(String testUserId) {
            doSetProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param title the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder title(String title) {
            doSetProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder toUserId(String toUserId) {
            doSetProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder toUserIds(
                List<java.lang.String> toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUserIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder toUserIds(String toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId1 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder userId1(String userId1) {
            doSetProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userId2 the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder userId2(String userId2) {
            doSetProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder userIds(List<java.lang.String> userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userIds the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder userIds(String userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userLocale the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder userLocale(String userLocale) {
            doSetProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param useSSL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder useSSL(Boolean useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param useSSL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder useSSL(String useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph-video.facebook.com/
         * Group: common
         * 
         * @param videoBaseURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder videoBaseURL(String videoBaseURL) {
            doSetProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param videoId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder videoId(String videoId) {
            doSetProperty("videoId", videoId);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyHost the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpProxyHost(String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPassword the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpProxyPassword(
                String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPort the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpProxyPort(Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyPort the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpProxyPort(String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param httpProxyUser the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder httpProxyUser(String httpProxyUser) {
            doSetProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAccessToken the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder oAuthAccessToken(String oAuthAccessToken) {
            doSetProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://graph.facebook.com/oauth/access_token
         * Group: security
         * 
         * @param oAuthAccessTokenURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            doSetProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAppId the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder oAuthAppId(String oAuthAppId) {
            doSetProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthAppSecret the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder oAuthAppSecret(String oAuthAppSecret) {
            doSetProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: https://www.facebook.com/dialog/oauth
         * Group: security
         * 
         * @param oAuthAuthorizationURL the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            doSetProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param oAuthPermissions the value to set
         * @return the dsl builder
         */
        default FacebookEndpointBuilder oAuthPermissions(String oAuthPermissions) {
            doSetProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Facebook component.
     */
    public interface AdvancedFacebookEndpointBuilder
            extends
                AdvancedFacebookEndpointConsumerBuilder,
                AdvancedFacebookEndpointProducerBuilder {
        default FacebookEndpointBuilder basic() {
            return (FacebookEndpointBuilder) this;
        }
    }

    public interface FacebookBuilders {
        /**
         * Facebook (camel-facebook)
         * Send requests to Facebook APIs supported by Facebook4J.
         * 
         * Category: social
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-facebook
         * 
         * @return the dsl builder for the headers' name.
         */
        default FacebookHeaderNameBuilder facebook() {
            return FacebookHeaderNameBuilder.INSTANCE;
        }
        /**
         * Facebook (camel-facebook)
         * Send requests to Facebook APIs supported by Facebook4J.
         * 
         * Category: social
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-facebook
         * 
         * Syntax: <code>facebook:methodName</code>
         * 
         * Path parameter: methodName (required)
         * What operation to perform
         * 
         * @param path methodName
         * @return the dsl builder
         */
        default FacebookEndpointBuilder facebook(String path) {
            return FacebookEndpointBuilderFactory.endpointBuilder("facebook", path);
        }
        /**
         * Facebook (camel-facebook)
         * Send requests to Facebook APIs supported by Facebook4J.
         * 
         * Category: social
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-facebook
         * 
         * Syntax: <code>facebook:methodName</code>
         * 
         * Path parameter: methodName (required)
         * What operation to perform
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path methodName
         * @return the dsl builder
         */
        default FacebookEndpointBuilder facebook(
                String componentName,
                String path) {
            return FacebookEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Facebook component.
     */
    public static class FacebookHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final FacebookHeaderNameBuilder INSTANCE = new FacebookHeaderNameBuilder();

        /**
         * The raw json.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Facebook.rawJSON}.
         */
        public String facebookRawjson() {
            return "CamelFacebook.rawJSON";
        }
    }
    static FacebookEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class FacebookEndpointBuilderImpl extends AbstractEndpointBuilder implements FacebookEndpointBuilder, AdvancedFacebookEndpointBuilder {
            public FacebookEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new FacebookEndpointBuilderImpl(path);
    }
}