/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Expose websocket endpoints using JSR356.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JSR356WebSocketEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Javax Websocket component.
     */
    public interface JSR356WebSocketEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJSR356WebSocketEndpointConsumerBuilder advanced() {
            return (AdvancedJSR356WebSocketEndpointConsumerBuilder) this;
        }
        /**
         * Used when the endpoint is in client mode to populate a pool of
         * sessions.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param sessionCount the value to set
         * @return the dsl builder
         */
        default JSR356WebSocketEndpointConsumerBuilder sessionCount(
                int sessionCount) {
            doSetProperty("sessionCount", sessionCount);
            return this;
        }
        /**
         * Used when the endpoint is in client mode to populate a pool of
         * sessions.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param sessionCount the value to set
         * @return the dsl builder
         */
        default JSR356WebSocketEndpointConsumerBuilder sessionCount(
                String sessionCount) {
            doSetProperty("sessionCount", sessionCount);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Javax Websocket
     * component.
     */
    public interface AdvancedJSR356WebSocketEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default JSR356WebSocketEndpointConsumerBuilder basic() {
            return (JSR356WebSocketEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJSR356WebSocketEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJSR356WebSocketEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJSR356WebSocketEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJSR356WebSocketEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJSR356WebSocketEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJSR356WebSocketEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Javax Websocket component.
     */
    public interface JSR356WebSocketEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJSR356WebSocketEndpointProducerBuilder advanced() {
            return (AdvancedJSR356WebSocketEndpointProducerBuilder) this;
        }
        /**
         * Used when the endpoint is in client mode to populate a pool of
         * sessions.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param sessionCount the value to set
         * @return the dsl builder
         */
        default JSR356WebSocketEndpointProducerBuilder sessionCount(
                int sessionCount) {
            doSetProperty("sessionCount", sessionCount);
            return this;
        }
        /**
         * Used when the endpoint is in client mode to populate a pool of
         * sessions.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param sessionCount the value to set
         * @return the dsl builder
         */
        default JSR356WebSocketEndpointProducerBuilder sessionCount(
                String sessionCount) {
            doSetProperty("sessionCount", sessionCount);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Javax Websocket
     * component.
     */
    public interface AdvancedJSR356WebSocketEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default JSR356WebSocketEndpointProducerBuilder basic() {
            return (JSR356WebSocketEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedJSR356WebSocketEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedJSR356WebSocketEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Javax Websocket component.
     */
    public interface JSR356WebSocketEndpointBuilder
            extends
                JSR356WebSocketEndpointConsumerBuilder,
                JSR356WebSocketEndpointProducerBuilder {
        default AdvancedJSR356WebSocketEndpointBuilder advanced() {
            return (AdvancedJSR356WebSocketEndpointBuilder) this;
        }
        /**
         * Used when the endpoint is in client mode to populate a pool of
         * sessions.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param sessionCount the value to set
         * @return the dsl builder
         */
        default JSR356WebSocketEndpointBuilder sessionCount(int sessionCount) {
            doSetProperty("sessionCount", sessionCount);
            return this;
        }
        /**
         * Used when the endpoint is in client mode to populate a pool of
         * sessions.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param sessionCount the value to set
         * @return the dsl builder
         */
        default JSR356WebSocketEndpointBuilder sessionCount(String sessionCount) {
            doSetProperty("sessionCount", sessionCount);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Javax Websocket component.
     */
    public interface AdvancedJSR356WebSocketEndpointBuilder
            extends
                AdvancedJSR356WebSocketEndpointConsumerBuilder,
                AdvancedJSR356WebSocketEndpointProducerBuilder {
        default JSR356WebSocketEndpointBuilder basic() {
            return (JSR356WebSocketEndpointBuilder) this;
        }
    }

    public interface JSR356WebSocketBuilders {
        /**
         * Javax Websocket (camel-websocket-jsr356)
         * Expose websocket endpoints using JSR356.
         * 
         * Category: http
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-websocket-jsr356
         * 
         * @return the dsl builder for the headers' name.
         */
        default JSR356WebSocketHeaderNameBuilder websocketJsr356() {
            return JSR356WebSocketHeaderNameBuilder.INSTANCE;
        }
        /**
         * Javax Websocket (camel-websocket-jsr356)
         * Expose websocket endpoints using JSR356.
         * 
         * Category: http
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-websocket-jsr356
         * 
         * Syntax: <code>websocket-jsr356:uri</code>
         * 
         * Path parameter: uri
         * If a schemeless URI path is provided, a ServerEndpoint is deployed
         * under that path. Else if the URI is prefixed with the 'ws://' scheme,
         * then a connection is established to the corresponding server
         * 
         * @param path uri
         * @return the dsl builder
         */
        default JSR356WebSocketEndpointBuilder websocketJsr356(String path) {
            return JSR356WebSocketEndpointBuilderFactory.endpointBuilder("websocket-jsr356", path);
        }
        /**
         * Javax Websocket (camel-websocket-jsr356)
         * Expose websocket endpoints using JSR356.
         * 
         * Category: http
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-websocket-jsr356
         * 
         * Syntax: <code>websocket-jsr356:uri</code>
         * 
         * Path parameter: uri
         * If a schemeless URI path is provided, a ServerEndpoint is deployed
         * under that path. Else if the URI is prefixed with the 'ws://' scheme,
         * then a connection is established to the corresponding server
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path uri
         * @return the dsl builder
         */
        default JSR356WebSocketEndpointBuilder websocketJsr356(
                String componentName,
                String path) {
            return JSR356WebSocketEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Javax Websocket component.
     */
    public static class JSR356WebSocketHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final JSR356WebSocketHeaderNameBuilder INSTANCE = new JSR356WebSocketHeaderNameBuilder();

        /**
         * The session.
         * 
         * The option is a: {@code javax.websocket.Session} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code jsr356.session}.
         */
        public String jsr356Session() {
            return "jsr356.session";
        }

        /**
         * Use incoming session.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * jsr356.producer.session.incoming.use}.
         */
        public String jsr356ProducerSessionIncomingUse() {
            return "jsr356.producer.session.incoming.use";
        }
    }
    static JSR356WebSocketEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class JSR356WebSocketEndpointBuilderImpl extends AbstractEndpointBuilder implements JSR356WebSocketEndpointBuilder, AdvancedJSR356WebSocketEndpointBuilder {
            public JSR356WebSocketEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new JSR356WebSocketEndpointBuilderImpl(path);
    }
}