
/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.mail.internal;

import java.lang.reflect.Method;
import java.util.List;

import com.google.api.services.gmail.Gmail.Users.Messages;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for com.google.api.services.gmail.Gmail$Users$Messages
 */
public enum GmailUsersMessagesApiMethod implements ApiMethod {

    ATTACHMENTS(
        com.google.api.services.gmail.Gmail.Users.Messages.Attachments.class,
        "attachments"),

    BATCH_DELETE(
        com.google.api.services.gmail.Gmail.Users.Messages.BatchDelete.class,
        "batchDelete",
        arg("userId", String.class),
        arg("batchDeleteMessagesRequest", com.google.api.services.gmail.model.BatchDeleteMessagesRequest.class)),

    BATCH_MODIFY(
        com.google.api.services.gmail.Gmail.Users.Messages.BatchModify.class,
        "batchModify",
        arg("userId", String.class),
        arg("batchModifyMessagesRequest", com.google.api.services.gmail.model.BatchModifyMessagesRequest.class)),

    DELETE(
        com.google.api.services.gmail.Gmail.Users.Messages.Delete.class,
        "delete",
        arg("userId", String.class),
        arg("id", String.class)),

    GET(
        com.google.api.services.gmail.Gmail.Users.Messages.Get.class,
        "get",
        arg("userId", String.class),
        arg("id", String.class)),

    GMAIL_IMPORT(
        com.google.api.services.gmail.Gmail.Users.Messages.GmailImport.class,
        "gmailImport",
        arg("userId", String.class),
        arg("content", com.google.api.services.gmail.model.Message.class)),

    GMAIL_IMPORT_1(
        com.google.api.services.gmail.Gmail.Users.Messages.GmailImport.class,
        "gmailImport",
        arg("userId", String.class),
        arg("content", com.google.api.services.gmail.model.Message.class),
        arg("mediaContent", com.google.api.client.http.AbstractInputStreamContent.class)),

    INSERT(
        com.google.api.services.gmail.Gmail.Users.Messages.Insert.class,
        "insert",
        arg("userId", String.class),
        arg("content", com.google.api.services.gmail.model.Message.class)),

    INSERT_1(
        com.google.api.services.gmail.Gmail.Users.Messages.Insert.class,
        "insert",
        arg("userId", String.class),
        arg("content", com.google.api.services.gmail.model.Message.class),
        arg("mediaContent", com.google.api.client.http.AbstractInputStreamContent.class)),

    LIST(
        com.google.api.services.gmail.Gmail.Users.Messages.List.class,
        "list",
        arg("userId", String.class)),

    MODIFY(
        com.google.api.services.gmail.Gmail.Users.Messages.Modify.class,
        "modify",
        arg("userId", String.class),
        arg("id", String.class),
        arg("modifyMessageRequest", com.google.api.services.gmail.model.ModifyMessageRequest.class)),

    SEND(
        com.google.api.services.gmail.Gmail.Users.Messages.Send.class,
        "send",
        arg("userId", String.class),
        arg("content", com.google.api.services.gmail.model.Message.class)),

    SEND_1(
        com.google.api.services.gmail.Gmail.Users.Messages.Send.class,
        "send",
        arg("userId", String.class),
        arg("content", com.google.api.services.gmail.model.Message.class),
        arg("mediaContent", com.google.api.client.http.AbstractInputStreamContent.class)),

    TRASH(
        com.google.api.services.gmail.Gmail.Users.Messages.Trash.class,
        "trash",
        arg("userId", String.class),
        arg("id", String.class)),

    UNTRASH(
        com.google.api.services.gmail.Gmail.Users.Messages.Untrash.class,
        "untrash",
        arg("userId", String.class),
        arg("id", String.class));

    private final ApiMethod apiMethod;

    private GmailUsersMessagesApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(Messages.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
