/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.support.task.budget;

/**
 * A budget that limits the task execution to a given number of iterations
 */
public interface IterationBudget extends Budget {

    /**
     * The maximum number of iterations
     * 
     * @return
     */
    int maxIterations();

    /**
     * The current number of iterations
     * 
     * @return the current number of iterations
     */
    int iterations();

    /**
     * Whether the task has budget to continue executing or not
     * 
     * @return true if the task can continue or false otherwise
     */
    boolean canContinue();

    /**
     * Move the task to the next iteration
     *
     * @return true if the task can continue or false otherwise
     */
    boolean next();
}
