/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Send and receive messages using the SIP protocol (used in
 * telecommunications).
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SipEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the SIP component.
     */
    public interface SipEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSipEndpointConsumerBuilder advanced() {
            return (AdvancedSipEndpointConsumerBuilder) this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param cacheConnections the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder cacheConnections(
                boolean cacheConnections) {
            doSetProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param cacheConnections the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder cacheConnections(
                String cacheConnections) {
            doSetProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Setting for contentSubType can be set to any valid MimeSubType.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: plain
         * Group: common
         * 
         * @param contentSubType the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder contentSubType(String contentSubType) {
            doSetProperty("contentSubType", contentSubType);
            return this;
        }
        /**
         * Setting for contentType can be set to any valid MimeType.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Setting for a String based event type.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventHeaderName the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder eventHeaderName(
                String eventHeaderName) {
            doSetProperty("eventHeaderName", eventHeaderName);
            return this;
        }
        /**
         * Setting for a String based event Id. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventId the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * Hostname of the message originator. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromHost the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder fromHost(String fromHost) {
            doSetProperty("fromHost", fromHost);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromPort the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder fromPort(int fromPort) {
            doSetProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromPort the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder fromPort(String fromPort) {
            doSetProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Username of the message originator. Mandatory setting unless a
         * registry based custom FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromUser the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder fromUser(String fromUser) {
            doSetProperty("fromUser", fromUser);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3600
         * Group: common
         * 
         * @param msgExpiration the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder msgExpiration(int msgExpiration) {
            doSetProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3600
         * Group: common
         * 
         * @param msgExpiration the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder msgExpiration(String msgExpiration) {
            doSetProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param receiveTimeoutMillis the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder receiveTimeoutMillis(
                long receiveTimeoutMillis) {
            doSetProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param receiveTimeoutMillis the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder receiveTimeoutMillis(
                String receiveTimeoutMillis) {
            doSetProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Name of the SIP Stack instance associated with an SIP Endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: NAME_NOT_SET
         * Group: common
         * 
         * @param stackName the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder stackName(String stackName) {
            doSetProperty("stackName", stackName);
            return this;
        }
        /**
         * Hostname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toHost the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder toHost(String toHost) {
            doSetProperty("toHost", toHost);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toPort the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder toPort(int toPort) {
            doSetProperty("toPort", toPort);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toPort the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder toPort(String toPort) {
            doSetProperty("toPort", toPort);
            return this;
        }
        /**
         * Username of the message receiver. Mandatory setting unless a registry
         * based custom ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUser the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder toUser(String toUser) {
            doSetProperty("toUser", toUser);
            return this;
        }
        /**
         * Setting for choice of transport protocol. Valid choices are tcp or
         * udp.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: tcp
         * Group: common
         * 
         * @param transport the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder transport(String transport) {
            doSetProperty("transport", transport);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * This setting is used to determine whether the kind of header
         * (FromHeader,ToHeader etc) that needs to be created for this endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param consumer the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder consumer(boolean consumer) {
            doSetProperty("consumer", consumer);
            return this;
        }
        /**
         * This setting is used to determine whether the kind of header
         * (FromHeader,ToHeader etc) that needs to be created for this endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param consumer the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder consumer(String consumer) {
            doSetProperty("consumer", consumer);
            return this;
        }
        /**
         * This setting is used to distinguish between a Presence Agent and a
         * consumer. This is due to the fact that the SIP Camel component ships
         * with a basic Presence Agent (for testing purposes only). Consumers
         * have to set this flag to true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param presenceAgent the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder presenceAgent(boolean presenceAgent) {
            doSetProperty("presenceAgent", presenceAgent);
            return this;
        }
        /**
         * This setting is used to distinguish between a Presence Agent and a
         * consumer. This is due to the fact that the SIP Camel component ships
         * with a basic Presence Agent (for testing purposes only). Consumers
         * have to set this flag to true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param presenceAgent the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder presenceAgent(String presenceAgent) {
            doSetProperty("presenceAgent", presenceAgent);
            return this;
        }
        /**
         * Name of client debug log file to use for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: logging
         * 
         * @param implementationDebugLogFile the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder implementationDebugLogFile(
                String implementationDebugLogFile) {
            doSetProperty("implementationDebugLogFile", implementationDebugLogFile);
            return this;
        }
        /**
         * Name of server log file to use for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: logging
         * 
         * @param implementationServerLogFile the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder implementationServerLogFile(
                String implementationServerLogFile) {
            doSetProperty("implementationServerLogFile", implementationServerLogFile);
            return this;
        }
        /**
         * Logging level for tracing.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: logging
         * 
         * @param implementationTraceLevel the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder implementationTraceLevel(
                String implementationTraceLevel) {
            doSetProperty("implementationTraceLevel", implementationTraceLevel);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param maxForwards the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder maxForwards(int maxForwards) {
            doSetProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param maxForwards the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder maxForwards(String maxForwards) {
            doSetProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: proxy
         * 
         * @param useRouterForAllUris the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder useRouterForAllUris(
                boolean useRouterForAllUris) {
            doSetProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: proxy
         * 
         * @param useRouterForAllUris the value to set
         * @return the dsl builder
         */
        default SipEndpointConsumerBuilder useRouterForAllUris(
                String useRouterForAllUris) {
            doSetProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the SIP component.
     */
    public interface AdvancedSipEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SipEndpointConsumerBuilder basic() {
            return (SipEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.address.AddressFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param addressFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder addressFactory(
                Object addressFactory) {
            doSetProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.address.AddressFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param addressFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder addressFactory(
                String addressFactory) {
            doSetProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.CallIdHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param callIdHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder callIdHeader(
                Object callIdHeader) {
            doSetProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.CallIdHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param callIdHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder callIdHeader(
                String callIdHeader) {
            doSetProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ContactHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contactHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder contactHeader(
                Object contactHeader) {
            doSetProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ContactHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contactHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder contactHeader(
                String contactHeader) {
            doSetProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ContentTypeHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder contentTypeHeader(
                Object contentTypeHeader) {
            doSetProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ContentTypeHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder contentTypeHeader(
                String contentTypeHeader) {
            doSetProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.EventHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param eventHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder eventHeader(
                Object eventHeader) {
            doSetProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.EventHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param eventHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder eventHeader(
                String eventHeader) {
            doSetProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ExpiresHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiresHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder expiresHeader(
                Object expiresHeader) {
            doSetProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ExpiresHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiresHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder expiresHeader(
                String expiresHeader) {
            doSetProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ExtensionHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extensionHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder extensionHeader(
                Object extensionHeader) {
            doSetProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ExtensionHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extensionHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder extensionHeader(
                String extensionHeader) {
            doSetProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option is a: &lt;code&gt;javax.sip.header.FromHeader&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param fromHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder fromHeader(Object fromHeader) {
            doSetProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.FromHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fromHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder fromHeader(String fromHeader) {
            doSetProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.HeaderFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param headerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder headerFactory(
                Object headerFactory) {
            doSetProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.HeaderFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param headerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder headerFactory(
                String headerFactory) {
            doSetProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option is a: &lt;code&gt;javax.sip.ListeningPoint&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param listeningPoint the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder listeningPoint(
                Object listeningPoint) {
            doSetProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.ListeningPoint&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param listeningPoint the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder listeningPoint(
                String listeningPoint) {
            doSetProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.MaxForwardsHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxForwardsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder maxForwardsHeader(
                Object maxForwardsHeader) {
            doSetProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.MaxForwardsHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxForwardsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder maxForwardsHeader(
                String maxForwardsHeader) {
            doSetProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder maxMessageSize(
                int maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder maxMessageSize(
                String maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.message.MessageFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder messageFactory(
                Object messageFactory) {
            doSetProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.message.MessageFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder messageFactory(
                String messageFactory) {
            doSetProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option is a: &lt;code&gt;javax.sip.SipFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder sipFactory(Object sipFactory) {
            doSetProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.SipFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder sipFactory(String sipFactory) {
            doSetProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option is a: &lt;code&gt;javax.sip.SipStack&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipStack the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder sipStack(Object sipStack) {
            doSetProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.SipStack&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipStack the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder sipStack(String sipStack) {
            doSetProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option is a: &lt;code&gt;javax.sip.address.SipURI&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param sipUri the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder sipUri(Object sipUri) {
            doSetProperty("sipUri", sipUri);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.address.SipURI&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipUri the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder sipUri(String sipUri) {
            doSetProperty("sipUri", sipUri);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option is a: &lt;code&gt;javax.sip.header.ToHeader&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param toHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder toHeader(Object toHeader) {
            doSetProperty("toHeader", toHeader);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ToHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param toHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder toHeader(String toHeader) {
            doSetProperty("toHeader", toHeader);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;javax.sip.header.ViaHeader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param viaHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder viaHeaders(
                List<Object> viaHeaders) {
            doSetProperty("viaHeaders", viaHeaders);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;javax.sip.header.ViaHeader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param viaHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointConsumerBuilder viaHeaders(String viaHeaders) {
            doSetProperty("viaHeaders", viaHeaders);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the SIP component.
     */
    public interface SipEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSipEndpointProducerBuilder advanced() {
            return (AdvancedSipEndpointProducerBuilder) this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param cacheConnections the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder cacheConnections(
                boolean cacheConnections) {
            doSetProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param cacheConnections the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder cacheConnections(
                String cacheConnections) {
            doSetProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Setting for contentSubType can be set to any valid MimeSubType.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: plain
         * Group: common
         * 
         * @param contentSubType the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder contentSubType(String contentSubType) {
            doSetProperty("contentSubType", contentSubType);
            return this;
        }
        /**
         * Setting for contentType can be set to any valid MimeType.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Setting for a String based event type.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventHeaderName the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder eventHeaderName(
                String eventHeaderName) {
            doSetProperty("eventHeaderName", eventHeaderName);
            return this;
        }
        /**
         * Setting for a String based event Id. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventId the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * Hostname of the message originator. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromHost the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder fromHost(String fromHost) {
            doSetProperty("fromHost", fromHost);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromPort the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder fromPort(int fromPort) {
            doSetProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromPort the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder fromPort(String fromPort) {
            doSetProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Username of the message originator. Mandatory setting unless a
         * registry based custom FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromUser the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder fromUser(String fromUser) {
            doSetProperty("fromUser", fromUser);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3600
         * Group: common
         * 
         * @param msgExpiration the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder msgExpiration(int msgExpiration) {
            doSetProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3600
         * Group: common
         * 
         * @param msgExpiration the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder msgExpiration(String msgExpiration) {
            doSetProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param receiveTimeoutMillis the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder receiveTimeoutMillis(
                long receiveTimeoutMillis) {
            doSetProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param receiveTimeoutMillis the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder receiveTimeoutMillis(
                String receiveTimeoutMillis) {
            doSetProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Name of the SIP Stack instance associated with an SIP Endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: NAME_NOT_SET
         * Group: common
         * 
         * @param stackName the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder stackName(String stackName) {
            doSetProperty("stackName", stackName);
            return this;
        }
        /**
         * Hostname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toHost the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder toHost(String toHost) {
            doSetProperty("toHost", toHost);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toPort the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder toPort(int toPort) {
            doSetProperty("toPort", toPort);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toPort the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder toPort(String toPort) {
            doSetProperty("toPort", toPort);
            return this;
        }
        /**
         * Username of the message receiver. Mandatory setting unless a registry
         * based custom ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUser the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder toUser(String toUser) {
            doSetProperty("toUser", toUser);
            return this;
        }
        /**
         * Setting for choice of transport protocol. Valid choices are tcp or
         * udp.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: tcp
         * Group: common
         * 
         * @param transport the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder transport(String transport) {
            doSetProperty("transport", transport);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Name of client debug log file to use for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: logging
         * 
         * @param implementationDebugLogFile the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder implementationDebugLogFile(
                String implementationDebugLogFile) {
            doSetProperty("implementationDebugLogFile", implementationDebugLogFile);
            return this;
        }
        /**
         * Name of server log file to use for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: logging
         * 
         * @param implementationServerLogFile the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder implementationServerLogFile(
                String implementationServerLogFile) {
            doSetProperty("implementationServerLogFile", implementationServerLogFile);
            return this;
        }
        /**
         * Logging level for tracing.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: logging
         * 
         * @param implementationTraceLevel the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder implementationTraceLevel(
                String implementationTraceLevel) {
            doSetProperty("implementationTraceLevel", implementationTraceLevel);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param maxForwards the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder maxForwards(int maxForwards) {
            doSetProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param maxForwards the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder maxForwards(String maxForwards) {
            doSetProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: proxy
         * 
         * @param useRouterForAllUris the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder useRouterForAllUris(
                boolean useRouterForAllUris) {
            doSetProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: proxy
         * 
         * @param useRouterForAllUris the value to set
         * @return the dsl builder
         */
        default SipEndpointProducerBuilder useRouterForAllUris(
                String useRouterForAllUris) {
            doSetProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the SIP component.
     */
    public interface AdvancedSipEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SipEndpointProducerBuilder basic() {
            return (SipEndpointProducerBuilder) this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.address.AddressFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param addressFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder addressFactory(
                Object addressFactory) {
            doSetProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.address.AddressFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param addressFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder addressFactory(
                String addressFactory) {
            doSetProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.CallIdHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param callIdHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder callIdHeader(
                Object callIdHeader) {
            doSetProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.CallIdHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param callIdHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder callIdHeader(
                String callIdHeader) {
            doSetProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ContactHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contactHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder contactHeader(
                Object contactHeader) {
            doSetProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ContactHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contactHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder contactHeader(
                String contactHeader) {
            doSetProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ContentTypeHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder contentTypeHeader(
                Object contentTypeHeader) {
            doSetProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ContentTypeHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder contentTypeHeader(
                String contentTypeHeader) {
            doSetProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.EventHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param eventHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder eventHeader(
                Object eventHeader) {
            doSetProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.EventHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param eventHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder eventHeader(
                String eventHeader) {
            doSetProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ExpiresHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiresHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder expiresHeader(
                Object expiresHeader) {
            doSetProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ExpiresHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiresHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder expiresHeader(
                String expiresHeader) {
            doSetProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ExtensionHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extensionHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder extensionHeader(
                Object extensionHeader) {
            doSetProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ExtensionHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extensionHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder extensionHeader(
                String extensionHeader) {
            doSetProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option is a: &lt;code&gt;javax.sip.header.FromHeader&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param fromHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder fromHeader(Object fromHeader) {
            doSetProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.FromHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fromHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder fromHeader(String fromHeader) {
            doSetProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.HeaderFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param headerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder headerFactory(
                Object headerFactory) {
            doSetProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.HeaderFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param headerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder headerFactory(
                String headerFactory) {
            doSetProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option is a: &lt;code&gt;javax.sip.ListeningPoint&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param listeningPoint the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder listeningPoint(
                Object listeningPoint) {
            doSetProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.ListeningPoint&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param listeningPoint the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder listeningPoint(
                String listeningPoint) {
            doSetProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.MaxForwardsHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxForwardsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder maxForwardsHeader(
                Object maxForwardsHeader) {
            doSetProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.MaxForwardsHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxForwardsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder maxForwardsHeader(
                String maxForwardsHeader) {
            doSetProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder maxMessageSize(
                int maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder maxMessageSize(
                String maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.message.MessageFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder messageFactory(
                Object messageFactory) {
            doSetProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.message.MessageFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder messageFactory(
                String messageFactory) {
            doSetProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option is a: &lt;code&gt;javax.sip.SipFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder sipFactory(Object sipFactory) {
            doSetProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.SipFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder sipFactory(String sipFactory) {
            doSetProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option is a: &lt;code&gt;javax.sip.SipStack&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipStack the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder sipStack(Object sipStack) {
            doSetProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.SipStack&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipStack the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder sipStack(String sipStack) {
            doSetProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option is a: &lt;code&gt;javax.sip.address.SipURI&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param sipUri the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder sipUri(Object sipUri) {
            doSetProperty("sipUri", sipUri);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.address.SipURI&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipUri the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder sipUri(String sipUri) {
            doSetProperty("sipUri", sipUri);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option is a: &lt;code&gt;javax.sip.header.ToHeader&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param toHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder toHeader(Object toHeader) {
            doSetProperty("toHeader", toHeader);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ToHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param toHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder toHeader(String toHeader) {
            doSetProperty("toHeader", toHeader);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;javax.sip.header.ViaHeader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param viaHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder viaHeaders(
                List<Object> viaHeaders) {
            doSetProperty("viaHeaders", viaHeaders);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;javax.sip.header.ViaHeader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param viaHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointProducerBuilder viaHeaders(String viaHeaders) {
            doSetProperty("viaHeaders", viaHeaders);
            return this;
        }
    }

    /**
     * Builder for endpoint for the SIP component.
     */
    public interface SipEndpointBuilder
            extends
                SipEndpointConsumerBuilder,
                SipEndpointProducerBuilder {
        default AdvancedSipEndpointBuilder advanced() {
            return (AdvancedSipEndpointBuilder) this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param cacheConnections the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder cacheConnections(boolean cacheConnections) {
            doSetProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param cacheConnections the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder cacheConnections(String cacheConnections) {
            doSetProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Setting for contentSubType can be set to any valid MimeSubType.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: plain
         * Group: common
         * 
         * @param contentSubType the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder contentSubType(String contentSubType) {
            doSetProperty("contentSubType", contentSubType);
            return this;
        }
        /**
         * Setting for contentType can be set to any valid MimeType.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Setting for a String based event type.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventHeaderName the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder eventHeaderName(String eventHeaderName) {
            doSetProperty("eventHeaderName", eventHeaderName);
            return this;
        }
        /**
         * Setting for a String based event Id. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventId the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * Hostname of the message originator. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromHost the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder fromHost(String fromHost) {
            doSetProperty("fromHost", fromHost);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromPort the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder fromPort(int fromPort) {
            doSetProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromPort the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder fromPort(String fromPort) {
            doSetProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Username of the message originator. Mandatory setting unless a
         * registry based custom FromHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fromUser the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder fromUser(String fromUser) {
            doSetProperty("fromUser", fromUser);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3600
         * Group: common
         * 
         * @param msgExpiration the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder msgExpiration(int msgExpiration) {
            doSetProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3600
         * Group: common
         * 
         * @param msgExpiration the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder msgExpiration(String msgExpiration) {
            doSetProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param receiveTimeoutMillis the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder receiveTimeoutMillis(
                long receiveTimeoutMillis) {
            doSetProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: common
         * 
         * @param receiveTimeoutMillis the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder receiveTimeoutMillis(
                String receiveTimeoutMillis) {
            doSetProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Name of the SIP Stack instance associated with an SIP Endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: NAME_NOT_SET
         * Group: common
         * 
         * @param stackName the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder stackName(String stackName) {
            doSetProperty("stackName", stackName);
            return this;
        }
        /**
         * Hostname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toHost the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder toHost(String toHost) {
            doSetProperty("toHost", toHost);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toPort the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder toPort(int toPort) {
            doSetProperty("toPort", toPort);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toPort the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder toPort(String toPort) {
            doSetProperty("toPort", toPort);
            return this;
        }
        /**
         * Username of the message receiver. Mandatory setting unless a registry
         * based custom ToHeader is specified.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param toUser the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder toUser(String toUser) {
            doSetProperty("toUser", toUser);
            return this;
        }
        /**
         * Setting for choice of transport protocol. Valid choices are tcp or
         * udp.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: tcp
         * Group: common
         * 
         * @param transport the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder transport(String transport) {
            doSetProperty("transport", transport);
            return this;
        }
        /**
         * Name of client debug log file to use for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: logging
         * 
         * @param implementationDebugLogFile the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder implementationDebugLogFile(
                String implementationDebugLogFile) {
            doSetProperty("implementationDebugLogFile", implementationDebugLogFile);
            return this;
        }
        /**
         * Name of server log file to use for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: logging
         * 
         * @param implementationServerLogFile the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder implementationServerLogFile(
                String implementationServerLogFile) {
            doSetProperty("implementationServerLogFile", implementationServerLogFile);
            return this;
        }
        /**
         * Logging level for tracing.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: logging
         * 
         * @param implementationTraceLevel the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder implementationTraceLevel(
                String implementationTraceLevel) {
            doSetProperty("implementationTraceLevel", implementationTraceLevel);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param maxForwards the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder maxForwards(int maxForwards) {
            doSetProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param maxForwards the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder maxForwards(String maxForwards) {
            doSetProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: proxy
         * 
         * @param useRouterForAllUris the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder useRouterForAllUris(
                boolean useRouterForAllUris) {
            doSetProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: proxy
         * 
         * @param useRouterForAllUris the value to set
         * @return the dsl builder
         */
        default SipEndpointBuilder useRouterForAllUris(
                String useRouterForAllUris) {
            doSetProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the SIP component.
     */
    public interface AdvancedSipEndpointBuilder
            extends
                AdvancedSipEndpointConsumerBuilder,
                AdvancedSipEndpointProducerBuilder {
        default SipEndpointBuilder basic() {
            return (SipEndpointBuilder) this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.address.AddressFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param addressFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder addressFactory(Object addressFactory) {
            doSetProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.address.AddressFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param addressFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder addressFactory(String addressFactory) {
            doSetProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.CallIdHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param callIdHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder callIdHeader(Object callIdHeader) {
            doSetProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.CallIdHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param callIdHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder callIdHeader(String callIdHeader) {
            doSetProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ContactHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contactHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder contactHeader(Object contactHeader) {
            doSetProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ContactHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contactHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder contactHeader(String contactHeader) {
            doSetProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ContentTypeHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder contentTypeHeader(
                Object contentTypeHeader) {
            doSetProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ContentTypeHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder contentTypeHeader(
                String contentTypeHeader) {
            doSetProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.EventHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param eventHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder eventHeader(Object eventHeader) {
            doSetProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.EventHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param eventHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder eventHeader(String eventHeader) {
            doSetProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ExpiresHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiresHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder expiresHeader(Object expiresHeader) {
            doSetProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ExpiresHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiresHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder expiresHeader(String expiresHeader) {
            doSetProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.ExtensionHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extensionHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder extensionHeader(
                Object extensionHeader) {
            doSetProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ExtensionHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param extensionHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder extensionHeader(
                String extensionHeader) {
            doSetProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option is a: &lt;code&gt;javax.sip.header.FromHeader&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param fromHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder fromHeader(Object fromHeader) {
            doSetProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.FromHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param fromHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder fromHeader(String fromHeader) {
            doSetProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.HeaderFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param headerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder headerFactory(Object headerFactory) {
            doSetProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.HeaderFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param headerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder headerFactory(String headerFactory) {
            doSetProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option is a: &lt;code&gt;javax.sip.ListeningPoint&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param listeningPoint the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder listeningPoint(Object listeningPoint) {
            doSetProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.ListeningPoint&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param listeningPoint the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder listeningPoint(String listeningPoint) {
            doSetProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.header.MaxForwardsHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxForwardsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder maxForwardsHeader(
                Object maxForwardsHeader) {
            doSetProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.MaxForwardsHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param maxForwardsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder maxForwardsHeader(
                String maxForwardsHeader) {
            doSetProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder maxMessageSize(int maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param maxMessageSize the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder maxMessageSize(String maxMessageSize) {
            doSetProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option is a:
         * &lt;code&gt;javax.sip.message.MessageFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder messageFactory(Object messageFactory) {
            doSetProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.message.MessageFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder messageFactory(String messageFactory) {
            doSetProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option is a: &lt;code&gt;javax.sip.SipFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder sipFactory(Object sipFactory) {
            doSetProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.SipFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder sipFactory(String sipFactory) {
            doSetProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option is a: &lt;code&gt;javax.sip.SipStack&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipStack the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder sipStack(Object sipStack) {
            doSetProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.SipStack&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipStack the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder sipStack(String sipStack) {
            doSetProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option is a: &lt;code&gt;javax.sip.address.SipURI&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param sipUri the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder sipUri(Object sipUri) {
            doSetProperty("sipUri", sipUri);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.address.SipURI&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param sipUri the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder sipUri(String sipUri) {
            doSetProperty("sipUri", sipUri);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option is a: &lt;code&gt;javax.sip.header.ToHeader&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param toHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder toHeader(Object toHeader) {
            doSetProperty("toHeader", toHeader);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sip.header.ToHeader&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param toHeader the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder toHeader(String toHeader) {
            doSetProperty("toHeader", toHeader);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;javax.sip.header.ViaHeader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param viaHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder viaHeaders(List<Object> viaHeaders) {
            doSetProperty("viaHeaders", viaHeaders);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;javax.sip.header.ViaHeader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param viaHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedSipEndpointBuilder viaHeaders(String viaHeaders) {
            doSetProperty("viaHeaders", viaHeaders);
            return this;
        }
    }

    public interface SipBuilders {
        /**
         * SIP (camel-sip)
         * Send and receive messages using the SIP protocol (used in
         * telecommunications).
         * 
         * Category: mobile
         * Since: 2.5
         * Maven coordinates: org.apache.camel:camel-sip
         * 
         * Syntax: <code>sip:uri</code>
         * 
         * Path parameter: uri (required)
         * URI of the SIP server to connect to (the username and password can be
         * included such as: john:secretmyserver:9999)
         * 
         * @param path uri
         * @return the dsl builder
         */
        default SipEndpointBuilder sip(String path) {
            return SipEndpointBuilderFactory.endpointBuilder("sip", path);
        }
        /**
         * SIP (camel-sip)
         * Send and receive messages using the SIP protocol (used in
         * telecommunications).
         * 
         * Category: mobile
         * Since: 2.5
         * Maven coordinates: org.apache.camel:camel-sip
         * 
         * Syntax: <code>sip:uri</code>
         * 
         * Path parameter: uri (required)
         * URI of the SIP server to connect to (the username and password can be
         * included such as: john:secretmyserver:9999)
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path uri
         * @return the dsl builder
         */
        default SipEndpointBuilder sip(String componentName, String path) {
            return SipEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
        /**
         * SIP (Secure) (camel-sip)
         * Send and receive messages using the SIP protocol (used in
         * telecommunications).
         * 
         * Category: mobile
         * Since: 2.5
         * Maven coordinates: org.apache.camel:camel-sip
         * 
         * Syntax: <code>sips:uri</code>
         * 
         * Path parameter: uri (required)
         * URI of the SIP server to connect to (the username and password can be
         * included such as: john:secretmyserver:9999)
         * 
         * @param path uri
         * @return the dsl builder
         */
        default SipEndpointBuilder sips(String path) {
            return SipEndpointBuilderFactory.endpointBuilder("sips", path);
        }
    }
    static SipEndpointBuilder endpointBuilder(String componentName, String path) {
        class SipEndpointBuilderImpl extends AbstractEndpointBuilder implements SipEndpointBuilder, AdvancedSipEndpointBuilder {
            public SipEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SipEndpointBuilderImpl(path);
    }
}