/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Perform operations on MongoDB documents and collections.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MongoDbEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the MongoDB component.
     */
    public interface MongoDbEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMongoDbEndpointConsumerBuilder advanced() {
            return (AdvancedMongoDbEndpointConsumerBuilder) this;
        }
        /**
         * Sets the name of the MongoDB collection to bind to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * Sets the collection index (JSON FORMAT : { field1 : order1, field2 :
         * order2}).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collectionIndex the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder collectionIndex(
                String collectionIndex) {
            doSetProperty("collectionIndex", collectionIndex);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder createCollection(
                boolean createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder createCollection(
                String createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Sets the name of the MongoDB database to target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param database the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder database(String database) {
            doSetProperty("database", database);
            return this;
        }
        /**
         * Host address of mongodb server in host:port format. It's possible
         * also use more than one address, as comma separated list of hosts:
         * host1:port1,host2:port2. If hosts parameter is specified, provided
         * connectionBean is ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option is a:
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder mongoConnection(
                Object mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder mongoConnection(
                String mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder operation(
                MongoDbOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder outputType(
                MongoDbOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Consumer type.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param consumerType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder consumerType(String consumerType) {
            doSetProperty("consumerType", consumerType);
            return this;
        }
        /**
         * Filter condition for change streams consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: changeStream
         * 
         * @param streamFilter the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder streamFilter(String streamFilter) {
            doSetProperty("streamFilter", streamFilter);
            return this;
        }
        /**
         * User password for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * One tail tracking collection can host many trackers for several
         * tailable consumers. To keep them separate, each tracker should have
         * its own unique persistentId.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param persistentId the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder persistentId(String persistentId) {
            doSetProperty("persistentId", persistentId);
            return this;
        }
        /**
         * Enable persistent tail tracking, which is a mechanism to keep track
         * of the last consumed message across system restarts. The next time
         * the system is up, the endpoint will recover the cursor from the point
         * where it last stopped slurping records.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: tail
         * 
         * @param persistentTailTracking the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder persistentTailTracking(
                boolean persistentTailTracking) {
            doSetProperty("persistentTailTracking", persistentTailTracking);
            return this;
        }
        /**
         * Enable persistent tail tracking, which is a mechanism to keep track
         * of the last consumed message across system restarts. The next time
         * the system is up, the endpoint will recover the cursor from the point
         * where it last stopped slurping records.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: tail
         * 
         * @param persistentTailTracking the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder persistentTailTracking(
                String persistentTailTracking) {
            doSetProperty("persistentTailTracking", persistentTailTracking);
            return this;
        }
        /**
         * Collection where tail tracking information will be persisted. If not
         * specified, MongoDbTailTrackingConfig#DEFAULT_COLLECTION will be used
         * by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder tailTrackCollection(
                String tailTrackCollection) {
            doSetProperty("tailTrackCollection", tailTrackCollection);
            return this;
        }
        /**
         * Indicates what database the tail tracking mechanism will persist to.
         * If not specified, the current database will be picked by default.
         * Dynamicity will not be taken into account even if enabled, i.e. the
         * tail tracking database will not vary past endpoint initialisation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackDb the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder tailTrackDb(String tailTrackDb) {
            doSetProperty("tailTrackDb", tailTrackDb);
            return this;
        }
        /**
         * Field where the last tracked value will be placed. If not specified,
         * MongoDbTailTrackingConfig#DEFAULT_FIELD will be used by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackField the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder tailTrackField(
                String tailTrackField) {
            doSetProperty("tailTrackField", tailTrackField);
            return this;
        }
        /**
         * Correlation field in the incoming record which is of increasing
         * nature and will be used to position the tailing cursor every time it
         * is generated. The cursor will be (re)created with a query of type:
         * tailTrackIncreasingField greater than lastValue (possibly recovered
         * from persistent tail tracking). Can be of type Integer, Date, String,
         * etc. NOTE: No support for dot notation at the current time, so the
         * field should be at the top level of the document.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackIncreasingField the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder tailTrackIncreasingField(
                String tailTrackIncreasingField) {
            doSetProperty("tailTrackIncreasingField", tailTrackIncreasingField);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the MongoDB component.
     */
    public interface AdvancedMongoDbEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MongoDbEndpointConsumerBuilder basic() {
            return (MongoDbEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder cursorRegenerationDelay(
                long cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder cursorRegenerationDelay(
                String cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder dynamicity(
                boolean dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder dynamicity(
                String dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Configure how MongoDB clients route read operations to the members of
         * a replica set. Possible values are PRIMARY, PRIMARY_PREFERRED,
         * SECONDARY, SECONDARY_PREFERRED or NEAREST.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PRIMARY
         * Group: advanced
         * 
         * @param readPreference the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder readPreference(
                String readPreference) {
            doSetProperty("readPreference", readPreference);
            return this;
        }
        /**
         * Configure the connection bean with the level of acknowledgment
         * requested from MongoDB for write operations to a standalone mongod,
         * replicaset or cluster. Possible values are ACKNOWLEDGED, W1, W2, W3,
         * UNACKNOWLEDGED, JOURNALED or MAJORITY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ACKNOWLEDGED
         * Group: advanced
         * 
         * @param writeConcern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder writeConcern(
                String writeConcern) {
            doSetProperty("writeConcern", writeConcern);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder writeResultAsHeader(
                boolean writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder writeResultAsHeader(
                String writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the MongoDB component.
     */
    public interface MongoDbEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMongoDbEndpointProducerBuilder advanced() {
            return (AdvancedMongoDbEndpointProducerBuilder) this;
        }
        /**
         * Sets the name of the MongoDB collection to bind to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * Sets the collection index (JSON FORMAT : { field1 : order1, field2 :
         * order2}).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collectionIndex the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder collectionIndex(
                String collectionIndex) {
            doSetProperty("collectionIndex", collectionIndex);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder createCollection(
                boolean createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder createCollection(
                String createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Sets the name of the MongoDB database to target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param database the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder database(String database) {
            doSetProperty("database", database);
            return this;
        }
        /**
         * Host address of mongodb server in host:port format. It's possible
         * also use more than one address, as comma separated list of hosts:
         * host1:port1,host2:port2. If hosts parameter is specified, provided
         * connectionBean is ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option is a:
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder mongoConnection(
                Object mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder mongoConnection(
                String mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder operation(
                MongoDbOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder outputType(
                MongoDbOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Filter condition for change streams consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: changeStream
         * 
         * @param streamFilter the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder streamFilter(String streamFilter) {
            doSetProperty("streamFilter", streamFilter);
            return this;
        }
        /**
         * User password for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * One tail tracking collection can host many trackers for several
         * tailable consumers. To keep them separate, each tracker should have
         * its own unique persistentId.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param persistentId the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder persistentId(String persistentId) {
            doSetProperty("persistentId", persistentId);
            return this;
        }
        /**
         * Enable persistent tail tracking, which is a mechanism to keep track
         * of the last consumed message across system restarts. The next time
         * the system is up, the endpoint will recover the cursor from the point
         * where it last stopped slurping records.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: tail
         * 
         * @param persistentTailTracking the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder persistentTailTracking(
                boolean persistentTailTracking) {
            doSetProperty("persistentTailTracking", persistentTailTracking);
            return this;
        }
        /**
         * Enable persistent tail tracking, which is a mechanism to keep track
         * of the last consumed message across system restarts. The next time
         * the system is up, the endpoint will recover the cursor from the point
         * where it last stopped slurping records.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: tail
         * 
         * @param persistentTailTracking the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder persistentTailTracking(
                String persistentTailTracking) {
            doSetProperty("persistentTailTracking", persistentTailTracking);
            return this;
        }
        /**
         * Collection where tail tracking information will be persisted. If not
         * specified, MongoDbTailTrackingConfig#DEFAULT_COLLECTION will be used
         * by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder tailTrackCollection(
                String tailTrackCollection) {
            doSetProperty("tailTrackCollection", tailTrackCollection);
            return this;
        }
        /**
         * Indicates what database the tail tracking mechanism will persist to.
         * If not specified, the current database will be picked by default.
         * Dynamicity will not be taken into account even if enabled, i.e. the
         * tail tracking database will not vary past endpoint initialisation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackDb the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder tailTrackDb(String tailTrackDb) {
            doSetProperty("tailTrackDb", tailTrackDb);
            return this;
        }
        /**
         * Field where the last tracked value will be placed. If not specified,
         * MongoDbTailTrackingConfig#DEFAULT_FIELD will be used by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackField the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder tailTrackField(
                String tailTrackField) {
            doSetProperty("tailTrackField", tailTrackField);
            return this;
        }
        /**
         * Correlation field in the incoming record which is of increasing
         * nature and will be used to position the tailing cursor every time it
         * is generated. The cursor will be (re)created with a query of type:
         * tailTrackIncreasingField greater than lastValue (possibly recovered
         * from persistent tail tracking). Can be of type Integer, Date, String,
         * etc. NOTE: No support for dot notation at the current time, so the
         * field should be at the top level of the document.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackIncreasingField the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder tailTrackIncreasingField(
                String tailTrackIncreasingField) {
            doSetProperty("tailTrackIncreasingField", tailTrackIncreasingField);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the MongoDB component.
     */
    public interface AdvancedMongoDbEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default MongoDbEndpointProducerBuilder basic() {
            return (MongoDbEndpointProducerBuilder) this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder cursorRegenerationDelay(
                long cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder cursorRegenerationDelay(
                String cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder dynamicity(
                boolean dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder dynamicity(
                String dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Configure how MongoDB clients route read operations to the members of
         * a replica set. Possible values are PRIMARY, PRIMARY_PREFERRED,
         * SECONDARY, SECONDARY_PREFERRED or NEAREST.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PRIMARY
         * Group: advanced
         * 
         * @param readPreference the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder readPreference(
                String readPreference) {
            doSetProperty("readPreference", readPreference);
            return this;
        }
        /**
         * Configure the connection bean with the level of acknowledgment
         * requested from MongoDB for write operations to a standalone mongod,
         * replicaset or cluster. Possible values are ACKNOWLEDGED, W1, W2, W3,
         * UNACKNOWLEDGED, JOURNALED or MAJORITY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ACKNOWLEDGED
         * Group: advanced
         * 
         * @param writeConcern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder writeConcern(
                String writeConcern) {
            doSetProperty("writeConcern", writeConcern);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder writeResultAsHeader(
                boolean writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder writeResultAsHeader(
                String writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
    }

    /**
     * Builder for endpoint for the MongoDB component.
     */
    public interface MongoDbEndpointBuilder
            extends
                MongoDbEndpointConsumerBuilder,
                MongoDbEndpointProducerBuilder {
        default AdvancedMongoDbEndpointBuilder advanced() {
            return (AdvancedMongoDbEndpointBuilder) this;
        }
        /**
         * Sets the name of the MongoDB collection to bind to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * Sets the collection index (JSON FORMAT : { field1 : order1, field2 :
         * order2}).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collectionIndex the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder collectionIndex(String collectionIndex) {
            doSetProperty("collectionIndex", collectionIndex);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder createCollection(boolean createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder createCollection(String createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Sets the name of the MongoDB database to target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param database the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder database(String database) {
            doSetProperty("database", database);
            return this;
        }
        /**
         * Host address of mongodb server in host:port format. It's possible
         * also use more than one address, as comma separated list of hosts:
         * host1:port1,host2:port2. If hosts parameter is specified, provided
         * connectionBean is ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option is a:
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder mongoConnection(Object mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder mongoConnection(String mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder operation(MongoDbOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder outputType(MongoDbOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Filter condition for change streams consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: changeStream
         * 
         * @param streamFilter the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder streamFilter(String streamFilter) {
            doSetProperty("streamFilter", streamFilter);
            return this;
        }
        /**
         * User password for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * One tail tracking collection can host many trackers for several
         * tailable consumers. To keep them separate, each tracker should have
         * its own unique persistentId.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param persistentId the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder persistentId(String persistentId) {
            doSetProperty("persistentId", persistentId);
            return this;
        }
        /**
         * Enable persistent tail tracking, which is a mechanism to keep track
         * of the last consumed message across system restarts. The next time
         * the system is up, the endpoint will recover the cursor from the point
         * where it last stopped slurping records.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: tail
         * 
         * @param persistentTailTracking the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder persistentTailTracking(
                boolean persistentTailTracking) {
            doSetProperty("persistentTailTracking", persistentTailTracking);
            return this;
        }
        /**
         * Enable persistent tail tracking, which is a mechanism to keep track
         * of the last consumed message across system restarts. The next time
         * the system is up, the endpoint will recover the cursor from the point
         * where it last stopped slurping records.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: tail
         * 
         * @param persistentTailTracking the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder persistentTailTracking(
                String persistentTailTracking) {
            doSetProperty("persistentTailTracking", persistentTailTracking);
            return this;
        }
        /**
         * Collection where tail tracking information will be persisted. If not
         * specified, MongoDbTailTrackingConfig#DEFAULT_COLLECTION will be used
         * by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder tailTrackCollection(
                String tailTrackCollection) {
            doSetProperty("tailTrackCollection", tailTrackCollection);
            return this;
        }
        /**
         * Indicates what database the tail tracking mechanism will persist to.
         * If not specified, the current database will be picked by default.
         * Dynamicity will not be taken into account even if enabled, i.e. the
         * tail tracking database will not vary past endpoint initialisation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackDb the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder tailTrackDb(String tailTrackDb) {
            doSetProperty("tailTrackDb", tailTrackDb);
            return this;
        }
        /**
         * Field where the last tracked value will be placed. If not specified,
         * MongoDbTailTrackingConfig#DEFAULT_FIELD will be used by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackField the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder tailTrackField(String tailTrackField) {
            doSetProperty("tailTrackField", tailTrackField);
            return this;
        }
        /**
         * Correlation field in the incoming record which is of increasing
         * nature and will be used to position the tailing cursor every time it
         * is generated. The cursor will be (re)created with a query of type:
         * tailTrackIncreasingField greater than lastValue (possibly recovered
         * from persistent tail tracking). Can be of type Integer, Date, String,
         * etc. NOTE: No support for dot notation at the current time, so the
         * field should be at the top level of the document.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackIncreasingField the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder tailTrackIncreasingField(
                String tailTrackIncreasingField) {
            doSetProperty("tailTrackIncreasingField", tailTrackIncreasingField);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the MongoDB component.
     */
    public interface AdvancedMongoDbEndpointBuilder
            extends
                AdvancedMongoDbEndpointConsumerBuilder,
                AdvancedMongoDbEndpointProducerBuilder {
        default MongoDbEndpointBuilder basic() {
            return (MongoDbEndpointBuilder) this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder cursorRegenerationDelay(
                long cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder cursorRegenerationDelay(
                String cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder dynamicity(boolean dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder dynamicity(String dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Configure how MongoDB clients route read operations to the members of
         * a replica set. Possible values are PRIMARY, PRIMARY_PREFERRED,
         * SECONDARY, SECONDARY_PREFERRED or NEAREST.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PRIMARY
         * Group: advanced
         * 
         * @param readPreference the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder readPreference(
                String readPreference) {
            doSetProperty("readPreference", readPreference);
            return this;
        }
        /**
         * Configure the connection bean with the level of acknowledgment
         * requested from MongoDB for write operations to a standalone mongod,
         * replicaset or cluster. Possible values are ACKNOWLEDGED, W1, W2, W3,
         * UNACKNOWLEDGED, JOURNALED or MAJORITY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ACKNOWLEDGED
         * Group: advanced
         * 
         * @param writeConcern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder writeConcern(String writeConcern) {
            doSetProperty("writeConcern", writeConcern);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder writeResultAsHeader(
                boolean writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder writeResultAsHeader(
                String writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.mongodb.MongoDbOperation</code> enum.
     */
    enum MongoDbOperation {
        findById,
        findOneByQuery,
        findAll,
        findDistinct,
        insert,
        save,
        update,
        remove,
        bulkWrite,
        aggregate,
        getDbStats,
        getColStats,
        count,
        command;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.mongodb.MongoDbOutputType</code> enum.
     */
    enum MongoDbOutputType {
        DocumentList,
        Document,
        MongoIterable;
    }

    public interface MongoDbBuilders {
        /**
         * MongoDB (camel-mongodb)
         * Perform operations on MongoDB documents and collections.
         * 
         * Category: database,nosql
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-mongodb
         * 
         * Syntax: <code>mongodb:connectionBean</code>
         * 
         * Path parameter: connectionBean (required)
         * Sets the connection bean reference used to lookup a client for
         * connecting to a database.
         * 
         * @param path connectionBean
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder mongodb(String path) {
            return MongoDbEndpointBuilderFactory.endpointBuilder("mongodb", path);
        }
        /**
         * MongoDB (camel-mongodb)
         * Perform operations on MongoDB documents and collections.
         * 
         * Category: database,nosql
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-mongodb
         * 
         * Syntax: <code>mongodb:connectionBean</code>
         * 
         * Path parameter: connectionBean (required)
         * Sets the connection bean reference used to lookup a client for
         * connecting to a database.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path connectionBean
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder mongodb(String componentName, String path) {
            return MongoDbEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static MongoDbEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class MongoDbEndpointBuilderImpl extends AbstractEndpointBuilder implements MongoDbEndpointBuilder, AdvancedMongoDbEndpointBuilder {
            public MongoDbEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new MongoDbEndpointBuilderImpl(path);
    }
}