/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.language.joor;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.camel.spi.Language;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JoorScriptingLanguageTest extends CamelTestSupport {

    @Test
    public void testScripting() throws Exception {
        Language lan = context.resolveLanguage("joor");
        Assertions.assertTrue(lan instanceof ScriptingLanguage);

        ScriptingLanguage slan = (ScriptingLanguage) lan;
        int num = slan.evaluate("2 * 3", null, int.class);
        Assertions.assertEquals(6, num);

        MyUser user = new MyUser();
        user.setAge(33);
        user.setName("Scott");
        Map<String, Object> bindings = new LinkedHashMap<>();
        bindings.put("user", user);
        String out = slan.evaluate("'Hello ' + user.getName() + ' you are ' + user.getAge() + ' years old'", bindings,
                String.class);
        Assertions.assertEquals("Hello Scott you are 33 years old", out);
    }
}
