/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.executor;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.javalang.BrooklynHttpConfig;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.executor.HttpExecutorFactory;
import org.apache.brooklyn.util.http.executor.HttpExecutor;
import org.apache.brooklyn.util.http.executor.apacheclient.HttpExecutorImpl;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExecutorFactoryImpl
implements HttpExecutorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpExecutorFactoryImpl.class);

    @Override
    public HttpExecutor getHttpExecutor(Map<?, ?> props) {
        HttpExecutor httpExecutor;
        String httpExecutorClass = (String)props.get("httpExecutorClass");
        if (httpExecutorClass != null) {
            MutableMap httpExecutorProps = MutableMap.of();
            Map executorProps = Maps.filterKeys(props, (Predicate)StringPredicates.isStringStartingWith((String)"httpExecutorClass."));
            if (executorProps.size() > 0) {
                for (Map.Entry entry : executorProps.entrySet()) {
                    String keyName = Strings.removeFromStart((String)((String)entry.getKey()), (String)"httpExecutorClass.");
                    httpExecutorProps.put(keyName, entry.getValue());
                }
            }
            try {
                httpExecutor = (HttpExecutor)new ClassLoaderUtils(this.getClass()).loadClass(httpExecutorClass).getConstructor(Map.class).newInstance(httpExecutorProps);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else {
            LOG.info("httpExecutorClass parameter not provided. Using the default implementation " + HttpExecutorImpl.class.getName());
            httpExecutor = BrooklynHttpConfig.newHttpExecutorDefault();
        }
        return httpExecutor;
    }
}

