/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.flow;

import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;

public class SleepWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "${duration}";
    public static final ConfigKey<Duration> DURATION = ConfigKeys.newConfigKey(Duration.class, "duration");

    @Override
    public void populateFromShorthand(String value) {
        this.populateFromShorthandTemplate(SHORTHAND, value);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        Duration duration = context.getInput(DURATION);
        if (duration == null) {
            throw new IllegalStateException("Duration for sleep not specified");
        }
        Time.sleep((Duration)duration);
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

