/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.reflect.TypeToken;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.typereg.BasicRegisteredType;
import org.apache.brooklyn.core.typereg.BasicTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.JavaClassNameTypePlanTransformer;
import org.apache.brooklyn.core.typereg.RegisteredTypeKindVisitor;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.NaturalOrderComparator;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.VersionComparator;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredTypes {
    private static final Logger log = LoggerFactory.getLogger(RegisteredTypes.class);
    static ConfigKey<Class<?>> ACTUAL_JAVA_TYPE = ConfigKeys.newConfigKey(new TypeToken<Class<?>>(){}, "java.type.actual", "The actual Java type which will be instantiated (bean) or pointed at (spec)");
    @Deprecated
    static final Function<CatalogItem<?, ?>, RegisteredType> CI_TO_RT = new Function<CatalogItem<?, ?>, RegisteredType>(){

        public RegisteredType apply(CatalogItem<?, ?> item) {
            return RegisteredTypes.of(item);
        }
    };

    @Deprecated
    public static RegisteredType of(CatalogItem<?, ?> item) {
        if (item == null) {
            return null;
        }
        BasicTypeImplementationPlan impl = null;
        if (item.getPlanYaml() != null) {
            impl = new BasicTypeImplementationPlan(null, item.getPlanYaml());
        } else if (item.getJavaType() != null) {
            impl = new JavaClassNameTypePlanTransformer.JavaClassNameTypeImplementationPlan(item.getJavaType());
        } else {
            throw new IllegalStateException("Unsupported catalog item " + item + " when trying to create RegisteredType");
        }
        BasicRegisteredType type = (BasicRegisteredType)RegisteredTypes.spec(item.getSymbolicName(), item.getVersion(), impl);
        RegisteredTypes.addSuperType((RegisteredType)type, item.getCatalogItemJavaType());
        type.containingBundle = item.getContainingBundle();
        type.displayName = item.getDisplayName();
        type.description = item.getDescription();
        type.iconUrl = item.getIconUrl();
        type.disabled = item.isDisabled();
        type.deprecated = item.isDeprecated();
        if (item.getLibraries() != null) {
            type.bundles.addAll(item.getLibraries());
        }
        if (item.tags() != null) {
            type.tags.addAll(item.tags().getTags());
        }
        if (item.getCatalogItemType() == CatalogItem.CatalogItemType.TEMPLATE) {
            type.tags.add(BrooklynTags.CATALOG_TEMPLATE);
        }
        return type;
    }

    @Deprecated
    public static CatalogItem<?, ?> toPartialCatalogItem(RegisteredType t) {
        return new CatalogItemFromRegisteredType(t);
    }

    public static RegisteredType bean(@Nonnull String symbolicName, @Nonnull String version, @Nonnull RegisteredType.TypeImplementationPlan plan) {
        if (symbolicName == null || version == null) {
            log.warn("Deprecated use of RegisteredTypes API passing null name/version", (Throwable)new Exception("Location of deprecated use, wrt " + plan));
        }
        return new BasicRegisteredType(BrooklynTypeRegistry.RegisteredTypeKind.BEAN, symbolicName, version, plan);
    }

    @Deprecated
    public static RegisteredType bean(@Nonnull String symbolicName, @Nonnull String version, @Nonnull RegisteredType.TypeImplementationPlan plan, @Nonnull Class<?> superType) {
        if (superType == null) {
            log.warn("Deprecated use of RegisteredTypes API passing null supertype", (Throwable)new Exception("Location of deprecated use, wrt " + symbolicName + ":" + version + " " + plan));
        }
        return RegisteredTypes.addSuperType(RegisteredTypes.bean(symbolicName, version, plan), superType);
    }

    public static RegisteredType spec(@Nonnull String symbolicName, @Nonnull String version, @Nonnull RegisteredType.TypeImplementationPlan plan) {
        if (symbolicName == null || version == null) {
            log.warn("Deprecated use of RegisteredTypes API passing null supertype", (Throwable)new Exception("Location of deprecated use, wrt " + plan));
        }
        return new BasicRegisteredType(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, symbolicName, version, plan);
    }

    public static RegisteredType spec(@Nonnull String symbolicName, @Nonnull String version, @Nonnull RegisteredType.TypeImplementationPlan plan, @Nonnull Class<?> superType) {
        if (superType == null) {
            log.warn("Deprecated use of RegisteredTypes API passing null supertype", (Throwable)new Exception("Location of deprecated use, wrt " + symbolicName + ":" + version + " " + plan));
        }
        return RegisteredTypes.addSuperType(RegisteredTypes.spec(symbolicName, version, plan), superType);
    }

    public static RegisteredType newInstance(@Nonnull BrooklynTypeRegistry.RegisteredTypeKind kind, @Nonnull String symbolicName, @Nonnull String version, @Nonnull RegisteredType.TypeImplementationPlan plan, @Nonnull Iterable<Object> superTypes, Iterable<String> aliases, Iterable<Object> tags, String containingBundle, Iterable<OsgiBundleWithUrl> libraryBundles, String displayName, String description, String catalogIconUrl, Boolean catalogDeprecated, Boolean catalogDisabled) {
        BasicRegisteredType result = new BasicRegisteredType(kind, symbolicName, version, plan);
        RegisteredTypes.addSuperTypes(result, superTypes);
        RegisteredTypes.addAliases(result, aliases);
        RegisteredTypes.addTags(result, tags);
        result.containingBundle = containingBundle;
        Iterables.addAll(result.bundles, libraryBundles);
        result.displayName = displayName;
        result.description = description;
        result.iconUrl = catalogIconUrl;
        if (catalogDeprecated != null) {
            result.deprecated = catalogDeprecated;
        }
        if (catalogDisabled != null) {
            result.disabled = catalogDisabled;
        }
        return result;
    }

    public static RegisteredType copy(RegisteredType t) {
        return RegisteredTypes.copyResolved(t.getKind(), t);
    }

    @Beta
    public static RegisteredType copyResolved(BrooklynTypeRegistry.RegisteredTypeKind kind, RegisteredType t) {
        return RegisteredTypes.copyResolved(kind, t, false);
    }

    public static RegisteredType copyResolved(BrooklynTypeRegistry.RegisteredTypeKind kind, RegisteredType t, boolean allowChangingKind) {
        if (!allowChangingKind && t.getKind() != null && t.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && t.getKind() != kind) {
            throw new IllegalStateException("Cannot copy resolve " + t + " (" + t.getKind() + ") as " + kind);
        }
        return RegisteredTypes.newInstance(kind, t.getSymbolicName(), t.getVersion(), t.getPlan(), t.getSuperTypes(), t.getAliases(), t.getTags(), t.getContainingBundle(), t.getLibraries(), t.getDisplayName(), t.getDescription(), t.getIconUrl(), t.isDeprecated(), t.isDisabled());
    }

    @Beta
    public static RegisteredType anonymousRegisteredType(BrooklynTypeRegistry.RegisteredTypeKind kind, RegisteredType.TypeImplementationPlan plan) {
        return new BasicRegisteredType(kind, null, null, plan);
    }

    @Beta
    public static Class<?> loadActualJavaType(String javaTypeName, ManagementContext mgmt, RegisteredType type, RegisteredTypeLoadingContext context) {
        Class result = RegisteredTypes.peekActualJavaType(type);
        if (result != null) {
            return result;
        }
        result = CatalogUtils.newClassLoadingContext(mgmt, type, context == null ? null : context.getLoader()).loadClass(javaTypeName);
        RegisteredTypes.cacheActualJavaType(type, result);
        return result;
    }

    @Beta
    public static Class<?> peekActualJavaType(RegisteredType type) {
        return ((BasicRegisteredType)type).getCache().get(ACTUAL_JAVA_TYPE);
    }

    @Beta
    public static void cacheActualJavaType(RegisteredType type, Class<?> clazz) {
        ((BasicRegisteredType)type).getCache().put(ACTUAL_JAVA_TYPE, clazz);
    }

    @Beta
    public static RegisteredType setContainingBundle(RegisteredType type, @Nullable ManagedBundle bundle) {
        ((BasicRegisteredType)type).containingBundle = bundle == null ? null : Strings.toString((Object)bundle.getVersionedName());
        return type;
    }

    @Beta
    public static RegisteredType setDeprecated(RegisteredType type, boolean deprecated) {
        ((BasicRegisteredType)type).deprecated = deprecated;
        return type;
    }

    @Beta
    public static RegisteredType setDisabled(RegisteredType type, boolean disabled) {
        ((BasicRegisteredType)type).disabled = disabled;
        return type;
    }

    @Beta
    public static RegisteredType addSuperType(RegisteredType type, @Nullable Class<?> superType) {
        if (superType != null) {
            ((BasicRegisteredType)type).superTypes.add(superType);
        }
        return type;
    }

    @Beta
    public static RegisteredType addSuperType(RegisteredType type, @Nullable RegisteredType superType) {
        if (superType != null) {
            if (RegisteredTypes.isSubtypeOf(superType, type)) {
                throw new IllegalStateException(superType + " declares " + type + " as a supertype; cannot set " + superType + " as a supertype of " + type);
            }
            ((BasicRegisteredType)type).superTypes.add(superType);
        }
        return type;
    }

    @Beta
    public static RegisteredType addSuperTypes(RegisteredType type, Iterable<? extends Object> superTypesAsClassOrRegisteredType) {
        if (superTypesAsClassOrRegisteredType != null) {
            for (Object object : superTypesAsClassOrRegisteredType) {
                if (object == null) continue;
                if (object instanceof Class) {
                    RegisteredTypes.addSuperType(type, (Class)object);
                    continue;
                }
                if (object instanceof RegisteredType) {
                    RegisteredTypes.addSuperType(type, (RegisteredType)object);
                    continue;
                }
                throw new IllegalStateException(object + " supplied as a supertype of " + type + " but it is not a supported supertype");
            }
        }
        return type;
    }

    @Beta
    public static RegisteredType addAlias(RegisteredType type, String alias) {
        if (alias != null) {
            ((BasicRegisteredType)type).aliases.add(alias);
        }
        return type;
    }

    @Beta
    public static RegisteredType addAliases(RegisteredType type, Iterable<String> aliases) {
        if (aliases != null) {
            for (String alias : aliases) {
                RegisteredTypes.addAlias(type, alias);
            }
        }
        return type;
    }

    @Beta
    public static RegisteredType addTag(RegisteredType type, Object tag) {
        if (tag != null) {
            ((BasicRegisteredType)type).tags.add(tag);
        }
        return type;
    }

    @Beta
    public static RegisteredType addTags(RegisteredType type, Iterable<?> tags) {
        if (tags != null) {
            for (Object tag : tags) {
                RegisteredTypes.addTag(type, tag);
            }
        }
        return type;
    }

    @Beta
    public static String getImplementationDataStringForSpec(RegisteredType item) {
        if (item == null || item.getPlan() == null) {
            return null;
        }
        Object data = item.getPlan().getPlanData();
        if (data == null) {
            return null;
        }
        if (!(data instanceof String)) {
            throw new IllegalStateException("Expected plan data for " + item + " to be a string");
        }
        return (String)data;
    }

    @Beta
    public static AbstractBrooklynObjectSpec<?, ?> newSpecInstance(ManagementContext mgmt, Class<? extends BrooklynObject> targetType) throws Exception {
        Class<AbstractBrooklynObjectSpec<?, ?>> specType = RegisteredTypeLoadingContexts.lookupSpecTypeForTarget(targetType);
        if (specType == null) {
            return null;
        }
        Method createMethod = specType.getMethod("create", Class.class);
        return (AbstractBrooklynObjectSpec)createMethod.invoke(null, targetType);
    }

    public static Maybe<Map<?, ?>> getAsYamlMap(Object planData) {
        Iterable result;
        if (!(planData instanceof String)) {
            return Maybe.absent((String)"not a string");
        }
        try {
            result = Yamls.parseAll((String)((String)planData));
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return Maybe.absent((Throwable)e);
        }
        Iterator ri = result.iterator();
        if (!ri.hasNext()) {
            return Maybe.absent((String)"YAML has no elements in it");
        }
        Object r1 = ri.next();
        if (ri.hasNext()) {
            return Maybe.absent((String)"YAML has multiple elements in it");
        }
        if (r1 instanceof Map) {
            return Maybe.of(r1);
        }
        return Maybe.absent((String)"YAML does not contain a map");
    }

    public static boolean isSubtypeOf(RegisteredType type, RegisteredType superType) {
        if (type.equals((Object)superType)) {
            return true;
        }
        for (Object st : type.getSuperTypes()) {
            if (!(st instanceof RegisteredType) || !RegisteredTypes.isSubtypeOf((RegisteredType)st, superType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubtypeOf(RegisteredType type, Class<?> superType) {
        return RegisteredTypes.isAnyTypeSubtypeOf((Set<Object>)type.getSuperTypes(), superType);
    }

    public static boolean isAnyTypeSubtypeOf(Set<Object> candidateTypes, final Class<?> superType) {
        if (superType == Object.class) {
            return true;
        }
        return RegisteredTypes.isAnyTypeOrSuper(candidateTypes, new Predicate<Object>(){

            public boolean apply(Object input) {
                return input instanceof Class && superType.isAssignableFrom((Class)input);
            }
        });
    }

    public static boolean isAnyTypeSubtypeOf(Set<Object> candidateTypes, final String superType) {
        if (Object.class.getName().equals(superType)) {
            return true;
        }
        return RegisteredTypes.isAnyTypeOrSuper(candidateTypes, new Predicate<Object>(){

            public boolean apply(Object input) {
                if (input instanceof Class) {
                    input = ((Class)input).getName();
                }
                return superType.equals(input);
            }
        });
    }

    public static boolean isAnyTypeOrSuper(Set<Object> candidateTypes, Predicate<Object> filter) {
        for (Object st : candidateTypes) {
            if (!filter.apply(st)) continue;
            return true;
        }
        for (Object st : candidateTypes) {
            if (!(st instanceof RegisteredType) || !RegisteredTypes.isAnyTypeOrSuper(((RegisteredType)st).getSuperTypes(), filter)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isAnyTypeOrSuperSatisfying(Set<Object> candidateTypes, Predicate<Class<?>> filter) {
        for (Object st : candidateTypes) {
            if (!(st instanceof Class) || !filter.apply((Object)((Class)st))) continue;
            return true;
        }
        for (Object st : candidateTypes) {
            if (!(st instanceof RegisteredType) || !RegisteredTypes.isAnyTypeOrSuperSatisfying(((RegisteredType)st).getSuperTypes(), filter)) continue;
            return true;
        }
        return false;
    }

    public static Maybe<RegisteredType> tryValidate(RegisteredType item, RegisteredTypeLoadingContext constraint) {
        if (item == null || constraint == null) {
            return Maybe.ofDisallowingNull((Object)item);
        }
        if (constraint.getExpectedKind() != null && !constraint.getExpectedKind().equals((Object)item.getKind())) {
            return Maybe.absent((String)(item + " is not the expected kind " + constraint.getExpectedKind()));
        }
        if (constraint.getExpectedJavaSuperType() != null && !RegisteredTypes.isSubtypeOf(item, constraint.getExpectedJavaSuperType())) {
            return Maybe.absent((String)(item + " is not for the expected type " + constraint.getExpectedJavaSuperType()));
        }
        return Maybe.of((Object)item);
    }

    private static boolean isSubtypeOf(Class<?> candidate, RegisteredType type) {
        for (Object st : type.getSuperTypes()) {
            if (st instanceof RegisteredType && !RegisteredTypes.isSubtypeOf(candidate, (RegisteredType)st)) {
                return false;
            }
            if (!(st instanceof Class) || ((Class)st).isAssignableFrom(candidate)) continue;
            return false;
        }
        return true;
    }

    public static RegisteredType getBestVersion(Iterable<RegisteredType> types) {
        if (types == null || !types.iterator().hasNext()) {
            return null;
        }
        return (RegisteredType)Ordering.from(RegisteredTypeNameThenBestFirstComparator.INSTANCE).min(types);
    }

    public static RegisteredType getBestVersionInContext(Iterable<RegisteredType> types, RegisteredTypeLoadingContext context) {
        if (types == null) {
            return null;
        }
        Iterator<RegisteredType> ti = types.iterator();
        if (!ti.hasNext()) {
            return null;
        }
        RegisteredType first = ti.next();
        if (!ti.hasNext()) {
            return first;
        }
        if (context != null && context.getLoader() != null) {
            Collection preferredBundles = context.getLoader().getBundles();
            for (OsgiBundleWithUrl b : preferredBundles) {
                Iterable typesInBundle = Iterables.filter(types, t -> t.getContainingBundle() != null && Objects.equal((Object)VersionedName.fromString((String)t.getContainingBundle()).toOsgiString(), (Object)b.getVersionedName().toOsgiString()));
                if (!typesInBundle.iterator().hasNext()) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Preferring " + typesInBundle + " from " + types + " because its bundle is in the explicit loader list");
                }
                types = typesInBundle;
                break;
            }
        }
        return RegisteredTypes.getBestVersion(types);
    }

    public static <T> Maybe<T> tryValidate(final T object, final @Nullable RegisteredType type, final @Nullable RegisteredTypeLoadingContext context) {
        BrooklynTypeRegistry.RegisteredTypeKind kind;
        if (object == null) {
            return Maybe.absentNull((String)"object is null");
        }
        Object object2 = type != null ? type.getKind() : (kind = context != null ? context.getExpectedKind() : null);
        if (kind == null) {
            kind = object instanceof AbstractBrooklynObjectSpec ? BrooklynTypeRegistry.RegisteredTypeKind.SPEC : BrooklynTypeRegistry.RegisteredTypeKind.BEAN;
        }
        return (Maybe)new RegisteredTypeKindVisitor<Maybe<T>>(){

            @Override
            protected Maybe<T> visitSpec() {
                return RegisteredTypes.tryValidateSpec(object, type, context);
            }

            @Override
            protected Maybe<T> visitBean() {
                return RegisteredTypes.tryValidateBean(object, type, context);
            }

            @Override
            protected Maybe<T> visitUnresolved() {
                log.debug("Request for " + this + " to validate UNRESOLVED kind " + type + "; trying as spec");
                Maybe result = this.visitSpec();
                if (result.isPresent()) {
                    log.warn("Request to use " + this + " from UNRESOLVED state succeeded treating is as a spec");
                    log.debug("Trace for request to use " + this + " in UNRESOLVED state succeeding", new Throwable("Location of request to use " + this + " in UNRESOLVED state"));
                    return result;
                }
                return Maybe.absent((String)(object + " is not yet resolved"));
            }
        }.visit(kind);
    }

    private static <T> Maybe<T> tryValidateBean(T object, RegisteredType type, RegisteredTypeLoadingContext context) {
        if (object == null) {
            return Maybe.absentNull((String)"object is null");
        }
        if (type != null) {
            if (type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.BEAN) {
                return Maybe.absent((String)("Validating a bean when type is " + type.getKind() + " " + type));
            }
            if (!RegisteredTypes.isSubtypeOf(object.getClass(), type)) {
                return Maybe.absent((String)(object + " does not have all the java supertypes of " + type));
            }
        }
        if (context != null) {
            if (context.getExpectedKind() != null && context.getExpectedKind() != BrooklynTypeRegistry.RegisteredTypeKind.BEAN) {
                return Maybe.absent((String)("Validating a bean when constraint expected " + context.getExpectedKind()));
            }
            if (context.getExpectedJavaSuperType() != null && !context.getExpectedJavaSuperType().isInstance(object)) {
                return Maybe.absent((String)(object + " is not of the expected java supertype " + context.getExpectedJavaSuperType()));
            }
        }
        return Maybe.of(object);
    }

    private static <T> Maybe<T> tryValidateSpec(T object, RegisteredType rType, RegisteredTypeLoadingContext constraint) {
        Class targetType;
        if (object == null) {
            return Maybe.absentNull((String)"object is null");
        }
        if (!(object instanceof AbstractBrooklynObjectSpec)) {
            Maybe.absent((String)("Found " + object + " when expecting a spec"));
        }
        if ((targetType = ((AbstractBrooklynObjectSpec)object).getType()) == null) {
            Maybe.absent((String)("Spec " + object + " does not have a target type"));
        }
        if (rType != null) {
            if (rType.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
                Maybe.absent((String)("Validating a spec when type is " + rType.getKind() + " " + rType));
            }
            if (!RegisteredTypes.isSubtypeOf(targetType, rType)) {
                Maybe.absent((String)(object + " does not have all the java supertypes of " + rType));
            }
        }
        if (constraint != null && constraint.getExpectedJavaSuperType() != null) {
            if (!constraint.getExpectedJavaSuperType().isAssignableFrom(targetType)) {
                Maybe.absent((String)(object + " does not target the expected java supertype " + constraint.getExpectedJavaSuperType()));
            }
            if (!constraint.getExpectedJavaSuperType().isAssignableFrom(BrooklynObjectInternal.class)) {
                Class<AbstractBrooklynObjectSpec<?, ?>> specType = RegisteredTypeLoadingContexts.lookupSpecTypeForTarget(constraint.getExpectedJavaSuperType());
                if (specType == null) {
                    Maybe.absent((String)(object + " is returned as spec for unexpected java supertype " + constraint.getExpectedJavaSuperType()));
                }
                if (!specType.isAssignableFrom(object.getClass())) {
                    Maybe.absent((String)(object + " is not a spec of the expected java supertype " + constraint.getExpectedJavaSuperType()));
                }
            }
        }
        return Maybe.of(object);
    }

    public static String getIconUrl(BrooklynObject object) {
        if (object == null) {
            return null;
        }
        BrooklynTags.NamedStringTag fromTag = BrooklynTags.findFirstNamedStringTag("icon_url", object.tags().getTags());
        if (fromTag != null) {
            return fromTag.getContents();
        }
        ManagementContext mgmt = ((BrooklynObjectInternal)object).getManagementContext();
        if (mgmt == null) {
            return null;
        }
        BrooklynTypeRegistry registry = mgmt.getTypeRegistry();
        if (registry == null) {
            return null;
        }
        RegisteredType item = registry.get(object.getCatalogItemId());
        if (item == null) {
            return null;
        }
        return item.getIconUrl();
    }

    @Deprecated
    public static RegisteredType changePlan(RegisteredType type, RegisteredType.TypeImplementationPlan plan) {
        ((BasicRegisteredType)type).implementationPlan = plan;
        return type;
    }

    @Beta
    public static RegisteredType changePlanNotingEquivalent(RegisteredType type, RegisteredType.TypeImplementationPlan plan) {
        RegisteredTypes.notePlanEquivalentToThis(type, type.getPlan());
        RegisteredTypes.notePlanEquivalentToThis(type, plan);
        ((BasicRegisteredType)type).implementationPlan = plan;
        return type;
    }

    private static String tagForEquivalentPlan(String input) {
        return "equivalent-plan(" + Streams.getMd5Checksum((InputStream)Streams.newInputStreamWithContents((String)input.trim())) + ")";
    }

    private static Maybe<String> tagForEquivalentYamlPlan(String input) {
        try {
            Iterator plansI = Yamls.parseAll((String)input).iterator();
            if (!plansI.hasNext()) {
                return Maybe.absent((String)"No data found");
            }
            String planOut = "";
            while (plansI.hasNext()) {
                Object plan = plansI.next();
                if (!planOut.isEmpty()) {
                    planOut = planOut + "\n";
                }
                planOut = planOut + Jsonya.render(plan);
            }
            return Maybe.of((Object)RegisteredTypes.tagForEquivalentPlan(planOut));
        }
        catch (Exception e) {
            return Maybe.absent((Throwable)e);
        }
    }

    @Beta
    public static void notePlanEquivalentToThis(RegisteredType type, RegisteredType.TypeImplementationPlan plan) {
        Object data = plan.getPlanData();
        if (data == null) {
            throw new IllegalStateException("No plan data for " + plan + " noted equivalent to " + type);
        }
        if (!(data instanceof String)) {
            throw new IllegalStateException("Expected plan for equivalent to " + type + " to be a string; was " + data);
        }
        ((BasicRegisteredType)type).tags.add(RegisteredTypes.tagForEquivalentPlan((String)data));
        Maybe<String> reserializeEquivalenceTag = RegisteredTypes.tagForEquivalentYamlPlan((String)data);
        if (reserializeEquivalenceTag.isPresent()) {
            ((BasicRegisteredType)type).tags.add(reserializeEquivalenceTag.get());
        }
    }

    @Beta
    public static boolean arePlansEquivalent(RegisteredType type1, RegisteredType type2) {
        String plan1 = RegisteredTypes.getImplementationDataStringForSpec(type1);
        String plan2 = RegisteredTypes.getImplementationDataStringForSpec(type2);
        if (Strings.isNonBlank((CharSequence)plan1) && Strings.isNonBlank((CharSequence)plan2)) {
            String p2tag;
            String p1tag = RegisteredTypes.tagForEquivalentPlan(plan1);
            if (Objects.equal((Object)p1tag, (Object)(p2tag = RegisteredTypes.tagForEquivalentPlan(plan2)))) {
                return true;
            }
            if (type1.getTags().contains(p2tag)) {
                return true;
            }
            if (type2.getTags().contains(p1tag)) {
                return true;
            }
            Maybe<String> rp2tag = RegisteredTypes.tagForEquivalentYamlPlan(plan2);
            if (rp2tag.isPresent() && type1.getTags().contains(rp2tag.get())) {
                return true;
            }
            Maybe<String> rp1tag = RegisteredTypes.tagForEquivalentYamlPlan(plan1);
            if (rp1tag.isPresent() && type2.getTags().contains(rp1tag.get())) {
                return true;
            }
            if (rp1tag.isPresent() && rp2tag.isPresent() && ((String)rp1tag.get()).equals(rp2tag.get())) {
                return true;
            }
        }
        return Objects.equal((Object)type1.getPlan(), (Object)type2.getPlan());
    }

    public static boolean isTemplate(RegisteredType type) {
        if (type == null) {
            return false;
        }
        return type.getTags().contains(BrooklynTags.CATALOG_TEMPLATE);
    }

    public static BrooklynClassLoadingContext getClassLoadingContext(Entity entity) {
        return CatalogUtils.getClassLoadingContext(entity);
    }

    public static Maybe<BrooklynClassLoadingContext> getClassLoadingContextMaybe(BrooklynObject bo) {
        if (bo instanceof EntityAdjuncts.EntityAdjunctProxyable) {
            bo = ((EntityAdjuncts.EntityAdjunctProxyable)bo).getEntity();
        }
        if (!(bo instanceof Entity)) {
            return Maybe.absent((String)("Unable to get loading context for " + bo));
        }
        return Maybe.of((Object)CatalogUtils.getClassLoadingContext((Entity)bo));
    }

    public static BrooklynClassLoadingContext getClassLoadingContext(ManagementContext mgmt, Entity optionalEntity) {
        return optionalEntity != null ? CatalogUtils.getClassLoadingContext(optionalEntity) : JavaBrooklynClassLoadingContext.create(mgmt);
    }

    public static BrooklynClassLoadingContext getCurrentClassLoadingContextOrManagement(ManagementContext mgmt) {
        return RegisteredTypes.getClassLoadingContext(mgmt, BrooklynTaskTags.getContextEntity(Tasks.current()));
    }

    public static class RegisteredTypeNameThenBestFirstComparator
    implements Comparator<RegisteredType> {
        public static Comparator<RegisteredType> INSTANCE = new RegisteredTypeNameThenBestFirstComparator();

        private RegisteredTypeNameThenBestFirstComparator() {
        }

        @Override
        public int compare(RegisteredType o1, RegisteredType o2) {
            return ComparisonChain.start().compare((Object)o1.getSymbolicName(), (Object)o2.getSymbolicName(), (Comparator)NaturalOrderComparator.INSTANCE).compareFalseFirst(o1.isDisabled(), o2.isDisabled()).compareFalseFirst(o1.isDeprecated(), o2.isDeprecated()).compare((Object)o2.getVersion(), (Object)o1.getVersion(), (Comparator)VersionComparator.INSTANCE).result();
        }
    }

    public static class RegisteredTypeNameThenWorstFirstComparator
    implements Comparator<RegisteredType> {
        public static Comparator<RegisteredType> INSTANCE = new RegisteredTypeNameThenWorstFirstComparator();

        private RegisteredTypeNameThenWorstFirstComparator() {
        }

        @Override
        public int compare(RegisteredType o1, RegisteredType o2) {
            return ComparisonChain.start().compare((Object)o1.getSymbolicName(), (Object)o2.getSymbolicName(), (Comparator)NaturalOrderComparator.INSTANCE).compareTrueFirst(o1.isDisabled(), o2.isDisabled()).compareTrueFirst(o1.isDeprecated(), o2.isDeprecated()).compare((Object)o1.getVersion(), (Object)o2.getVersion(), (Comparator)VersionComparator.INSTANCE).result();
        }
    }

    private static class CatalogItemFromRegisteredType
    implements CatalogItem<Object, Object> {
        private final RegisteredType type;

        public CatalogItemFromRegisteredType(RegisteredType type) {
            this.type = type;
        }

        public String getDisplayName() {
            return this.type.getDisplayName();
        }

        public String getCatalogItemId() {
            return this.type.getVersionedName().toString();
        }

        public String getId() {
            return this.type.getId();
        }

        public String getSymbolicName() {
            return this.type.getSymbolicName();
        }

        public String getDescription() {
            return this.type.getDescription();
        }

        public String getIconUrl() {
            return this.type.getIconUrl();
        }

        public String getContainingBundle() {
            return this.type.getContainingBundle();
        }

        public String getVersion() {
            return this.type.getVersion();
        }

        public void setDeprecated(boolean deprecated) {
            RegisteredTypes.setDeprecated(this.type, deprecated);
        }

        public void setDisabled(boolean disabled) {
            RegisteredTypes.setDisabled(this.type, disabled);
        }

        public boolean isDeprecated() {
            return this.type.isDeprecated();
        }

        public boolean isDisabled() {
            return this.type.isDisabled();
        }

        public List<String> getCatalogItemIdSearchPath() {
            throw new UnsupportedOperationException();
        }

        public BrooklynObject.TagSupport tags() {
            throw new UnsupportedOperationException();
        }

        public BrooklynObject.RelationSupport<?> relations() {
            throw new UnsupportedOperationException();
        }

        public <T> T getConfig(ConfigKey<T> key) {
            throw new UnsupportedOperationException();
        }

        public Configurable.ConfigurationSupport config() {
            throw new UnsupportedOperationException();
        }

        public BrooklynObject.SubscriptionSupport subscriptions() {
            throw new UnsupportedOperationException();
        }

        public CatalogItem.CatalogItemType getCatalogItemType() {
            throw new UnsupportedOperationException();
        }

        public Class<Object> getCatalogItemJavaType() {
            throw new UnsupportedOperationException();
        }

        public Class<Object> getSpecType() {
            throw new UnsupportedOperationException();
        }

        public String getJavaType() {
            throw new UnsupportedOperationException();
        }

        public Collection<CatalogItem.CatalogBundle> getLibraries() {
            throw new UnsupportedOperationException();
        }

        public String getPlanYaml() {
            throw new UnsupportedOperationException();
        }

        public RebindSupport<CatalogItemMemento> getRebindSupport() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CatalogItemFromRegisteredType{type=" + this.type + '}';
        }
    }
}

