/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.feed;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.feed.FeedConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.time.Duration;

public class PollConfig<V, T, F extends PollConfig<V, T, F>>
extends FeedConfig<V, T, F> {
    private Boolean skipInitialRun = null;
    private long period = -1L;
    private Object otherTriggers;
    private String description;
    private Supplier<DslPredicates.DslPredicate> condition;

    public PollConfig(AttributeSensor<T> sensor) {
        super(sensor);
    }

    public PollConfig(PollConfig<V, T, F> other) {
        super(other);
        this.period = other.period;
        this.otherTriggers = other.otherTriggers;
        this.condition = other.condition;
        this.description = other.description;
    }

    public Boolean getSkipInitialRun() {
        return this.skipInitialRun;
    }

    public F skipInitialRun(Boolean val) {
        this.skipInitialRun = val;
        return (F)((PollConfig)this.self());
    }

    public long getPeriod() {
        return this.period;
    }

    public F period(Duration val) {
        if (val == null) {
            this.period = -1L;
        } else {
            Preconditions.checkArgument((val.toMilliseconds() >= 0L ? 1 : 0) != 0, (Object)"period must be greater than or equal to zero");
            this.period = val.toMilliseconds();
        }
        return (F)((PollConfig)this.self());
    }

    public F period(long millis) {
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"period must be greater than or equal to zero");
        this.period = millis;
        return (F)((PollConfig)this.self());
    }

    public F period(long val, TimeUnit units) {
        Preconditions.checkArgument((val >= 0L ? 1 : 0) != 0, (Object)"period must be greater than or equal to zero");
        return this.period(units.toMillis(val));
    }

    public F description(String description) {
        this.description = description;
        return (F)((PollConfig)this.self());
    }

    public F otherTriggers(Object otherTriggers) {
        this.otherTriggers = otherTriggers;
        return (F)((PollConfig)this.self());
    }

    public Object getOtherTriggers() {
        return this.otherTriggers;
    }

    public F condition(Supplier<DslPredicates.DslPredicate> condition) {
        this.condition = condition;
        return (F)((PollConfig)this.self());
    }

    public Supplier<DslPredicates.DslPredicate> getCondition() {
        return this.condition;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    protected MutableList<Object> toStringOtherFields() {
        MutableList result = super.toStringOtherFields().appendIfNotNull((Object)this.description);
        if (this.period > 0L && this.period < Duration.PRACTICALLY_FOREVER.toMilliseconds()) {
            result.append((Object)("period: " + Duration.of((Object)this.period)));
        }
        if (this.otherTriggers != null) {
            result.append((Object)("triggers: " + this.otherTriggers));
        }
        return result;
    }

    @Override
    protected MutableList<Object> equalsFields() {
        return super.equalsFields().appendIfNotNull((Object)this.period);
    }
}

