/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Runnables;
import com.google.gson.Gson;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNodeDriver;
import org.apache.brooklyn.entity.brooklynnode.EntityHttpClient;
import org.apache.brooklyn.entity.brooklynnode.EntityHttpClientImpl;
import org.apache.brooklyn.entity.brooklynnode.effector.BrooklynNodeUpgradeEffectorBody;
import org.apache.brooklyn.entity.brooklynnode.effector.SetHighAvailabilityModeEffectorBody;
import org.apache.brooklyn.entity.brooklynnode.effector.SetHighAvailabilityPriorityEffectorBody;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.software.base.lifecycle.MachineLifecycleEffectorTasks;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.feed.http.JsonFunctions;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.javalang.Enums;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynNodeImpl
extends SoftwareProcessImpl
implements BrooklynNode {
    private static final Logger log = LoggerFactory.getLogger(BrooklynNodeImpl.class);
    private HttpFeed httpFeed;

    public Class<?> getDriverInterface() {
        return BrooklynNodeDriver.class;
    }

    @Override
    public void init() {
        super.init();
        this.getMutableEntityType().addEffector(DeployBlueprintEffectorBody.DEPLOY_BLUEPRINT);
        this.getMutableEntityType().addEffector(ShutdownEffectorBody.SHUTDOWN);
        this.getMutableEntityType().addEffector(StopNodeButLeaveAppsEffectorBody.STOP_NODE_BUT_LEAVE_APPS);
        this.getMutableEntityType().addEffector(StopNodeAndKillAppsEffectorBody.STOP_NODE_AND_KILL_APPS);
        this.getMutableEntityType().addEffector(SetHighAvailabilityPriorityEffectorBody.SET_HIGH_AVAILABILITY_PRIORITY);
        this.getMutableEntityType().addEffector(SetHighAvailabilityModeEffectorBody.SET_HIGH_AVAILABILITY_MODE);
        this.getMutableEntityType().addEffector(BrooklynNodeUpgradeEffectorBody.UPGRADE);
    }

    @Override
    protected void preStart() {
        ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this, (String)SHUTDOWN.getName());
    }

    @Override
    protected void preStopConfirmCustom() {
        super.preStopConfirmCustom();
        ConfigBag stopParameters = BrooklynTaskTags.getCurrentEffectorParameters();
        if (Boolean.TRUE.equals(this.getAttribute(BrooklynNode.WEB_CONSOLE_ACCESSIBLE)) && stopParameters != null && !stopParameters.containsKey(BrooklynNode.ShutdownEffector.STOP_APPS_FIRST)) {
            Preconditions.checkState((boolean)this.getChildren().isEmpty(), (Object)"Can't stop instance with running applications.");
        }
    }

    @Override
    protected void preStop() {
        super.preStop();
        if (MachineLifecycleEffectorTasks.canStop(this.getStopProcessModeParam(), this)) {
            this.shutdownGracefully();
        }
    }

    private SoftwareProcess.StopSoftwareParameters.StopMode getStopProcessModeParam() {
        ConfigBag parameters = BrooklynTaskTags.getCurrentEffectorParameters();
        if (parameters != null) {
            return (SoftwareProcess.StopSoftwareParameters.StopMode)((Object)parameters.get(SoftwareProcess.StopSoftwareParameters.STOP_PROCESS_MODE));
        }
        return (SoftwareProcess.StopSoftwareParameters.StopMode)((Object)SoftwareProcess.StopSoftwareParameters.STOP_PROCESS_MODE.getDefaultValue());
    }

    @Override
    protected void preRestart() {
        super.preRestart();
        this.shutdownGracefully();
        DynamicTasks.queue((String)"pre-restart", (Runnable)new Runnable(){

            @Override
            public void run() {
                ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)BrooklynNodeImpl.this, (String)BrooklynNode.SHUTDOWN.getName());
            }
        });
    }

    private void shutdownGracefully() {
        if (Boolean.TRUE.equals(this.getAttribute(BrooklynNode.WEB_CONSOLE_ACCESSIBLE))) {
            this.queueShutdownTask();
            this.queueWaitExitTask();
        } else {
            log.info("Skipping graceful shutdown call, because web-console not up for {}", (Object)this);
        }
    }

    private void queueWaitExitTask() {
        DynamicTasks.queue((TaskAdaptable)Tasks.builder().displayName("wait for graceful stop").body(new Runnable(){

            @Override
            public void run() {
                DynamicTasks.markInessential();
                boolean cleanExit = Repeater.create().until((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return !BrooklynNodeImpl.this.getDriver().isRunning();
                    }
                }).backoffTo(Duration.ONE_SECOND).limitTimeTo(Duration.ONE_MINUTE).run();
                if (!cleanExit) {
                    log.warn("Tenant " + this + " didn't stop cleanly after shutdown. Timeout waiting for process exit.");
                }
            }
        }).build());
    }

    @Override
    protected void postStop() {
        super.postStop();
        if (this.isMachineStopped()) {
            Task stopEffectorTask = BrooklynTaskTags.getClosestEffectorTask((Task)Tasks.current(), (Effector)Startable.STOP);
            Task<?> topEntityTask = this.getTopEntityTask(stopEffectorTask);
            this.getManagementContext().getExecutionManager().submit("Unmanage Brooklyn entity after stop", (Runnable)new UnmanageTask(topEntityTask, this));
        }
    }

    private Task<?> getTopEntityTask(Task<?> stopEffectorTask) {
        Entity context = BrooklynTaskTags.getContextEntity(stopEffectorTask);
        Task topTask = stopEffectorTask;
        while (true) {
            Task parentTask = topTask.getSubmittedByTask();
            Entity parentContext = BrooklynTaskTags.getContextEntity((Task)parentTask);
            if (parentTask == null || parentContext != context) {
                return topTask;
            }
            topTask = parentTask;
        }
    }

    private boolean isMachineStopped() {
        return Locations.findUniqueSshMachineLocation((Iterable)this.getLocations()).isAbsent();
    }

    private void queueShutdownTask() {
        ConfigBag stopParameters = BrooklynTaskTags.getCurrentEffectorParameters();
        ConfigBag shutdownParameters = stopParameters != null ? ConfigBag.newInstanceCopying((ConfigBag)stopParameters) : ConfigBag.newInstance();
        shutdownParameters.putIfAbsent(BrooklynNode.ShutdownEffector.REQUEST_TIMEOUT, (Object)Duration.ONE_MINUTE);
        shutdownParameters.putIfAbsent(BrooklynNode.ShutdownEffector.FORCE_SHUTDOWN_ON_ERROR, (Object)Boolean.TRUE);
        TaskAdaptable shutdownTask = Effectors.invocation((Entity)this, (Effector)SHUTDOWN, (ConfigBag)shutdownParameters);
        TaskTags.markInessential((TaskAdaptable)shutdownTask);
        DynamicTasks.queue((TaskAdaptable)shutdownTask);
    }

    public List getClasspath() {
        List classpath = (List)this.getConfig((ConfigKey.HasConfigKey)CLASSPATH);
        if (classpath == null || classpath.isEmpty()) {
            classpath = (List)this.getManagementContext().getConfig().getConfig((ConfigKey.HasConfigKey)CLASSPATH);
        }
        return classpath;
    }

    protected List<String> getEnabledHttpProtocols() {
        return (List)this.getAttribute((AttributeSensor)ENABLED_HTTP_PROTOCOLS);
    }

    protected boolean isHttpProtocolEnabled(String protocol) {
        List protocols = (List)this.getAttribute((AttributeSensor)ENABLED_HTTP_PROTOCOLS);
        for (String contender : protocols) {
            if (!protocol.equalsIgnoreCase(contender)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void connectSensors() {
        URI webConsoleUri;
        super.connectSensors();
        ConfigToAttributes.apply((Entity)this);
        if (this.isHttpProtocolEnabled("http")) {
            int port = (Integer)((Function)this.getConfig(PORT_MAPPER)).apply(this.getAttribute((AttributeSensor)HTTP_PORT));
            HostAndPort accessible = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)port);
            webConsoleUri = URI.create(String.format("http://%s:%s", accessible.getHost(), accessible.getPort()));
        } else if (this.isHttpProtocolEnabled("https")) {
            int port = (Integer)((Function)this.getConfig(PORT_MAPPER)).apply(this.getAttribute((AttributeSensor)HTTPS_PORT));
            HostAndPort accessible = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)port);
            webConsoleUri = URI.create(String.format("https://%s:%s", accessible.getHost(), accessible.getPort()));
        } else {
            webConsoleUri = null;
        }
        this.sensors().set(WEB_CONSOLE_URI, webConsoleUri);
        if (webConsoleUri != null) {
            this.httpFeed = HttpFeed.builder().entity((Entity)this).period((Duration)this.getConfig(POLL_PERIOD)).baseUri(webConsoleUri).credentialsIfNotNull((String)this.getConfig(MANAGEMENT_USER), (String)this.getConfig(MANAGEMENT_PASSWORD)).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(WEB_CONSOLE_ACCESSIBLE).suburl("/v1/server/healthy").onSuccess(Functionals.chain((Function)HttpValueFunctions.jsonContents(), (Function)JsonFunctions.cast(Boolean.class)))).onFailure(HttpValueFunctions.responseCodeEquals((int)404))).setOnException((Object)false)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MANAGEMENT_NODE_STATE).suburl("/v1/server/ha/state").onSuccess(Functionals.chain((Function)Functionals.chain((Function)HttpValueFunctions.jsonContents(), (Function)JsonFunctions.cast(String.class)), (Function)Enums.fromStringFunction(ManagementNodeState.class)))).setOnFailureOrException(null)).build();
            if (!Lifecycle.RUNNING.equals(this.getAttribute(SERVICE_STATE_ACTUAL))) {
                ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, (Sensor)WEB_CONSOLE_ACCESSIBLE, (Object)"No response from the web console yet");
            }
            this.enrichers().add(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(WEB_CONSOLE_ACCESSIBLE).computing((Function)Functionals.ifNotEquals((Object)true).value((Object)"URL where Brooklyn listens is not answering correctly"))).build());
            this.enrichers().add(((Enrichers.TransformerBuilder)Enrichers.builder().transforming(WEB_CONSOLE_ACCESSIBLE).computing(Functions.identity())).publishing(SERVICE_PROCESS_IS_RUNNING).build());
        } else {
            this.connectServiceUpIsRunning();
        }
    }

    @Override
    protected void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
    }

    @Override
    public EntityHttpClient http() {
        return new EntityHttpClientImpl((Entity)this, BrooklynNode.WEB_CONSOLE_URI);
    }

    static {
        RendererHints.register((AttributeSensor)WEB_CONSOLE_URI, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }

    public static class StopNodeAndKillAppsEffectorBody
    extends EffectorBody<Void>
    implements BrooklynNode.StopNodeAndKillAppsEffector {
        public static final Effector<Void> STOP_NODE_AND_KILL_APPS = Effectors.effector(BrooklynNode.STOP_NODE_AND_KILL_APPS).impl((EffectorBody)new StopNodeAndKillAppsEffectorBody()).build();

        public Void call(ConfigBag parameters) {
            Duration timeout = (Duration)parameters.get(TIMEOUT);
            ConfigBag stopParameters = ConfigBag.newInstanceCopying((ConfigBag)parameters);
            stopParameters.put(BrooklynNode.ShutdownEffector.STOP_APPS_FIRST, (Object)Boolean.TRUE);
            stopParameters.putIfAbsent(BrooklynNode.ShutdownEffector.SHUTDOWN_TIMEOUT, (Object)timeout);
            stopParameters.putIfAbsent(BrooklynNode.ShutdownEffector.REQUEST_TIMEOUT, (Object)timeout);
            DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)this.entity(), (Effector)Startable.STOP, (ConfigBag)stopParameters)).asTask().getUnchecked();
            return null;
        }
    }

    public static class StopNodeButLeaveAppsEffectorBody
    extends EffectorBody<Void>
    implements BrooklynNode.StopNodeButLeaveAppsEffector {
        public static final Effector<Void> STOP_NODE_BUT_LEAVE_APPS = Effectors.effector(BrooklynNode.STOP_NODE_BUT_LEAVE_APPS).impl((EffectorBody)new StopNodeButLeaveAppsEffectorBody()).build();

        public Void call(ConfigBag parameters) {
            Duration timeout = (Duration)parameters.get(TIMEOUT);
            ConfigBag stopParameters = ConfigBag.newInstanceCopying((ConfigBag)parameters);
            stopParameters.put(BrooklynNode.ShutdownEffector.STOP_APPS_FIRST, (Object)Boolean.FALSE);
            stopParameters.putIfAbsent(BrooklynNode.ShutdownEffector.SHUTDOWN_TIMEOUT, (Object)timeout);
            stopParameters.putIfAbsent(BrooklynNode.ShutdownEffector.REQUEST_TIMEOUT, (Object)timeout);
            DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)this.entity(), (Effector)Startable.STOP, (ConfigBag)stopParameters)).asTask().getUnchecked();
            return null;
        }
    }

    public static class ShutdownEffectorBody
    extends EffectorBody<Void>
    implements BrooklynNode.ShutdownEffector {
        public static final Effector<Void> SHUTDOWN = Effectors.effector(BrooklynNode.SHUTDOWN).impl((EffectorBody)new ShutdownEffectorBody()).build();

        public Void call(ConfigBag parameters) {
            MutableMap formParams = MutableMap.of();
            Lifecycle initialState = (Lifecycle)this.entity().getAttribute(Attributes.SERVICE_STATE_ACTUAL);
            ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.STOPPING);
            for (ConfigKey k : new ConfigKey[]{STOP_APPS_FIRST, FORCE_SHUTDOWN_ON_ERROR, SHUTDOWN_TIMEOUT, REQUEST_TIMEOUT, DELAY_FOR_HTTP_RETURN}) {
                formParams.addIfNotNull((Object)k.getName(), (Object)ShutdownEffectorBody.toNullableString(parameters.get(k)));
            }
            try {
                log.debug("Shutting down " + this.entity() + " with " + formParams);
                HttpToolResponse resp = ((BrooklynNode)this.entity()).http().post("/v1/server/shutdown", (Map<String, String>)ImmutableMap.of((Object)"Brooklyn-Allow-Non-Master-Access", (Object)"true"), (Map<String, String>)formParams);
                if (resp.getResponseCode() != 204) {
                    throw new IllegalStateException("Response code " + resp.getResponseCode());
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new PropagatedRuntimeException("Error shutting down remote node " + this.entity() + " (in state " + initialState + "): " + Exceptions.collapseText((Throwable)e), (Throwable)e);
            }
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this.entity(), (String)SHUTDOWN.getName(), (Object)"Shutdown of remote node has completed successfuly");
            return null;
        }

        private static String toNullableString(Object obj) {
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
    }

    public static class DeployBlueprintEffectorBody
    extends EffectorBody<String>
    implements BrooklynNode.DeployBlueprintEffector {
        public static final Effector<String> DEPLOY_BLUEPRINT = Effectors.effector(BrooklynNode.DEPLOY_BLUEPRINT).impl((EffectorBody)new DeployBlueprintEffectorBody()).build();

        public static Map<String, Object> asMap(ConfigBag parameters, ConfigKey<?> key) {
            Object v = parameters.getStringKey(key.getName());
            if (v == null || v instanceof String && Strings.isBlank((CharSequence)((String)v))) {
                return null;
            }
            if (v instanceof Map) {
                return (Map)v;
            }
            if (v instanceof String) {
                return (Map)new Gson().fromJson((String)v, Map.class);
            }
            throw new IllegalArgumentException("Invalid " + JavaClassNames.simpleClassName((Object)v) + " value for " + key + ": " + v);
        }

        public String call(ConfigBag parameters) {
            if (log.isDebugEnabled()) {
                log.debug("Deploying blueprint to " + this.entity() + ": " + parameters);
            }
            String plan = this.extractPlanYamlString(parameters);
            return this.submitPlan(plan);
        }

        protected String extractPlanYamlString(ConfigBag parameters) {
            String url;
            Object planRaw = parameters.getStringKey(BLUEPRINT_CAMP_PLAN.getName());
            if (planRaw instanceof String && Strings.isBlank((CharSequence)((String)planRaw))) {
                planRaw = null;
            }
            if ((url = (String)parameters.get(BLUEPRINT_TYPE)) != null && planRaw != null) {
                throw new IllegalArgumentException("Cannot supply both plan and url");
            }
            if (url == null && planRaw == null) {
                throw new IllegalArgumentException("Must supply plan or url");
            }
            Map<String, Object> config = DeployBlueprintEffectorBody.asMap(parameters, BLUEPRINT_CONFIG);
            if (planRaw == null) {
                planRaw = Jsonya.at((Object[])new Object[]{"services"}).list().put((Object)"serviceType", (Object)url, new Object[0]).putIfNotNull((Object)"brooklyn.config", config).getRootMap();
            } else if (config != null) {
                throw new IllegalArgumentException("Cannot supply plan with config");
            }
            if (planRaw instanceof Map) {
                planRaw = Jsonya.of((Map)((Map)planRaw)).toString();
            }
            if (!(planRaw instanceof String)) {
                throw new IllegalArgumentException("Invalid " + JavaClassNames.simpleClassName((Object)planRaw) + " value for CAMP plan: " + planRaw);
            }
            return (String)planRaw;
        }

        @VisibleForTesting
        public String submitPlan(final String plan) {
            final MutableMap headers = MutableMap.of((Object)"Content-Type", (Object)"application/yaml");
            final AtomicReference response = new AtomicReference();
            Repeater.create().every(Duration.ONE_SECOND).backoffTo(Duration.FIVE_SECONDS).limitTimeTo(Duration.minutes((Number)5)).repeat(Runnables.doNothing()).rethrowExceptionImmediately().until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    HttpToolResponse result = ((BrooklynNode)this.entity()).http().responseSuccess((Predicate<Integer>)Predicates.or(EntityHttpClient.ResponseCodePredicates.success(), (Predicate)Predicates.equalTo((Object)403))).post("/v1/applications", (Map<String, String>)headers, plan.getBytes());
                    if (result.getResponseCode() == 403) {
                        log.debug("Remote is not ready to accept requests, response is " + result.getResponseCode());
                        return false;
                    }
                    byte[] content = result.getContent();
                    response.set(content);
                    return true;
                }
            }).runRequiringTrue();
            return (String)((Map)new Gson().fromJson(new String((byte[])response.get()), Map.class)).get("entityId");
        }
    }

    private static class UnmanageTask
    implements Runnable {
        private Task<?> latchTask;
        private Entity unmanageEntity;

        public UnmanageTask(@Nullable Task<?> latchTask, Entity unmanageEntity) {
            this.latchTask = latchTask;
            this.unmanageEntity = unmanageEntity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.latchTask != null) {
                this.latchTask.blockUntilEnded();
            } else {
                log.debug("No latch task provided for UnmanageTask, falling back to fixed wait");
                Time.sleep((Duration)Duration.FIVE_SECONDS);
            }
            UnmanageTask unmanageTask = this;
            synchronized (unmanageTask) {
                Entities.unmanage((Entity)this.unmanageEntity);
            }
        }
    }
}

