/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.binder.server.CreateServerRequestBinder;
import org.jclouds.profitbricks.binder.server.UpdateServerRequestBinder;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.RequestIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.server.ServerIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.server.ServerInfoResponseHandler;
import org.jclouds.profitbricks.http.parser.server.ServerListResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface ServerApi {
    @POST
    @Named(value="server:getall")
    @Payload(value="<ws:getAllServers/>")
    @XMLResponseParser(value=ServerListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Server> getAllServers();

    @POST
    @Named(value="server:get")
    @Payload(value="<ws:getServer><serverId>{id}</serverId></ws:getServer>")
    @XMLResponseParser(value=ServerInfoResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Server getServer(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="server:start")
    @Payload(value="<ws:startServer><serverId>{id}</serverId></ws:startServer>")
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String startServer(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="server:stop")
    @Payload(value="<ws:stopServer><serverId>{id}</serverId></ws:stopServer>")
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String stopServer(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="server:reset")
    @Payload(value="<ws:resetServer><serverId>{id}</serverId></ws:resetServer>")
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String resetServer(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="server:create")
    @MapBinder(value=CreateServerRequestBinder.class)
    @XMLResponseParser(value=ServerIdOnlyResponseHandler.class)
    public String createServer(@PayloadParam(value="server") Server.Request.CreatePayload var1);

    @POST
    @Named(value="server:update")
    @MapBinder(value=UpdateServerRequestBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String updateServer(@PayloadParam(value="server") Server.Request.UpdatePayload var1);

    @POST
    @Named(value="server:delete")
    @Payload(value="<ws:deleteServer><serverId>{id}</serverId></ws:deleteServer>")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteServer(@PayloadParam(value="id") String var1);
}

