/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ValueResolverIterator;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Durations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueResolver<T>
implements DeferredSupplier<T>,
Iterable<Maybe<Object>> {
    private static final String TYPE_COERCION_TASK_NAME = "type coercion";
    @Beta
    public static Duration REAL_QUICK_WAIT;
    @Beta
    public static Duration REAL_REAL_QUICK_WAIT;
    public static Duration PRETTY_QUICK_WAIT;
    @Beta
    public static final Duration NON_BLOCKING_WAIT;
    public static Duration REAL_QUICK_PERIOD;
    private static final Logger log;
    final Object value;
    final TypeToken<T> typeT;
    ExecutionContext exec;
    String description;
    boolean allowDeepResolution = true;
    boolean forceDeep;
    Boolean ignoreGenericsAndApplyThisTypeToContents;
    Boolean embedResolutionInTask;
    Duration timeout;
    boolean immediately;
    boolean recursive = true;
    boolean isTransientTask = true;
    T defaultValue = null;
    boolean returnDefaultOnGet = false;
    boolean swallowExceptions = false;
    final Object parentOriginalValue;
    final CountdownTimer parentTimer;
    AtomicBoolean started = new AtomicBoolean(false);
    boolean expired;

    ValueResolver(Object v, TypeToken<T> type) {
        this.value = v;
        this.typeT = type;
        this.checkTypeNotNull();
        this.parentOriginalValue = null;
        this.parentTimer = null;
    }

    ValueResolver(Object v, TypeToken<T> type, ValueResolver<?> parent) {
        this.value = v;
        this.typeT = type;
        this.checkTypeNotNull();
        this.parentOriginalValue = parent.getOriginalValue();
        this.parentTimer = parent.parentTimer;
        this.copyNonFinalFields(parent);
        this.returnDefaultOnGet = false;
        this.defaultValue = null;
        this.swallowExceptions = false;
        this.recursive = true;
        this.ignoreGenericsAndApplyThisTypeToContents = null;
    }

    private void copyNonFinalFields(ValueResolver<?> parent) {
        this.exec = parent.exec;
        this.description = parent.description;
        this.embedResolutionInTask = parent.embedResolutionInTask;
        this.swallowExceptions = parent.swallowExceptions;
        this.recursive = parent.recursive;
        this.forceDeep = parent.forceDeep;
        this.allowDeepResolution = parent.allowDeepResolution;
        this.ignoreGenericsAndApplyThisTypeToContents = parent.ignoreGenericsAndApplyThisTypeToContents;
        this.timeout = parent.timeout;
        this.immediately = parent.immediately;
        if (this.parentTimer != null && this.parentTimer.isExpired()) {
            this.expired = true;
        }
        this.defaultValue = parent.defaultValue;
        this.returnDefaultOnGet = parent.returnDefaultOnGet;
    }

    public ValueResolver<T> clone() {
        return this.cloneReplacingValueAndType(this.value, this.typeT);
    }

    <S> ValueResolver<S> cloneReplacingValueAndType(Object newValue, TypeToken<S> superType) {
        if (!superType.isSupertypeOf(this.typeT)) {
            throw new IllegalStateException("superType must be assignable from " + this.typeT);
        }
        ValueResolver<S> result = new ValueResolver<S>(newValue, superType);
        super.copyNonFinalFields(this);
        if (this.returnDefaultOnGet && !TypeTokens.isInstanceRaw(superType, this.defaultValue)) {
            throw new IllegalStateException("Existing default value " + this.defaultValue + " not compatible with new type " + superType);
        }
        return result;
    }

    public ValueResolver<T> context(ExecutionContext exec) {
        this.exec = exec;
        return this;
    }

    public ValueResolver<T> context(Entity entity) {
        return this.context(entity != null ? ((EntityInternal)entity).getExecutionContext() : null);
    }

    public ValueResolver<T> description(String description) {
        this.description = description;
        return this;
    }

    public ValueResolver<T> defaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        this.returnDefaultOnGet = true;
        return this;
    }

    public ValueResolver<T> noDefaultValue() {
        this.returnDefaultOnGet = false;
        this.defaultValue = null;
        return this;
    }

    public ValueResolver<T> swallowExceptions() {
        this.swallowExceptions = true;
        return this;
    }

    public ValueResolver<T> transientTask(boolean isTransientTask) {
        this.isTransientTask = isTransientTask;
        return this;
    }

    public Maybe<T> getDefault() {
        if (this.returnDefaultOnGet) {
            return Maybe.of(this.defaultValue);
        }
        return Maybe.absent((String)"No default value set");
    }

    public ValueResolver<T> deep() {
        return this.deep(true, true, false);
    }

    @Deprecated
    public ValueResolver<T> deep(boolean forceDeep) {
        return this.deep(true, true, true);
    }

    @Deprecated
    public ValueResolver<T> deep(boolean forceDeep, Boolean deepTraversalUsesRootType) {
        return this.deep(true, true, true);
    }

    public ValueResolver<T> deep(boolean allowDeepResolution, boolean forceDeep, Boolean deepTraversalUsesRootType) {
        this.allowDeepResolution = allowDeepResolution;
        this.forceDeep = forceDeep;
        this.ignoreGenericsAndApplyThisTypeToContents = deepTraversalUsesRootType;
        return this;
    }

    public ValueResolver<T> embedResolutionInTask(Boolean embedResolutionInTask) {
        this.embedResolutionInTask = embedResolutionInTask;
        return this;
    }

    public ValueResolver<T> timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @Beta
    public ValueResolver<T> immediately(boolean val) {
        this.immediately = val;
        if (val && this.timeout == null) {
            this.timeout = NON_BLOCKING_WAIT;
        }
        return this;
    }

    @Beta
    public ValueResolver<T> recursive(boolean val) {
        this.recursive = val;
        return this;
    }

    @Beta
    public ValueResolver<T> allowDeepResolution(boolean val) {
        this.allowDeepResolution = val;
        return this;
    }

    protected void checkTypeNotNull() {
        if (this.typeT == null) {
            throw new NullPointerException("type must be set to resolve, for '" + this.value + "'" + (this.description != null ? ", " + this.description : ""));
        }
    }

    @Override
    public ValueResolverIterator<T> iterator() {
        return new ValueResolverIterator(this);
    }

    @Override
    public T get() {
        Maybe<T> m = this.getMaybe();
        if (m.isPresent()) {
            return (T)m.get();
        }
        if (this.returnDefaultOnGet) {
            return this.defaultValue;
        }
        return (T)m.get();
    }

    public Maybe<T> getMaybe() {
        Maybe<T> result = this.getMaybeInternal();
        if (log.isTraceEnabled()) {
            log.trace(this + " evaluated as " + result);
        }
        return result;
    }

    protected boolean isEvaluatingImmediately() {
        return this.immediately || BrooklynTaskTags.hasTag(Tasks.current(), "IMMEDIATE") || Thread.currentThread().isInterrupted();
    }

    public static boolean isDeferredOrTaskInternal(Object o) {
        return o instanceof TaskAdaptable || o instanceof DeferredSupplier || o instanceof Future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Maybe<T> getMaybeInternal() {
        Object v;
        block56: {
            CountdownTimer timer;
            if (this.started.getAndSet(true)) {
                throw new IllegalStateException("ValueResolver can only be used once");
            }
            if (this.expired) {
                return Maybe.absent((String)("Nested resolution of " + this.getOriginalValue() + " did not complete within " + this.timeout));
            }
            ExecutionContext exec = this.exec;
            if (exec == null) {
                exec = BasicExecutionContext.getCurrentExecutionContext();
            }
            if (!this.recursive && !TypeTokens.equalsRaw(Object.class, this.typeT)) {
                throw new IllegalStateException("When non-recursive resolver requested the return type must be Object as the immediately resolved value could be a number of (deferred) types.");
            }
            CountdownTimer timerU = this.parentTimer;
            if (timerU == null && this.timeout != null) {
                timerU = this.timeout.countdownTimer();
            }
            if ((timer = timerU) != null && !timer.isNotPaused()) {
                timer.start();
            }
            this.checkTypeNotNull();
            v = this.value;
            if (v == null || !this.forceDeep && TypeTokens.isRaw(this.typeT) && TypeTokens.isInstanceRaw(this.typeT, (Object)v) && !Future.class.isInstance(v) && !DeferredSupplier.class.isInstance(v) && !TaskFactory.class.isInstance(v)) {
                return Maybe.of((Object)v);
            }
            try {
                Task task;
                boolean allowImmediateExecution = false;
                boolean bailOutAfterImmediateExecution = false;
                if (v instanceof ImmediateSupplier || v instanceof DeferredSupplier) {
                    allowImmediateExecution = true;
                } else {
                    if (v instanceof TaskFactory) {
                        v = ((TaskFactory)v).newTask();
                        allowImmediateExecution = true;
                        bailOutAfterImmediateExecution = true;
                        BrooklynTaskTags.setTransient(((TaskAdaptable)v).asTask());
                    }
                    if (v instanceof TaskAdaptable) {
                        v = ((TaskAdaptable)v).asTask();
                    }
                }
                if (allowImmediateExecution && this.isEvaluatingImmediately()) {
                    Maybe<T> result = null;
                    try {
                        if (exec == null) {
                            return Maybe.absent((String)("Immediate resolution requested for '" + this.getDescription() + "' but no execution context available"));
                        }
                        result = exec.getImmediately(v);
                        return result.isPresent() ? (this.recursive ? new ValueResolver<T>(result.get(), this.typeT, this).getMaybe() : result) : result;
                    }
                    catch (ImmediateSupplier.ImmediateUnsupportedException e) {
                        if (bailOutAfterImmediateExecution) {
                            throw new ImmediateSupplier.ImmediateUnsupportedException("Cannot get immediately: " + v);
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("Unable to resolve-immediately for " + this.description + " (" + v + ", unsupported, type " + v.getClass() + "); falling back to executing with timeout: " + e);
                        }
                    }
                    catch (ImmediateSupplier.ImmediateValueNotAvailableException e) {
                        return Maybe.absent((Throwable)e);
                    }
                }
                if (v instanceof Task && !(task = (Task)v).isSubmitted()) {
                    if (exec == null) {
                        return Maybe.absent((String)("Value for unsubmitted task '" + this.getDescription() + "' requested but no execution context available"));
                    }
                    if (!task.getTags().contains("TRANSIENT")) {
                        BrooklynTaskTags.addTagDynamically(task, "NON-TRANSIENT");
                    }
                    if (timer == null && !Thread.currentThread().isInterrupted() && !this.isEvaluatingImmediately()) {
                        exec.get((TaskAdaptable)task);
                    } else {
                        exec.submit((TaskAdaptable)task);
                    }
                }
                if (v instanceof Future) {
                    final Future vfuture = (Future)v;
                    if (!vfuture.isDone()) {
                        Maybe vm;
                        if (this.isEvaluatingImmediately()) {
                            if (!(vfuture instanceof Task) || !((Task)vfuture).isSubmitted()) return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWithExceptionSupplier((Supplier<String>)((Supplier)() -> "Future " + vfuture + " cannot be resolved in immediate context"));
                            try {
                                vm = exec.getImmediately((Object)vfuture);
                            }
                            catch (ImmediateSupplier.ImmediateValueNotAvailableException e) {
                                return Maybe.absent((Throwable)e);
                            }
                            catch (Exception e) {
                                return Maybe.absent(() -> new ImmediateSupplier.ImmediateValueNotAvailableException("Future " + vfuture + " cannot be resolved in immediate context", e));
                            }
                        } else {
                            Callable<Maybe> callable = new Callable<Maybe>(){

                                @Override
                                public Maybe call() throws Exception {
                                    return Durations.get((Future)vfuture, (CountdownTimer)timer);
                                }
                            };
                            String description = this.getDescription();
                            vm = Tasks.withBlockingDetails("Waiting for " + description, callable);
                        }
                        if (vm.isAbsent()) {
                            return vm;
                        }
                        v = vm.get();
                    } else {
                        v = vfuture.get();
                    }
                    break block56;
                }
                if (v instanceof DeferredSupplier) {
                    final DeferredSupplier ds = (DeferredSupplier)v;
                    if (!Boolean.FALSE.equals(this.embedResolutionInTask) && (exec != null || this.timeout != null) || Boolean.TRUE.equals(this.embedResolutionInTask)) {
                        if (exec == null) {
                            return Maybe.absent((String)("Embedding in task needed for '" + this.getDescription() + "' but no execution context available"));
                        }
                        Callable<Object> callable = new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                try {
                                    Tasks.setBlockingDetails("Retrieving " + ds);
                                    Object t = ds.get();
                                    return t;
                                }
                                finally {
                                    Tasks.resetBlockingDetails();
                                }
                            }
                        };
                        String description = this.getDescription();
                        TaskBuilder<Object> tb = Tasks.builder().body(callable).displayName("Resolving dependent value of deferred supplier").description(description);
                        if (this.isTransientTask) {
                            tb.tag("TRANSIENT");
                        }
                        Task vt = exec.submit(tb.build());
                        Maybe vm = Durations.get((Future)vt, (CountdownTimer)timer);
                        vt.cancel(true);
                        if (vm.isAbsent()) {
                            return vm;
                        }
                        v = vm.get();
                        break block56;
                    }
                    try {
                        Tasks.setBlockingDetails("Retrieving (non-task) " + ds);
                        v = ds.get();
                        break block56;
                    }
                    finally {
                        Tasks.resetBlockingDetails();
                    }
                }
                if (this.allowDeepResolution && ValueResolver.supportsDeepResolution(v, this.typeT)) {
                    boolean applyThisTypeToContents = Boolean.TRUE.equals(this.ignoreGenericsAndApplyThisTypeToContents);
                    if (v instanceof Map) {
                        TypeToken valT;
                        TypeToken keyT;
                        if (applyThisTypeToContents) {
                            keyT = this.typeT;
                            valT = this.typeT;
                        } else {
                            TypeToken[] innerTypes = TypeTokens.getGenericParameterTypeTokensWhenUpcastToClassRaw(this.typeT, Map.class);
                            if (innerTypes.length == 2) {
                                keyT = innerTypes[0];
                                valT = innerTypes[1];
                            } else {
                                keyT = valT = TypeToken.of(Object.class);
                            }
                        }
                        LinkedHashMap result = Maps.newLinkedHashMap();
                        for (Map.Entry entry : ((Map)v).entrySet()) {
                            Maybe<T> kk = new ValueResolver<T>(entry.getKey(), keyT, this).description((this.description != null ? this.description + ", " : "") + "map key " + entry.getKey()).getMaybe();
                            if (kk.isAbsent()) {
                                return kk;
                            }
                            Maybe<T> vv = new ValueResolver<T>(entry.getValue(), valT, this).description((this.description != null ? this.description + ", " : "") + "map value for key " + kk.get()).getMaybe();
                            if (vv.isAbsent()) {
                                return vv;
                            }
                            result.put(kk.get(), vv.get());
                        }
                        v = result;
                    } else if (v instanceof Iterable) {
                        TypeToken[] innerTypes;
                        TypeToken entryT = applyThisTypeToContents ? this.typeT : ((innerTypes = TypeTokens.getGenericParameterTypeTokensWhenUpcastToClassRaw(this.typeT, Iterable.class)).length == 1 ? innerTypes[0] : TypeToken.of(Object.class));
                        Object result = v instanceof Set ? MutableSet.of() : Lists.newArrayList();
                        int count = 0;
                        for (Object it : (Iterable)v) {
                            Maybe<T> vv = new ValueResolver<T>(it, entryT, this).description((this.description != null ? this.description + ", " : "") + "entry " + count).getMaybe();
                            if (vv.isAbsent()) {
                                return vv;
                            }
                            result.add(vv.get());
                            ++count;
                        }
                        v = result;
                    }
                }
                if (exec == null || (!(v instanceof Map) || ((Map)v).isEmpty()) && (!(v instanceof List) || ((List)v).isEmpty())) return TypeCoercions.tryCoerce(v, this.typeT);
                Object vf = v;
                Task<Maybe> task2 = Tasks.create(TYPE_COERCION_TASK_NAME, () -> TypeCoercions.tryCoerce(vf, this.typeT));
                BrooklynTaskTags.setTransient(task2);
                return (Maybe)exec.get(task2);
            }
            catch (Exception e) {
                IllegalArgumentException problem;
                Exceptions.propagateIfFatal((Throwable)e);
                String msg = "Error resolving " + (this.description != null ? this.description + ", " : "") + v + ", in " + exec;
                String eTxt = Exceptions.collapseText((Throwable)e);
                IllegalArgumentException illegalArgumentException = problem = eTxt.startsWith(msg) ? new IllegalArgumentException(e) : new IllegalArgumentException(msg + ": " + eTxt, e);
                if (this.swallowExceptions) {
                    if (!log.isDebugEnabled()) return Maybe.absent((Throwable)problem);
                    log.debug("Resolution of " + this + " failed, swallowing and returning: " + e);
                    return Maybe.absent((Throwable)problem);
                }
                if (!log.isDebugEnabled()) throw problem;
                log.debug("Resolution of " + this + " failed, throwing: " + e);
                throw problem;
            }
        }
        if (!this.recursive) return Maybe.of((Object)v);
        return new ValueResolver<T>(v, this.typeT, this).getMaybe();
    }

    @Deprecated
    @Beta
    public static boolean supportsDeepResolution(Object v) {
        return ValueResolver.supportsDeepResolution(v, null);
    }

    @Beta
    public static boolean supportsDeepResolution(Object v, @Nullable TypeToken<?> type) {
        return !(!(v instanceof Map) && !(v instanceof Collection) || type != null && !ValueResolver.typeAllowsDeepResolution(type));
    }

    @Beta
    public static boolean typeAllowsDeepResolution(@Nullable TypeToken<?> type) {
        if (type == null) {
            return true;
        }
        return TypeTokens.isAssignableFromRaw(Map.class, type) || TypeTokens.isAssignableFromRaw(Iterable.class, type) || TypeTokens.isAssignableFromRaw(Object.class, type);
    }

    protected String getDescription() {
        return this.description != null ? this.description : "" + this.value;
    }

    protected Object getOriginalValue() {
        if (this.parentOriginalValue != null) {
            return this.parentOriginalValue;
        }
        return this.value;
    }

    protected TypeToken<T> getTypeToken() {
        return this.typeT;
    }

    public String toString() {
        return JavaClassNames.cleanSimpleClassName((Object)this) + "[" + this.typeT + " " + this.value + "]";
    }

    static {
        BasicExecutionManager.registerUninterestingTaskName(TYPE_COERCION_TASK_NAME);
        REAL_QUICK_WAIT = Duration.millis((Number)50);
        REAL_REAL_QUICK_WAIT = Duration.millis((Number)5);
        PRETTY_QUICK_WAIT = Duration.millis((Number)200);
        NON_BLOCKING_WAIT = Duration.millis((Number)500);
        REAL_QUICK_PERIOD = Repeater.DEFAULT_REAL_QUICK_PERIOD;
        log = LoggerFactory.getLogger(ValueResolver.class);
    }

    public static class ResolverBuilderPretype {
        final Object v;

        public ResolverBuilderPretype(Object v) {
            this.v = v;
        }

        public <T> ValueResolver<T> as(Class<T> type) {
            return this.as(TypeToken.of(type));
        }

        public <T> ValueResolver<T> as(TypeToken<T> type) {
            return new ValueResolver<T>(this.v, type);
        }
    }
}

