/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.osgi;

import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.core.BrooklynVersionService;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.BrooklynShutdownHooks;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.launcher.common.BasicLauncher;
import org.apache.brooklyn.launcher.common.BrooklynPropertiesFactoryHelper;
import org.apache.brooklyn.launcher.osgi.ConfigSupplier;
import org.apache.brooklyn.launcher.osgi.OsgiLauncher;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.provider.BrooklynUserWithRandomPasswordSecurityProvider;
import org.apache.brooklyn.rest.security.provider.DelegatingSecurityProvider;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.javalang.Threads;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiLauncherImpl
extends BasicLauncher<OsgiLauncherImpl>
implements OsgiLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiLauncherImpl.class);
    public static final String BROOKLYN_CONFIG_PID = "brooklyn";
    public static final String BROOKLYN_OSGI_DEPENDENCIES_SERVICES_FILTERS = "brooklyn.osgi.dependencies.services.filters";
    public static final String BROOKLYN_OSGI_DEPENDENCIES_SERVICES_TIMEOUT = "brooklyn.osgi.dependencies.services.timeout";
    public static final String BROOKLYN_OSGI_STARTLEVEL_POSTINIT = "brooklyn.osgi.startlevel.postinit";
    private Object reloadLock = new Object();
    private BrooklynVersionService brooklynVersion;
    private String globalBrooklynProperties;
    private String localBrooklynProperties;
    private String defaultCatalogLocation;
    private ConfigurationAdmin configAdmin;
    private ConfigSupplier configSupplier;
    Thread fallbackThread = null;
    AtomicBoolean startedOsgiAfterBundlesRefreshed = new AtomicBoolean();

    public static String getSoftwareName() {
        String name = System.getProperty("karaf.name");
        if (Strings.isNonBlank((CharSequence)name)) {
            return name;
        }
        return "apache-brooklyn";
    }

    public OsgiLauncherImpl startPartOne() {
        Configuration brooklynConfig;
        this.brooklynVersion.getVersion();
        if (this.getManagementContext() != null) {
            ((ManagementContextInternal)this.getManagementContext()).getBrooklynProperties().put(OsgiManager.OSGI_STARTUP_COMPLETE, (Object)false);
        }
        if ((brooklynConfig = this.getConfiguration(BROOKLYN_CONFIG_PID)) == null && Strings.isEmpty((CharSequence)this.globalBrooklynProperties) && Strings.isEmpty((CharSequence)this.localBrooklynProperties)) {
            LOG.warn("Config Admin PID 'brooklyn' not found, not using external configuration. Create a brooklyn.cfg file in etc folder.");
        }
        this.configSupplier = new ConfigSupplier(brooklynConfig);
        BrooklynPropertiesFactoryHelper helper = new BrooklynPropertiesFactoryHelper(this.globalBrooklynProperties, this.localBrooklynProperties, (Supplier)this.configSupplier);
        this.setBrooklynPropertiesBuilder(helper.createPropertiesBuilder());
        return (OsgiLauncherImpl)super.startPartOne();
    }

    private Configuration getConfiguration(String configPid) {
        Configuration[] configs;
        String filter = "(service.pid=" + configPid + ')';
        try {
            configs = this.configAdmin.listConfigurations(filter);
        }
        catch (IOException | InvalidSyntaxException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (configs != null && configs.length > 0) {
            return configs[0];
        }
        return null;
    }

    protected void initManagementContext() {
        super.initManagementContext();
        ((ManagementContextInternal)this.getManagementContext()).getBrooklynProperties().put(OsgiManager.OSGI_STARTUP_COMPLETE, (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initOsgi() {
        if (this.getManagementContext() != null) {
            ((ManagementContextInternal)this.getManagementContext()).getBrooklynProperties().put(OsgiManager.OSGI_STARTUP_COMPLETE, (Object)false);
        }
        Object object = this.reloadLock;
        synchronized (object) {
            Stopwatch startupTimer = Stopwatch.createStarted();
            BrooklynShutdownHooks.resetShutdownFlag();
            LOG.info(OsgiLauncherImpl.getSoftwareName() + " initialization starting, installing catalog from " + this.defaultCatalogLocation);
            this.catalogInitialization(new CatalogInitialization(String.format("file:%s", this.defaultCatalogLocation)));
            this.startPartOne();
            startupTimer.stop();
            LOG.info(OsgiLauncherImpl.getSoftwareName() + " initialization - part one complete, took {}", (Object)startupTimer.toString());
        }
    }

    @Override
    public void startOsgi() {
        final Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Framework f = (Framework)bundle.getBundleContext().getBundle(0L);
        int startLevel = ((FrameworkStartLevel)f.adapt(FrameworkStartLevel.class)).getStartLevel();
        if (this.areServiceDependenciesReady(bundle, bundle + " bundle activation")) {
            LOG.debug("Starting OSGi catalog/rebind (no service dependencies or all already satisfied, on bundle activation)");
            this.doStartOsgiAfterBundlesRefreshed();
        } else {
            Duration timeout;
            final ServiceListener[] sl = new ServiceListener[]{null};
            sl[0] = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    if (OsgiLauncherImpl.this.areServiceDependenciesReady(bundle, "ServiceEvent[" + event.getServiceReference() + " / " + event.getType() + " - " + event.getSource() + "]")) {
                        LOG.debug("Starting OSGi catalog/rebind - all service dependencies satisfied");
                        bundle.getBundleContext().removeServiceListener(sl[0]);
                        if (OsgiLauncherImpl.this.fallbackThread != null) {
                            OsgiLauncherImpl.this.fallbackThread.interrupt();
                        }
                        new Thread(() -> OsgiLauncherImpl.this.doStartOsgiAfterBundlesRefreshed()).start();
                    }
                }
            };
            try {
                timeout = Duration.parse((String)((String)this.getBrooklynProperties().getConfig(BROOKLYN_OSGI_DEPENDENCIES_SERVICES_TIMEOUT)));
            }
            catch (Exception e) {
                throw Exceptions.propagateAnnotated((String)"Invalid duration specified for 'brooklyn.osgi.dependencies.services.timeout'", (Throwable)e);
            }
            this.fallbackThread = new Thread(() -> {
                CountdownTimer timer = timeout == null ? null : CountdownTimer.newInstanceStarted((Duration)timeout);
                try {
                    if (timeout != null) {
                        LOG.debug("Service dependencies timeout detected as " + timeout + "; will start catalog/rebind after that delay if service dependencies not fulfilled sooner");
                    } else {
                        LOG.debug("No timeout specified for 'brooklyn.osgi.dependencies.services.timeout'; will wait indefinitely for service dependencies");
                    }
                    int iteration = 0;
                    do {
                        if (iteration > 0) {
                            LOG.debug("Still waiting on service dependencies, " + iteration + "m so far" + (timer != null ? ", " + timer.getDurationRemaining() + " remaining until timeout" : " (will wait indefinitely)"));
                        }
                        Duration wait = Duration.ONE_MINUTE;
                        if (timer != null && timer.getDurationRemaining().isShorterThan(wait)) {
                            wait = timer.getDurationRemaining();
                        }
                        Time.sleep((Duration)wait);
                        ++iteration;
                    } while (timer == null || timer.isNotExpired());
                }
                catch (RuntimeInterruptedException e) {
                    LOG.debug("OsgiLauncher fallback thread interrupted, probably because service dependencies fulfilled in another thread where OSGi catalog/rebind start should be occurring (or due to shutdown)");
                    Thread.interrupted();
                    return;
                }
                finally {
                    this.fallbackThread = null;
                }
                LOG.warn("Starting OSGi catalog/rebind due to timeout waiting for service dependencies");
                bundle.getBundleContext().removeServiceListener(sl[0]);
                new Thread(() -> {
                    if (!this.doStartOsgiAfterBundlesRefreshed()) {
                        LOG.debug("Did not start OSGi after timeout; already started");
                    }
                }).start();
            });
            bundle.getBundleContext().addServiceListener(sl[0]);
            this.fallbackThread.start();
        }
    }

    private boolean areServiceDependenciesReady(Bundle bundle, String context) {
        Object deps = this.getBrooklynProperties().getConfig(BROOKLYN_OSGI_DEPENDENCIES_SERVICES_FILTERS);
        if (deps != null) {
            List items = StringEscapes.JavaStringEscapes.unwrapJsonishListStringIfPossible((String)deps.toString());
            LOG.debug("OSGi catalog/rebind service dependency check, on " + context + ": " + items);
            for (String item : items) {
                ServiceReference[] r1;
                try {
                    r1 = bundle.getBundleContext().getServiceReferences((String)null, item);
                }
                catch (Exception e) {
                    throw Exceptions.propagateAnnotated((String)("Error getting service references satisfying '" + item + "'"), (Throwable)e);
                }
                if (r1 != null && r1.length != 0) continue;
                LOG.debug("OSGi catalog/rebind blocked, service dependency not yet fulfilled (will keep listening for services): '" + item + "'");
                return false;
            }
            return true;
        }
        LOG.debug("No service dependencies specified, on " + context);
        return true;
    }

    private boolean doStartOsgiAfterBundlesRefreshed() {
        if (this.startedOsgiAfterBundlesRefreshed.getAndSet(true)) {
            LOG.debug("OSGi catalog/rebind already started when invoked a second time", new Throwable("Trace for unexpected redundant OSGi catalog/rebind start"));
            return false;
        }
        this.doStartOsgi();
        Object newStartLevelS = null;
        try {
            newStartLevelS = this.getBrooklynProperties().getConfig(BROOKLYN_OSGI_STARTLEVEL_POSTINIT);
            if (newStartLevelS == null || Strings.isBlank((CharSequence)("" + newStartLevelS))) {
                LOG.debug("No change required to OSGi start-level after OSGi catalog/rebind (brooklyn.osgi.startlevel.postinit unset)");
            } else {
                FrameworkStartLevel fsl = (FrameworkStartLevel)FrameworkUtil.getBundle(this.getClass()).getBundleContext().getBundle(0L).adapt(FrameworkStartLevel.class);
                int newStartLevel = (Integer)TypeCoercions.coerce((Object)newStartLevelS, Integer.class);
                if (fsl.getStartLevel() < newStartLevel) {
                    LOG.debug("Changing OSGi start-level to " + newStartLevelS + " (from " + fsl + ") after OSGi catalog/rebind");
                    fsl.setStartLevel(newStartLevel, new FrameworkListener[0]);
                } else {
                    LOG.debug("No change required to OSGi start-level after OSGi catalog/rebind (currently " + fsl.getStartLevel() + ", " + BROOKLYN_OSGI_STARTLEVEL_POSTINIT + "=" + newStartLevelS + " required)");
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error handling post-init start level: " + e, (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartOsgi() {
        Object object = this.reloadLock;
        synchronized (object) {
            Stopwatch startupTimer = Stopwatch.createStarted();
            LOG.debug("OsgiLauncher catalog/rebind running initialization (part two)");
            this.startPartTwo();
            new DelegatingSecurityProvider(this.getManagementContext()).getDelegate();
            ((ManagementContextInternal)this.getManagementContext()).getBrooklynProperties().put(OsgiManager.OSGI_STARTUP_COMPLETE, (Object)true);
            FrameworkLookup.invalidateCaches();
            StringBuilder interstitial = new StringBuilder(OsgiLauncherImpl.getSoftwareName().toUpperCase());
            interstitial.append(" ");
            MutableList notes = MutableList.of();
            ManagementNodeState state = this.getManagementContext().getHighAvailabilityManager().getNodeState();
            if (ManagementNodeState.MASTER.equals((Object)state)) {
                interstitial.append("RUNNING");
                int appCount = this.getManagementContext().getApplications().size();
                if (appCount > 0) {
                    notes.add(appCount + " app" + (appCount != 1 ? "s" : "") + " under management");
                }
                int catalogSize = Iterables.size((Iterable)this.getManagementContext().getTypeRegistry().getAll());
                notes.add(catalogSize + " items in type registry");
            } else if (ManagementNodeState.FAILED.equals((Object)state)) {
                interstitial.append("FAILED - see logs for more information");
            } else {
                interstitial.append("in state: " + state.name().toUpperCase());
            }
            LOG.info(interstitial.toString().toLowerCase() + (notes.isEmpty() ? "" : " - " + notes.stream().collect(Collectors.joining(", "))));
            startupTimer.stop();
            LOG.info(OsgiLauncherImpl.getSoftwareName() + " initialization - part two complete, took {}", (Object)startupTimer.toString());
            new Thread(() -> {
                Time.sleep((Duration)Duration.millis((Number)50));
                LOG.info("======== " + interstitial + " ========");
            }, OsgiLauncherImpl.getSoftwareName() + "-start-completion").start();
        }
    }

    @Override
    public void destroyOsgi() {
        LOG.debug("Notified of system shutdown, calling shutdown hooks");
        Threads.runShutdownHooks();
        Thread t = this.fallbackThread;
        if (t != null) {
            LOG.debug("Notified of system shutdown, cancelling service dependencies fallback thread");
            t.interrupt();
        }
    }

    protected void startingUp() {
        super.startingUp();
        ManagementContext managementContext = this.getManagementContext();
        BrooklynProperties brooklynProperties = (BrooklynProperties)managementContext.getConfig();
        if (BrooklynWebConfig.hasNoSecurityOptions((ConfigMap)brooklynProperties)) {
            LOG.info("No security provider options specified. Define a security provider or users to prevent a random password being created and logged.");
            brooklynProperties.put(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE, (Object)new BrooklynUserWithRandomPasswordSecurityProvider(managementContext));
            managementContext.getScratchpad().put(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE, (Object)new BrooklynUserWithRandomPasswordSecurityProvider(managementContext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(Map<?, ?> props) {
        Object object = this.reloadLock;
        synchronized (object) {
            LOG.info("Updating brooklyn config because of config admin changes.");
            this.configSupplier.update(props);
            this.getManagementContext().reloadBrooklynProperties();
        }
    }

    public void setBrooklynVersion(BrooklynVersionService brooklynVersion) {
        this.brooklynVersion = brooklynVersion;
    }

    public void setPersistenceLocation(@Nullable String persistenceLocationSpec) {
        this.persistenceLocation(persistenceLocationSpec);
    }

    public void setBrooklynProperties(BrooklynProperties brooklynProperties) {
        this.brooklynProperties(brooklynProperties);
    }

    public void setIgnorePersistenceErrors(boolean ignorePersistenceErrors) {
        this.ignorePersistenceErrors(ignorePersistenceErrors);
    }

    public void setIgnoreCatalogErrors(boolean ignoreCatalogErrors) {
        this.ignoreCatalogErrors(ignoreCatalogErrors);
    }

    public void setIgnoreAppErrors(boolean ignoreAppErrors) {
        this.ignoreAppErrors(ignoreAppErrors);
    }

    public void setPersistMode(PersistMode persistMode) {
        this.persistMode(persistMode);
    }

    public void setHighAvailabilityMode(HighAvailabilityMode highAvailabilityMode) {
        this.highAvailabilityMode(highAvailabilityMode);
    }

    public void setPersistenceDir(@Nullable String persistenceDir) {
        this.persistenceDir(persistenceDir);
    }

    public void setPersistPeriod(String persistPeriod) {
        this.persistPeriod(Duration.parse((String)persistPeriod));
    }

    public void setHaHeartbeatTimeout(String val) {
        this.haHeartbeatTimeout(Duration.parse((String)val));
    }

    public void setStartBrooklynNode(boolean val) {
        this.startBrooklynNode(val);
    }

    public void setHaHeartbeatPeriod(String val) {
        this.haHeartbeatPeriod(Duration.parse((String)val));
    }

    public void setCopyPersistedState(String destinationDir) {
        this.copyPersistedState(destinationDir);
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setGlobalBrooklynProperties(String globalBrooklynProperties) {
        this.globalBrooklynProperties = globalBrooklynProperties;
    }

    public void setLocalBrooklynProperties(String localBrooklynProperties) {
        this.localBrooklynProperties = localBrooklynProperties;
    }

    public void setDefaultCatalogLocation(String defaultCatalogLocation) {
        this.defaultCatalogLocation = defaultCatalogLocation;
    }
}

