/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import org.jclouds.azurecompute.arm.domain.AutoValue_NetworkSecurityRuleProperties;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class NetworkSecurityRuleProperties {
    @Nullable
    public abstract String description();

    public abstract Protocol protocol();

    @Nullable
    public abstract String sourcePortRange();

    @Nullable
    public abstract String destinationPortRange();

    public abstract String sourceAddressPrefix();

    public abstract String destinationAddressPrefix();

    public abstract Access access();

    @Nullable
    public abstract Integer priority();

    public abstract Direction direction();

    @SerializedNames(value={"description", "protocol", "sourcePortRange", "destinationPortRange", "sourceAddressPrefix", "destinationAddressPrefix", "access", "priority", "direction"})
    public static NetworkSecurityRuleProperties create(String description, Protocol protocol, String sourcePortRange, String destinationPortRange, String sourceAddressPrefix, String destinationAddressPrefix, Access access, Integer priority, Direction direction) {
        return NetworkSecurityRuleProperties.builder().description(description).protocol(protocol).sourcePortRange(sourcePortRange).destinationPortRange(destinationPortRange).sourceAddressPrefix(sourceAddressPrefix).destinationAddressPrefix(destinationAddressPrefix).access(access).priority(priority).direction(direction).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_NetworkSecurityRuleProperties.Builder();
    }

    public static abstract class Builder {
        public abstract Builder description(String var1);

        public abstract Builder protocol(Protocol var1);

        public abstract Builder sourcePortRange(String var1);

        public abstract Builder destinationPortRange(String var1);

        public abstract Builder sourceAddressPrefix(String var1);

        public abstract Builder destinationAddressPrefix(String var1);

        public abstract Builder access(Access var1);

        public abstract Builder priority(Integer var1);

        public abstract Builder direction(Direction var1);

        public abstract NetworkSecurityRuleProperties build();
    }

    public static enum Direction {
        Inbound,
        Outbound,
        UNRECOGNIZED;


        public static Direction fromValue(String text) {
            return (Direction)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }

    public static enum Access {
        Allow,
        Deny,
        UNRECOGNIZED;


        public static Access fromValue(String text) {
            return (Access)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }

    public static enum Protocol {
        Tcp("Tcp"),
        Udp("Udp"),
        All("*"),
        UNRECOGNIZED("Unrecognized");

        private final String label;

        private Protocol(String label) {
            this.label = label;
        }

        public static Protocol fromValue(String text) {
            if ("*".equals(text)) {
                return All;
            }
            return (Protocol)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }

        public String toString() {
            return this.label;
        }
    }
}

