/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.http.internal.JavaUrlHttpCommandExecutorService;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.profitbricks.domain.ServiceFault;
import org.jclouds.util.Closeables2;

@Singleton
public class ResponseStatusFromPayloadHttpCommandExecutorService
extends JavaUrlHttpCommandExecutorService {
    private final ParseSax<ServiceFault> faultHandler;
    private static final Pattern endSoapTag = Pattern.compile("</.+:Envelope>$");

    @Inject
    ResponseStatusFromPayloadHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, Function<URI, Proxy> proxyForURI, ParseSax<ServiceFault> faultHandler, @Named(value="jclouds.idempotent-methods") String idempotentMethods, @Named(value="jclouds.user-agent") String userAgent) {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire, verifier, untrustedSSLContextProvider, proxyForURI, idempotentMethods, userAgent);
        this.faultHandler = faultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse invoke(HttpURLConnection connection) throws IOException, InterruptedException {
        HttpResponse originalResponse = super.invoke(connection);
        HttpResponse.Builder responseBuilder = originalResponse.toBuilder();
        if (ResponseStatusFromPayloadHttpCommandExecutorService.hasServerError(originalResponse) && ResponseStatusFromPayloadHttpCommandExecutorService.hasPayload(originalResponse)) {
            InputStream in = null;
            InputStream originalInputStream = originalResponse.getPayload().openStream();
            if (originalInputStream instanceof ByteArrayInputStream) {
                in = originalInputStream;
            } else {
                try {
                    in = new ByteArrayInputStream(ByteStreams.toByteArray((InputStream)originalInputStream));
                }
                finally {
                    Closeables2.closeQuietly((Closeable)originalInputStream);
                }
            }
            try {
                ServiceFault fault;
                if (ResponseStatusFromPayloadHttpCommandExecutorService.isSoapPayload(in) && (fault = (ServiceFault)this.faultHandler.parse(in)) != null) {
                    if (fault.details() != null) {
                        responseBuilder.statusCode(fault.details().httpCode()).message(fault.details().message());
                    } else {
                        responseBuilder.message(fault.faultString());
                    }
                }
            }
            catch (Exception payload) {
            }
            finally {
                if (in != null) {
                    in.reset();
                    InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)in);
                    this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), originalResponse.getHeaders());
                    responseBuilder.payload((Payload)payload);
                }
            }
        }
        return responseBuilder.build();
    }

    private static boolean hasServerError(HttpResponse response) {
        return response.getStatusCode() >= 500;
    }

    private static boolean hasPayload(HttpResponse response) {
        return response.getPayload() != null && response.getPayload().getRawContent() != null;
    }

    private static boolean isSoapPayload(InputStream is) throws IOException {
        int size = is.available();
        char[] chars = new char[size];
        byte[] bytes = new byte[size];
        ByteStreams.readFully((InputStream)is, (byte[])bytes);
        int i = 0;
        while (i < size) {
            chars[i] = (char)(bytes[i++] & 0xFF);
        }
        is.reset();
        return endSoapTag.matcher(new String(chars)).find();
    }
}

