/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddEffector;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AddChildrenEffector
extends AddEffector {
    private static final Logger log = LoggerFactory.getLogger(AddChildrenEffector.class);
    public static final ConfigKey<Object> BLUEPRINT_YAML = ConfigKeys.newConfigKey(Object.class, "blueprint_yaml");
    public static final ConfigKey<String> BLUEPRINT_TYPE = ConfigKeys.newStringConfigKey("blueprint_type");
    public static final ConfigKey<Boolean> AUTO_START = ConfigKeys.newBooleanConfigKey("auto_start");

    public AddChildrenEffector(ConfigBag params) {
        super(AddChildrenEffector.newEffectorBuilder(params).build());
    }

    public AddChildrenEffector(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public static Effectors.EffectorBuilder<List<String>> newEffectorBuilder(ConfigBag params) {
        Effectors.EffectorBuilder<List<String>> eff = AddEffector.newEffectorBuilder(List.class, params);
        eff.impl(new Body(eff.buildAbstract(), params));
        return eff;
    }

    private static String toJson(Map<?, ?> x) {
        return Jsonya.newInstance().add(x, new Object[0]).toString();
    }

    private static boolean isJsonNotYaml(String x) {
        return x.trim().startsWith("{");
    }

    protected static class Body
    extends EffectorBody<List<String>> {
        private final Effector<?> effector;
        private final String blueprintBase;
        private final Boolean autostart;

        public Body(Effector<?> eff, ConfigBag params) {
            this.effector = eff;
            String newBlueprint = null;
            Object yaml = params.get(BLUEPRINT_YAML);
            if (yaml instanceof Map) {
                newBlueprint = AddChildrenEffector.toJson((Map)yaml);
            } else if (yaml instanceof String) {
                newBlueprint = (String)yaml;
            } else if (yaml != null) {
                throw new IllegalArgumentException(this + " requires map or string in " + BLUEPRINT_YAML + "; not " + yaml.getClass() + " (" + yaml + ")");
            }
            String blueprintType = params.get(BLUEPRINT_TYPE);
            if (blueprintType != null) {
                if (newBlueprint != null) {
                    throw new IllegalArgumentException(this + " cannot take both " + BLUEPRINT_TYPE + " and " + BLUEPRINT_YAML);
                }
                newBlueprint = "services: [ { type: " + blueprintType + " } ]";
            }
            if (newBlueprint == null) {
                throw new IllegalArgumentException(this + " requires either " + BLUEPRINT_TYPE + " or " + BLUEPRINT_YAML);
            }
            this.blueprintBase = newBlueprint;
            this.autostart = params.get(AUTO_START);
        }

        @Override
        public List<String> call(ConfigBag params) {
            params = AddEffector.getMergedParams(this.effector, params);
            String blueprint = this.blueprintBase;
            if (!params.isEmpty()) {
                Map m = (Map)Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)blueprint));
                if (m.containsKey("brooklyn.config")) {
                    Map cfg1 = (Map)m.get("brooklyn.config");
                    MutableMap cfgMergeFlat = MutableMap.copyOf((Map)cfg1).add(params.getAllConfig());
                    if (cfgMergeFlat.size() < cfg1.size() + params.size()) {
                        log.warn("Adding blueprint where same config key is supplied in blueprint and as parameters; preferring parameter (no merge), but behaviour may change. Recommended to use distinct keys.");
                    }
                    m.put("brooklyn.config", cfgMergeFlat);
                    blueprint = AddChildrenEffector.toJson(m);
                } else if (AddChildrenEffector.isJsonNotYaml(blueprint)) {
                    m.put("brooklyn.config", params.getAllConfig());
                    blueprint = AddChildrenEffector.toJson(m);
                } else {
                    blueprint = blueprint + "\nbrooklyn.config: " + AddChildrenEffector.toJson(params.getAllConfig());
                }
            }
            log.debug(this + " adding children to " + this.entity() + ":\n" + blueprint);
            EntityManagementUtils.CreationResult<List<Entity>, List<String>> result = EntityManagementUtils.addChildren((Entity)this.entity(), blueprint, this.autostart);
            log.debug(this + " added children to " + this.entity() + ": " + result.get());
            return (List)result.task().getUnchecked();
        }
    }
}

