/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslUtils;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.AdjunctApi;
import org.apache.brooklyn.rest.domain.AdjunctDetail;
import org.apache.brooklyn.rest.domain.AdjunctSummary;
import org.apache.brooklyn.rest.domain.ConfigSummary;
import org.apache.brooklyn.rest.domain.Status;
import org.apache.brooklyn.rest.domain.SummaryComparators;
import org.apache.brooklyn.rest.domain.TaskSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.AdjunctTransformer;
import org.apache.brooklyn.rest.transform.ConfigTransformer;
import org.apache.brooklyn.rest.transform.EntityTransformer;
import org.apache.brooklyn.rest.transform.TaskTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class AdjunctResource
extends AbstractBrooklynRestResource
implements AdjunctApi {
    private static final Logger log = LoggerFactory.getLogger(AdjunctResource.class);
    @Context
    private UriInfo ui;

    public List<AdjunctSummary> list(String application, String entityToken, String adjunctType) {
        final Entity entity = this.brooklyn().getEntity(application, entityToken);
        Iterable<Object> source = Collections.emptyList();
        boolean all = Strings.isBlank((CharSequence)adjunctType);
        boolean any = false;
        if (all || adjunctType.equalsIgnoreCase(BrooklynObjectType.POLICY.name())) {
            any = true;
            source = Iterables.concat(source, (Iterable)entity.policies());
        }
        if (all || adjunctType.equalsIgnoreCase(BrooklynObjectType.ENRICHER.name())) {
            any = true;
            source = Iterables.concat(source, (Iterable)entity.enrichers());
        }
        if (all || adjunctType.equalsIgnoreCase(BrooklynObjectType.FEED.name())) {
            any = true;
            source = Iterables.concat(source, (Iterable)((EntityInternal)entity).feeds());
        }
        if (!any) {
            throw WebResourceUtils.badRequest("Unknown adjunct type '%s'; use 'policy', 'enricher', or 'feed'", adjunctType);
        }
        return FluentIterable.from(source).transform((Function)new Function<EntityAdjunct, AdjunctSummary>(){

            public AdjunctSummary apply(EntityAdjunct adjunct) {
                return AdjunctTransformer.adjunctSummary(entity, adjunct, AdjunctResource.this.ui.getBaseUriBuilder(), AdjunctResource.this.brooklyn());
            }
        }).toSortedList(SummaryComparators.nameComparator());
    }

    public AdjunctDetail addAdjunct(String application, String entityToken, String adjunctTypeName, Map<String, String> config) {
        Policy instance;
        AbstractBrooklynObjectSpec spec;
        Entity entity;
        block16: {
            entity = this.brooklyn().getEntity(application, entityToken);
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
                throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
            }
            RegisteredType rt = this.brooklyn().getTypeRegistry().get(adjunctTypeName);
            if (rt != null) {
                spec = this.brooklyn().getTypeRegistry().createSpec(rt, null, null);
            } else {
                try {
                    Class type = new ClassLoaderUtils((Object)this, this.mgmt()).loadClass(adjunctTypeName);
                    if (Policy.class.isAssignableFrom(type)) {
                        spec = PolicySpec.create((Class)type);
                        break block16;
                    }
                    if (Enricher.class.isAssignableFrom(type)) {
                        spec = EnricherSpec.create((Class)type);
                        break block16;
                    }
                    if (Feed.class.isAssignableFrom(type)) {
                        throw WebResourceUtils.badRequest("Creation of feeds from java type (%s) not supported", adjunctTypeName);
                    }
                    throw WebResourceUtils.badRequest("Invalid type %s; not a support adjunct type", adjunctTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw WebResourceUtils.badRequest("No adjunct with type %s found", adjunctTypeName);
                }
                catch (ClassCastException e) {
                    throw WebResourceUtils.badRequest("No adjunct with type %s found", adjunctTypeName);
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        try {
            Optional configResolved = DslUtils.resolveNonDeferredBrooklynDslValue(config, (TypeToken)TypeToken.of(Map.class), (ManagementContext)this.mgmt(), (AbstractBrooklynObjectSpec)spec);
            spec.configure((Map)configResolved.or(config));
        }
        catch (Exception e) {
            log.debug("Error resolving config (rethrowing) " + config + ": " + e, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        if (spec instanceof PolicySpec) {
            instance = entity.policies().add((PolicySpec)spec);
        } else if (spec instanceof EnricherSpec) {
            instance = entity.enrichers().add((EnricherSpec)spec);
        } else {
            throw WebResourceUtils.badRequest("Unexpected spec type %s", spec);
        }
        log.debug("REST API added adjunct " + instance + " to " + entity);
        return AdjunctTransformer.adjunctDetail(entity, (EntityAdjunct)instance, this.ui.getBaseUriBuilder(), this.brooklyn());
    }

    public AdjunctDetail get(String application, String entityToken, String adjunctId) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(entity, adjunctId);
        return AdjunctTransformer.adjunctDetail(entity, adjunct, this.ui.getBaseUriBuilder(), this.brooklyn());
    }

    public Status getStatus(String application, String entityToken, String adjunctId) {
        return AdjunctTransformer.inferStatus(this.brooklyn().getAdjunct(application, entityToken, adjunctId));
    }

    public Response start(String application, String entityToken, String adjunctId) {
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(application, entityToken, adjunctId);
        if (adjunct instanceof Policy) {
            ((Policy)adjunct).resume();
        } else if (adjunct instanceof Feed) {
            ((Feed)adjunct).resume();
        } else {
            throw WebResourceUtils.badRequest("%s does not support start/resume", adjunct);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response stop(String application, String entityToken, String adjunctId) {
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(application, entityToken, adjunctId);
        if (adjunct instanceof Policy) {
            ((Policy)adjunct).suspend();
        } else if (adjunct instanceof Feed) {
            ((Feed)adjunct).suspend();
        } else {
            throw WebResourceUtils.badRequest("%s does not support suspend", adjunct);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response destroy(String application, String entityToken, String adjunctId) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(entity, adjunctId);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.DELETE_ADJUNCT, (Object)adjunct)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to delete adjuncts '%s'", Entitlements.getEntitlementContext().user(), adjunct);
        }
        if (adjunct instanceof Policy) {
            ((Policy)adjunct).suspend();
            entity.policies().remove((Policy)adjunct);
        } else if (adjunct instanceof Enricher) {
            entity.enrichers().remove((Enricher)adjunct);
        } else if (adjunct instanceof Feed) {
            ((Feed)adjunct).suspend();
            ((EntityInternal)entity).feeds().remove((Feed)adjunct);
        } else {
            throw WebResourceUtils.badRequest("Unexpected adjunct type %s", adjunct);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public List<ConfigSummary> listConfig(String application, String entityToken, String adjunctToken) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(entity, adjunctToken);
        ArrayList result = Lists.newArrayList();
        for (ConfigKey key : adjunct.config().findKeysDeclared(Predicates.alwaysTrue())) {
            result.add(ConfigTransformer.of(key).on(entity, adjunct).includeLinks(this.ui.getBaseUriBuilder(), false, true).transform());
        }
        return result;
    }

    public Map<String, Object> batchConfigRead(String application, String entityToken, String adjunctToken) {
        return EntityTransformer.getConfigValues(this.brooklyn(), (BrooklynObject)this.brooklyn().getAdjunct(application, entityToken, adjunctToken));
    }

    public String getConfig(String application, String entityToken, String adjunctToken, String configKeyName) {
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(application, entityToken, adjunctToken);
        Set cki = adjunct.config().findKeysDeclared(ConfigPredicates.nameSatisfies((Predicate)Predicates.equalTo((Object)configKeyName)));
        if (cki.isEmpty()) {
            throw WebResourceUtils.notFound("Cannot find config key '%s' in adjunct '%s' of entity '%s'", configKeyName, adjunctToken, entityToken);
        }
        return this.brooklyn().getStringValueForDisplay(adjunct.config().get((ConfigKey)cki.iterator().next()));
    }

    public Response setConfig(String application, String entityToken, String adjunctToken, String configKeyName, Object value) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(entity, adjunctToken);
        Set cki = adjunct.config().findKeysDeclared(ConfigPredicates.nameSatisfies((Predicate)Predicates.equalTo((Object)configKeyName)));
        if (cki.isEmpty()) {
            throw WebResourceUtils.notFound("Cannot find config key '%s' in adjunct '%s' of entity '%s'", configKeyName, adjunctToken, entityToken);
        }
        ConfigKey ck = (ConfigKey)cki.iterator().next();
        adjunct.config().set(ck, TypeCoercions.coerce((Object)value, (TypeToken)ck.getTypeToken()));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public List<TaskSummary> listTasks(String applicationId, String entityId, String adjunctToken, int limit, Boolean recurse) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(entity, adjunctToken);
        return TaskTransformer.fromTasks(MutableList.copyOf((Iterable)BrooklynTaskTags.getTasksInAdjunctContext((ExecutionManager)this.mgmt().getExecutionManager(), (EntityAdjunct)adjunct)), limit, recurse, entity, this.ui);
    }

    public Response getIcon(String applicationId, String entityId, String adjunctToken) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        EntityAdjunct adjunct = this.brooklyn().getAdjunct(entity, adjunctToken);
        String url = RegisteredTypes.getIconUrl((BrooklynObject)adjunct);
        if (url == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (this.brooklyn().isUrlServerSideAndSafe(url)) {
            MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(Files.getFileExtension((String)url));
            InputStream content = ResourceUtils.create((Object)entity).getResourceFromUrl(url);
            return Response.ok((Object)content, (MediaType)mime).build();
        }
        return Response.temporaryRedirect((URI)URI.create(url)).build();
    }
}

