/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensor;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.time.Duration;

public class DurationSinceSensor
extends AddSensor<Duration> {
    private static final Supplier<Long> CURRENT_TIME_SUPPLIER = new CurrentTimeSupplier();
    public static final ConfigKey<Supplier<Long>> EPOCH_SUPPLIER = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Supplier<Long>>(){}).name("duration.since.epochsupplier")).description("The source of time from which durations are measured. Defaults to System.currentTimeMillis when if no supplier is given or the configured supplier returns null.")).defaultValue(CURRENT_TIME_SUPPLIER)).build();
    public static final ConfigKey<Supplier<Long>> TIME_SUPPLIER = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Supplier<Long>>(){}).name("duration.since.timesupplier")).description("The source of the current time. Defaults to System.currentTimeMillis if unconfigured or the supplier returns null.")).defaultValue(CURRENT_TIME_SUPPLIER)).build();
    private final Supplier<Long> epochSupplier;
    private final Supplier<Long> timeSupplier;
    private AttributeSensor<Long> epochSensor;

    public DurationSinceSensor(ConfigBag params) {
        super(params);
        this.epochSupplier = params.get(EPOCH_SUPPLIER);
        this.timeSupplier = params.get(TIME_SUPPLIER);
    }

    @Override
    public void apply(EntityLocal entity) {
        super.apply(entity);
        this.epochSensor = Sensors.newLongSensor(this.sensor.getName() + ".epoch");
        if (entity.sensors().get(this.epochSensor) == null) {
            Long epoch = (Long)this.epochSupplier.get();
            if (epoch == null) {
                epoch = (Long)CURRENT_TIME_SUPPLIER.get();
            }
            entity.sensors().set(this.epochSensor, (Object)epoch);
        }
        FunctionFeed feed = FunctionFeed.builder().entity((Entity)entity).poll(new FunctionPollConfig(this.sensor).callable(new UpdateTimeSince((Entity)entity))).period(this.period).build();
        entity.addFeed((Feed)feed);
    }

    private class UpdateTimeSince
    implements Callable<Duration> {
        private final Entity entity;

        private UpdateTimeSince(Entity entity) {
            this.entity = entity;
        }

        @Override
        public Duration call() {
            Long referencePoint = (Long)this.entity.sensors().get(DurationSinceSensor.this.epochSensor);
            if (referencePoint != null) {
                Long time = (Long)DurationSinceSensor.this.timeSupplier.get();
                if (time == null) {
                    time = (Long)CURRENT_TIME_SUPPLIER.get();
                }
                return Duration.millis((Number)(time - referencePoint));
            }
            throw new IllegalStateException("Cannot calculate duration since sensor: " + this.entity + " missing required value for " + DurationSinceSensor.this.epochSensor);
        }
    }

    private static class CurrentTimeSupplier
    implements Supplier<Long> {
        private CurrentTimeSupplier() {
        }

        public Long get() {
            return System.currentTimeMillis();
        }
    }
}

