/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.utils.AttributedString;

public class StringsCompleter
implements Completer {
    protected final Collection<Candidate> candidates = new ArrayList<Candidate>();

    public StringsCompleter() {
    }

    public StringsCompleter(String ... strings) {
        this(Arrays.asList(strings));
    }

    public StringsCompleter(Iterable<String> strings) {
        assert (strings != null);
        for (String string : strings) {
            this.candidates.add(new Candidate(AttributedString.stripAnsi(string), string, null, null, null, null, true));
        }
    }

    public StringsCompleter(Candidate ... candidates) {
        assert (candidates != null);
        this.candidates.addAll(Arrays.asList(candidates));
    }

    @Override
    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
        assert (commandLine != null);
        assert (candidates != null);
        candidates.addAll(this.candidates);
    }
}

