/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSet;
import io.fabric8.kubernetes.api.model.extensions.PetSetFluent;
import io.fabric8.kubernetes.api.model.extensions.PetSetFluentImpl;

public class PetSetBuilder
extends PetSetFluentImpl<PetSetBuilder>
implements VisitableBuilder<PetSet, PetSetBuilder> {
    PetSetFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetBuilder() {
        this(true);
    }

    public PetSetBuilder(Boolean validationEnabled) {
        this(new PetSet(), validationEnabled);
    }

    public PetSetBuilder(PetSetFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PetSetBuilder(PetSetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PetSet(), validationEnabled);
    }

    public PetSetBuilder(PetSetFluent<?> fluent, PetSet instance) {
        this(fluent, instance, true);
    }

    public PetSetBuilder(PetSetFluent<?> fluent, PetSet instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public PetSetBuilder(PetSet instance) {
        this(instance, (Boolean)true);
    }

    public PetSetBuilder(PetSet instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PetSet build() {
        PetSet buildable = new PetSet(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PetSetBuilder that = (PetSetBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

