/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.monitoring.monit;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.entity.monitoring.monit.MonitDriver;
import org.apache.brooklyn.entity.monitoring.monit.MonitNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitNodeImpl
extends SoftwareProcessImpl
implements MonitNode {
    private static final Logger LOG = LoggerFactory.getLogger(MonitNodeImpl.class);
    private SshFeed feed;

    public Class<? extends MonitDriver> getDriverInterface() {
        return MonitDriver.class;
    }

    public MonitDriver getDriver() {
        return (MonitDriver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        Location machine = (Location)Iterables.get((Iterable)this.getLocations(), (int)0, null);
        if (machine instanceof SshMachineLocation) {
            String cmd = this.getDriver().getStatusCmd();
            this.feed = (SshFeed)((SshFeed.Builder)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().entity((Entity)this)).period((Duration)this.config().get(SERVICE_PROCESS_IS_RUNNING_POLL_PERIOD))).machine((MachineLocation)((SshMachineLocation)machine))).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(SERVICE_UP).command(cmd).setOnSuccess((Object)true)).setOnFailureOrException((Object)false)).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(MONIT_TARGET_PROCESS_NAME).command(cmd).onSuccess((Function)new Function<SshPollValue, String>(){

                public String apply(SshPollValue input) {
                    String process = Strings.getFirstWordAfter((String)input.getStdout(), (String)"Process");
                    return process;
                }
            })).setOnFailureOrException(null)).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(MONIT_TARGET_PROCESS_STATUS).command(cmd).onSuccess((Function)new Function<SshPollValue, String>(){

                public String apply(SshPollValue input) {
                    return Strings.trim((String)Strings.getRemainderOfLineAfter((String)input.getStdout(), (String)"status"));
                }
            })).setOnFailureOrException(null)).build();
        } else {
            LOG.warn("Location(s) {} not an ssh-machine location, so not polling for status; setting serviceUp immediately", (Object)this.getLocations());
            this.sensors().set(SERVICE_UP, (Object)true);
        }
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
    }

    public String getShortName() {
        return "Monit";
    }
}

