/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import groovy.time.TimeDuration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.DriverDependentEntity;
import org.apache.brooklyn.api.entity.drivers.EntityDriverManager;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.InboundPortsUtils;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.SoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessDriverLifecycleEffectorTasks;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.location.jclouds.networking.NetworkingEffectors;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoftwareProcessImpl
extends AbstractEntity
implements SoftwareProcess,
DriverDependentEntity {
    private static final Logger LOG = LoggerFactory.getLogger(SoftwareProcessImpl.class);
    private transient SoftwareProcessDriver driver;
    private transient FunctionFeed serviceProcessIsRunning;
    protected boolean connectedSensors = false;

    protected void setProvisioningLocation(MachineProvisioningLocation val) {
        if (this.getAttribute(PROVISIONING_LOCATION) != null) {
            throw new IllegalStateException("Cannot change provisioning location: existing=" + this.getAttribute(PROVISIONING_LOCATION) + "; new=" + val);
        }
        this.sensors().set(PROVISIONING_LOCATION, (Object)val);
    }

    protected MachineProvisioningLocation getProvisioningLocation() {
        return (MachineProvisioningLocation)this.getAttribute(PROVISIONING_LOCATION);
    }

    public SoftwareProcessDriver getDriver() {
        return this.driver;
    }

    protected SoftwareProcessDriver newDriver(MachineLocation loc) {
        EntityDriverManager entityDriverManager = this.getManagementContext().getEntityDriverManager();
        return (SoftwareProcessDriver)entityDriverManager.build((DriverDependentEntity)this, (Location)loc);
    }

    protected MachineLocation getMachineOrNull() {
        return (MachineLocation)Iterables.get((Iterable)Iterables.filter((Iterable)this.getLocations(), MachineLocation.class), (int)0, null);
    }

    public void init() {
        super.init();
        this.getLifecycleEffectorTasks().attachLifecycleEffectors(this);
        if (Boolean.TRUE.equals(this.getConfig(ADD_OPEN_INBOUND_PORTS_EFFECTOR))) {
            this.getMutableEntityType().addEffector(NetworkingEffectors.OPEN_INBOUND_PORTS_IN_SECURITY_GROUP_EFFECTOR);
        }
    }

    protected void initEnrichers() {
        super.initEnrichers();
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, (Sensor)SERVICE_PROCESS_IS_RUNNING, (Object)"No information yet on whether this service is running");
        this.enrichers().add(EnricherSpec.create(UpdatingNotUpFromServiceProcessIsRunning.class).uniqueTag("service-process-is-running-updating-not-up"));
        this.enrichers().add(EnricherSpec.create(ServiceNotUpDiagnosticsCollector.class).uniqueTag("service-not-up-diagnostics-collector"));
    }

    @Override
    public void populateServiceNotUpDiagnostics() {
        boolean processIsRunning;
        if (this.getDriver() == null) {
            ServiceStateLogic.updateMapSensorEntry((Entity)this, (AttributeSensor)ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)"driver", (Object)"No driver");
            ServiceStateLogic.clearMapSensorEntry((Entity)this, (AttributeSensor)ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)"sshable");
            ServiceStateLogic.clearMapSensorEntry((Entity)this, (AttributeSensor)ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)SERVICE_PROCESS_IS_RUNNING.getName());
            return;
        }
        ServiceStateLogic.clearMapSensorEntry((Entity)this, (AttributeSensor)ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)"driver");
        Location loc = this.getDriver().getLocation();
        if (loc instanceof SshMachineLocation) {
            if (((SshMachineLocation)loc).isSshable()) {
                ServiceStateLogic.clearMapSensorEntry((Entity)this, (AttributeSensor)ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)"sshable");
            } else {
                ServiceStateLogic.updateMapSensorEntry((Entity)this, (AttributeSensor)ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)"sshable", (Object)"The machine for this entity does not appear to be sshable");
            }
        }
        if (processIsRunning = this.getDriver().isRunning()) {
            ServiceStateLogic.clearMapSensorEntry((Entity)this, (AttributeSensor)ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)SERVICE_PROCESS_IS_RUNNING.getName());
        } else {
            ServiceStateLogic.updateMapSensorEntry((Entity)this, (AttributeSensor)ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)SERVICE_PROCESS_IS_RUNNING.getName(), (Object)"The software process for this entity does not appear to be running");
        }
    }

    protected void preStart() {
    }

    protected void postDriverStart() {
        this.waitForEntityStart();
    }

    protected void connectSensors() {
        this.connectedSensors = true;
    }

    protected void connectServiceUpIsRunning() {
        Duration period = (Duration)this.config().get(SERVICE_PROCESS_IS_RUNNING_POLL_PERIOD);
        this.serviceProcessIsRunning = FunctionFeed.builder().entity((Entity)this).period(period).poll(((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(SERVICE_PROCESS_IS_RUNNING).suppressDuplicates(true)).onException(Functions.constant((Object)Boolean.FALSE))).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return SoftwareProcessImpl.this.getDriver().isRunning();
            }
        })).build();
    }

    protected void disconnectServiceUpIsRunning() {
        if (this.serviceProcessIsRunning != null) {
            this.serviceProcessIsRunning.stop();
        }
        this.sensors().set(SERVICE_PROCESS_IS_RUNNING, null);
        this.sensors().remove(SERVICE_PROCESS_IS_RUNNING);
    }

    protected void postStart() {
    }

    protected void preStopConfirmCustom() {
    }

    protected void preStop() {
        LOG.debug("disconnecting sensors for " + this + " in entity.preStop");
        this.disconnectSensors();
        this.sensors().set(SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, (Object)false);
    }

    protected void postStop() {
    }

    protected void preRestart() {
    }

    protected void postRestart() {
    }

    protected void disconnectSensors() {
        this.connectedSensors = false;
    }

    protected void postRebind() {
    }

    protected void callRebindHooks() {
        Duration configuredMaxDelay = (Duration)this.getConfig(MAXIMUM_REBIND_SENSOR_CONNECT_DELAY);
        if (configuredMaxDelay == null || Duration.ZERO.equals((Object)configuredMaxDelay)) {
            this.connectSensors();
        } else {
            long delay = (long)(Math.random() * (double)configuredMaxDelay.toMilliseconds());
            LOG.debug("Scheduling reconnection of sensors on {} in {}ms", (Object)this, (Object)delay);
            this.scheduleConnectSensorsOnRebind(Duration.millis((Number)delay));
        }
    }

    protected void scheduleConnectSensorsOnRebind(Duration delay) {
        final Callable<Void> job = new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    if (!SoftwareProcessImpl.this.getManagementContext().isRunning()) {
                        LOG.debug("Management context not running; entity {} ignoring scheduled connect-sensors on rebind", (Object)SoftwareProcessImpl.this);
                        return null;
                    }
                    if (SoftwareProcessImpl.this.getManagementSupport().isNoLongerManaged()) {
                        LOG.debug("Entity {} no longer managed; ignoring scheduled connect-sensors on rebind", (Object)SoftwareProcessImpl.this);
                        return null;
                    }
                    boolean rebindActive = SoftwareProcessImpl.this.getManagementContext().getRebindManager().isRebindActive();
                    if (!SoftwareProcessImpl.this.getManagementSupport().wasDeployed()) {
                        if (rebindActive) {
                            Duration configuredMaxDelay = (Duration)SoftwareProcessImpl.this.getConfig(SoftwareProcess.MAXIMUM_REBIND_SENSOR_CONNECT_DELAY);
                            if (configuredMaxDelay == null) {
                                configuredMaxDelay = Duration.millis((Number)100);
                            }
                            long delay = (long)(Math.random() * (double)configuredMaxDelay.toMilliseconds());
                            delay = Math.max(10L, delay);
                            LOG.debug("Entity {} not yet managed; re-scheduling connect-sensors on rebind in {}ms", (Object)SoftwareProcessImpl.this, (Object)delay);
                            SoftwareProcessImpl.this.scheduleConnectSensorsOnRebind(Duration.millis((Number)delay));
                            return null;
                        }
                        LOG.debug("Rebind no longer executing, yet entity {} not managed; not re-scheduling connect-sensors", (Object)SoftwareProcessImpl.this);
                        return null;
                    }
                    SoftwareProcessImpl.this.connectSensors();
                }
                catch (Throwable e) {
                    LOG.warn("Problem connecting sensors on rebind of " + SoftwareProcessImpl.this, e);
                    Exceptions.propagateIfFatal((Throwable)e);
                }
                return null;
            }
        };
        Callable jobFactory = new Callable<Task<?>>(){

            @Override
            public Task<?> call() {
                return new BasicTask(job);
            }
        };
        ScheduledTask scheduledTask = ScheduledTask.builder((Callable)jobFactory).delay(delay).maxIterations(Integer.valueOf(1)).cancelOnException(true).build();
        this.getExecutionContext().submit((TaskAdaptable)scheduledTask);
    }

    public void onManagementStarting() {
        super.onManagementStarting();
        Lifecycle state = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (state == null || state == Lifecycle.CREATED) {
            this.sensors().set(SERVICE_UP, (Object)false);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.CREATED);
            this.sensors().set(SERVICE_STATE_ACTUAL, (Object)Lifecycle.CREATED);
        }
    }

    public void onManagementStarted() {
        super.onManagementStarted();
        Lifecycle state = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (state != null && state != Lifecycle.CREATED) {
            this.postRebind();
        }
    }

    public void rebind() {
        Lifecycle expectedState = ServiceStateLogic.getExpectedState((Entity)this);
        if (expectedState == null || expectedState != Lifecycle.RUNNING) {
            LOG.warn("On rebind of {}, not calling software process rebind hooks because expected state is {}", (Object)this, (Object)expectedState);
            return;
        }
        Lifecycle actualState = ServiceStateLogic.getActualState((Entity)this);
        if (actualState == null || actualState != Lifecycle.RUNNING) {
            LOG.warn("Rebinding entity {}, even though actual state is {}. Expected state is {}", new Object[]{this, actualState, expectedState});
        }
        LOG.info("Rebind {} connecting to pre-running service", (Object)this);
        MachineLocation machine = this.getMachineOrNull();
        if (machine != null) {
            this.initDriver(machine);
            this.driver.rebind();
            LOG.debug("On rebind of {}, re-created driver {}", (Object)this, (Object)this.driver);
        } else {
            LOG.info("On rebind of {}, no MachineLocation found (with locations {}) so not generating driver", (Object)this, (Object)this.getLocations());
        }
        this.callRebindHooks();
    }

    public void waitForServiceUp() {
        Duration timeout = (Duration)this.getConfig(BrooklynConfigKeys.START_TIMEOUT);
        this.waitForServiceUp(timeout);
    }

    public void waitForServiceUp(Duration duration) {
        Entities.waitForServiceUp((Entity)this, (Duration)duration);
    }

    @Deprecated
    public void waitForServiceUp(TimeDuration duration) {
        this.waitForServiceUp(duration.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public void waitForServiceUp(long duration, TimeUnit units) {
        Entities.waitForServiceUp((Entity)this, (Duration)Duration.of((long)duration, (TimeUnit)units));
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation location) {
        ConfigBag result = ConfigBag.newInstance((Map)location.getProvisioningFlags((Collection)ImmutableList.of((Object)this.getClass().getName())));
        Map raw1 = (Map)PROVISIONING_PROPERTIES.rawValue(this.config().getBag().getAllConfigRaw());
        Maybe raw2 = this.config().getRaw((ConfigKey)PROVISIONING_PROPERTIES);
        if (raw2.isPresentAndNonNull()) {
            Object pp = raw2.get();
            if (!(pp instanceof Map)) {
                LOG.debug("When obtaining provisioning properties for " + this + " to deploy to " + location + ", detected that coercion was needed, so coercing sooner than we would otherwise");
                pp = this.config().get((ConfigKey)PROVISIONING_PROPERTIES);
            }
            result.putAll((Map)pp);
        }
        result.putAll(raw1);
        if (result.get(CloudLocationConfig.INBOUND_PORTS) == null) {
            Collection<Integer> ports = this.getRequiredOpenPorts();
            Object requiredPorts = result.get(CloudLocationConfig.ADDITIONAL_INBOUND_PORTS);
            if (requiredPorts instanceof Integer) {
                ports.add((Integer)requiredPorts);
            } else if (requiredPorts instanceof Iterable) {
                for (Object o : (Iterable)requiredPorts) {
                    if (!(o instanceof Integer)) continue;
                    ports.add((Integer)o);
                }
            }
            if (ports != null && ports.size() > 0) {
                result.put(CloudLocationConfig.INBOUND_PORTS, ports);
            }
        }
        result.put(LocationConfigKeys.CALLER_CONTEXT, (Object)this);
        return result.getAllConfigMutable();
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        MutableSet ports = MutableSet.copyOf((Iterable)((Iterable)this.getConfig(REQUIRED_OPEN_LOGIN_PORTS)));
        Boolean portsAutoInfer = (Boolean)this.getConfig(INBOUND_PORTS_AUTO_INFER);
        String portsRegex = (String)this.getConfig(INBOUND_PORTS_CONFIG_REGEX);
        ports.addAll(InboundPortsUtils.getRequiredOpenPorts(this, this.config().getBag().getAllConfigAsConfigKeyMap().keySet(), portsAutoInfer, portsRegex));
        return ports;
    }

    protected void initDriver(MachineLocation machine) {
        SoftwareProcessDriver newDriver = this.doInitDriver(machine);
        if (newDriver == null) {
            throw new UnsupportedOperationException("cannot start " + this + " on " + machine + ": no driver available");
        }
        this.driver = newDriver;
    }

    protected SoftwareProcessDriver doInitDriver(MachineLocation machine) {
        if (this.driver != null) {
            if (this.driver instanceof AbstractSoftwareProcessDriver && machine.equals(((AbstractSoftwareProcessDriver)this.driver).getLocation())) {
                return this.driver;
            }
            LOG.warn("driver/location change is untested for {} at {}; changing driver and continuing", (Object)this, (Object)machine);
            return this.newDriver(machine);
        }
        return this.newDriver(machine);
    }

    public void waitForEntityStart() {
        LOG.debug("waiting to ensure {} doesn't abort prematurely", (Object)this);
        Duration startTimeout = (Duration)this.getConfig(START_TIMEOUT);
        CountdownTimer timer = startTimeout.countdownTimer();
        boolean isRunningResult = false;
        long delay = 100L;
        Exception firstFailure = null;
        while (!isRunningResult && timer.isNotExpired()) {
            block9: {
                Time.sleep((long)delay);
                try {
                    isRunningResult = this.driver.isRunning();
                    LOG.debug("checked {}, 'is running' returned: {}", (Object)this, (Object)isRunningResult);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    isRunningResult = false;
                    if (this.driver != null) {
                        String msg = "checked " + this + ", 'is running' threw an exception; logging subsequent exceptions at debug level";
                        if (firstFailure == null) {
                            LOG.error(msg, (Throwable)e);
                        } else {
                            LOG.debug(msg, (Throwable)e);
                        }
                    } else {
                        LOG.error(this + " concurrent start and shutdown detected", (Throwable)e);
                    }
                    if (firstFailure != null) break block9;
                    firstFailure = e;
                }
            }
            delay = Math.min(delay * 11L / 10L, 5000L);
        }
        if (!isRunningResult) {
            String msg = "Software process entity " + this + " did not pass is-running check within the required " + startTimeout + " limit (" + timer.getDurationElapsed().toStringRounded() + " elapsed)";
            if (firstFailure != null) {
                msg = msg + "; check failed at least once with exception: " + firstFailure.getMessage() + ", see logs for details";
            }
            LOG.warn(msg + " (throwing)");
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
            throw new IllegalStateException(msg, firstFailure);
        }
    }

    public final void start(final Collection<? extends Location> locations) {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.getLifecycleEffectorTasks().start(locations);
        } else {
            Task task = Tasks.builder().displayName("start (sequential)").body(new Runnable(){

                @Override
                public void run() {
                    SoftwareProcessImpl.this.getLifecycleEffectorTasks().start(locations);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    public final void stop() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.getLifecycleEffectorTasks().stop(ConfigBag.EMPTY);
        } else {
            Task task = Tasks.builder().displayName("stop").body(new Runnable(){

                @Override
                public void run() {
                    SoftwareProcessImpl.this.getLifecycleEffectorTasks().stop(ConfigBag.EMPTY);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    public final void restart() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.getLifecycleEffectorTasks().restart(ConfigBag.EMPTY);
        } else {
            Task task = Tasks.builder().displayName("restart").body(new Runnable(){

                @Override
                public void run() {
                    SoftwareProcessImpl.this.getLifecycleEffectorTasks().restart(ConfigBag.EMPTY);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    protected SoftwareProcessDriverLifecycleEffectorTasks getLifecycleEffectorTasks() {
        return (SoftwareProcessDriverLifecycleEffectorTasks)this.getConfig(LIFECYCLE_EFFECTOR_TASKS);
    }

    public static class UpdatingNotUpFromServiceProcessIsRunning
    extends AbstractEnricher
    implements SensorEventListener<Object> {
        public void setEntity(EntityLocal entity) {
            super.setEntity(entity);
            this.subscriptions().subscribe((Entity)entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, (SensorEventListener)this);
            this.subscriptions().subscribe((Entity)entity, (Sensor)Attributes.SERVICE_UP, (SensorEventListener)this);
            this.highlightTriggers((Iterable)MutableList.of(SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, (Object)Attributes.SERVICE_UP, (Object[])new AttributeSensor[0]), entity);
            this.onUpdated();
        }

        public void onEvent(SensorEvent<Object> event) {
            this.onUpdated();
        }

        protected void onUpdated() {
            Boolean isRunning = (Boolean)this.entity.getAttribute(SoftwareProcess.SERVICE_PROCESS_IS_RUNNING);
            if (Boolean.FALSE.equals(isRunning)) {
                ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this.entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, (Object)"The software process for this entity does not appear to be running");
                return;
            }
            if (Boolean.TRUE.equals(isRunning)) {
                ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this.entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING);
                return;
            }
            Boolean isUp = (Boolean)this.entity.getAttribute(Attributes.SERVICE_UP);
            if (Boolean.TRUE.equals(isUp)) {
                ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this.entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING);
                return;
            }
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this.entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, (Object)"No information on whether this service is running");
        }
    }

    public static class ServiceNotUpDiagnosticsCollector
    extends AbstractEnricher
    implements SensorEventListener<Object> {
        public void setEntity(EntityLocal entity) {
            super.setEntity(entity);
            if (!(entity instanceof SoftwareProcess)) {
                throw new IllegalArgumentException("Expected SoftwareProcess, but got entity " + entity);
            }
            this.subscriptions().subscribe((Map)ImmutableMap.of((Object)"notifyOfInitialValue", (Object)true), (Entity)entity, (Sensor)Attributes.SERVICE_STATE_ACTUAL, (SensorEventListener)this);
            this.subscriptions().subscribe((Map)ImmutableMap.of((Object)"notifyOfInitialValue", (Object)true), (Entity)entity, (Sensor)Attributes.SERVICE_UP, (SensorEventListener)this);
        }

        public void onEvent(SensorEvent<Object> event) {
            this.onUpdated();
        }

        protected void onUpdated() {
            Boolean up = (Boolean)this.entity.getAttribute(Startable.SERVICE_UP);
            Lifecycle state = (Lifecycle)this.entity.getAttribute(SoftwareProcess.SERVICE_STATE_ACTUAL);
            if (up == null || up.booleanValue()) {
                this.entity.sensors().set(ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)ImmutableMap.of());
            } else if (state != null && state != Lifecycle.CREATED && state != Lifecycle.STARTING) {
                if (state == Lifecycle.STOPPING || state == Lifecycle.STOPPED || state == Lifecycle.DESTROYED) {
                    this.entity.sensors().set(ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)ImmutableMap.of());
                } else {
                    ((SoftwareProcess)this.entity).populateServiceNotUpDiagnostics();
                }
            }
        }
    }
}

