/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.NetworkInterfaceCard;
import org.jclouds.azurecompute.arm.domain.NetworkInterfaceCardProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/networkInterfaces")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface NetworkInterfaceCardApi {
    @Named(value="networkinterfacecard:list")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<NetworkInterfaceCard> list();

    @Named(value="networkinterfacecard:create_or_update")
    @Path(value="/{networkinterfacecardname}")
    @MapBinder(value=BindToJsonPayload.class)
    @PUT
    public NetworkInterfaceCard createOrUpdate(@PathParam(value="networkinterfacecardname") String var1, @PayloadParam(value="location") String var2, @PayloadParam(value="properties") NetworkInterfaceCardProperties var3, @Nullable @PayloadParam(value="tags") Map<String, String> var4);

    @Named(value="networkinterfacecard:get")
    @Path(value="/{networkinterfacecardname}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public NetworkInterfaceCard get(@PathParam(value="networkinterfacecardname") String var1);

    @Named(value="networkinterfacecard:delete")
    @Path(value="/{networkinterfacecardname}")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="networkinterfacecardname") String var1);
}

