/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.plan.PlanNotRecognizedException;
import org.apache.brooklyn.core.typereg.BrooklynTypePlanTransformer;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypePlanTransformers {
    private static final Logger log = LoggerFactory.getLogger(TypePlanTransformers.class);
    private static Collection<Class<? extends BrooklynTypePlanTransformer>> OVERRIDE;

    private static Collection<BrooklynTypePlanTransformer> getAll() {
        return ImmutableList.copyOf((Iterable)FrameworkLookup.lookupAll(BrooklynTypePlanTransformer.class));
    }

    @SafeVarargs
    @VisibleForTesting
    public static synchronized void forceAvailable(Class<? extends BrooklynTypePlanTransformer> ... classes) {
        OVERRIDE = Arrays.asList(classes);
    }

    public static synchronized void clearForced() {
        OVERRIDE = null;
    }

    public static Collection<BrooklynTypePlanTransformer> all(ManagementContext mgmt) {
        Collection<Class<? extends BrooklynTypePlanTransformer>> override = OVERRIDE;
        ArrayList<BrooklynTypePlanTransformer> result = new ArrayList<BrooklynTypePlanTransformer>();
        if (override != null) {
            for (Class<? extends BrooklynTypePlanTransformer> o1 : override) {
                try {
                    result.add(o1.newInstance());
                }
                catch (Exception e) {
                    Exceptions.propagate((Throwable)e);
                }
            }
        } else {
            result.addAll(TypePlanTransformers.getAll());
        }
        for (BrooklynTypePlanTransformer t : result) {
            t.setManagementContext(mgmt);
        }
        return result;
    }

    @Beta
    public static List<BrooklynTypePlanTransformer> forType(ManagementContext mgmt, RegisteredType type, RegisteredTypeLoadingContext constraint) {
        ArrayListMultimap byScoreMulti = ArrayListMultimap.create();
        Collection<BrooklynTypePlanTransformer> transformers = TypePlanTransformers.all(mgmt);
        for (BrooklynTypePlanTransformer transformer : transformers) {
            double score = transformer.scoreForType(type, constraint);
            if (!(score > 0.0)) continue;
            byScoreMulti.put((Object)score, (Object)transformer);
        }
        TreeMap tree = new TreeMap(byScoreMulti.asMap());
        ArrayList highestFirst = new ArrayList(tree.values());
        Collections.reverse(highestFirst);
        return ImmutableList.copyOf((Iterable)Iterables.concat(highestFirst));
    }

    @Beta
    public static Maybe<Object> transform(ManagementContext mgmt, RegisteredType type, RegisteredTypeLoadingContext constraint) {
        RuntimeException result;
        if (type == null) {
            return Maybe.absent((String)"type cannot be null");
        }
        if (type.getPlan() == null) {
            return Maybe.absent((String)("type plan cannot be null, when instantiating " + type));
        }
        List<BrooklynTypePlanTransformer> transformers = TypePlanTransformers.forType(mgmt, type, constraint);
        ArrayList<String> transformersWhoDontSupport = new ArrayList<String>();
        ArrayList<PropagatedRuntimeException> failuresFromTransformers = new ArrayList<PropagatedRuntimeException>();
        for (BrooklynTypePlanTransformer t : transformers) {
            try {
                Object result2 = t.create(type, constraint);
                if (result2 == null) {
                    transformersWhoDontSupport.add(t.getFormatCode() + " (returned null)");
                    continue;
                }
                return Maybe.of((Object)result2);
            }
            catch (PlanNotRecognizedException | UnsupportedTypePlanException e) {
                transformersWhoDontSupport.add(t.getFormatCode() + (Strings.isNonBlank((CharSequence)e.getMessage()) ? " (" + e.getMessage() + ")" : ""));
            }
            catch (Throwable e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.debug("Transformer for " + t.getFormatCode() + " gave an error creating this plan (retrying with others): " + e, e);
                failuresFromTransformers.add(new PropagatedRuntimeException((type.getSymbolicName() != null ? "Error in definition of " + type.getId() : "Transformer for " + t.getFormatCode() + " gave an error creating this plan") + ": " + Exceptions.collapseText((Throwable)e), e));
            }
        }
        if (!failuresFromTransformers.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Failure transforming plan; returning summary failure, but for reference potentially application transformers were " + transformers + ", available ones are " + MutableList.builder().addAll(TypePlanTransformers.all(mgmt)).build() + "; failures: " + failuresFromTransformers);
            }
            result = failuresFromTransformers.size() == 1 ? Exceptions.create(null, failuresFromTransformers) : Exceptions.create((String)"All plan transformers failed", failuresFromTransformers);
        } else {
            result = transformers.isEmpty() ? new UnsupportedTypePlanException("Invalid plan; format could not be recognized, none of the available transformers " + TypePlanTransformers.all(mgmt) + " support " + type) : new UnsupportedTypePlanException("Invalid plan; potentially applicable transformers " + transformers + " do not support it, and other available transformers do not accept it");
        }
        return Maybe.absent((Throwable)result);
    }
}

