/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.cli;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatform;
import org.apache.brooklyn.camp.spi.PlatformRootSummary;
import org.apache.brooklyn.cli.AbstractMain;
import org.apache.brooklyn.cli.lister.ClassFinder;
import org.apache.brooklyn.cli.lister.ItemDescriptors;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemLister {
    private static final Logger LOG = LoggerFactory.getLogger(ItemLister.class);
    private static final String BASE = "brooklyn/item-lister";
    private static final String BASE_TEMPLATES = "brooklyn/item-lister/templates";
    private static final String BASE_STATICS = "brooklyn/item-lister/statics";

    @Command(name="list-objects", description="List Brooklyn objects (Entities, Policies, Enrichers and Locations)")
    public static class ListAllCommand
    extends AbstractMain.BrooklynCommandCollectingArgs {
        @Option(name={"--jar"}, title="JAR to scan", description="A JAR file to scan. If a file (not a url) pointing at a directory, will include all JAR files in that directory. Due to how classes are scanned the JARs for all classes up to and including brooklyn core must be included as arguments. Argument can be supplied multiple times to scan multiple JARs. If not supplied and no YAML, this attempts to use the initial classpath")
        public List<String> jarsToScan = Lists.newLinkedList();
        @Option(name={"--jars"}, title="JAR to scan", description="DEPRECATED: synonym for --jar")
        public List<String> jarsToScanOld = Lists.newLinkedList();
        @Option(name={"--yaml"}, title="YAML blueprint file", description="A YAML blueprint file to parse. If a file is pointing at a directory, will include all YAML and BOM files in that directory")
        public List<String> yamlToScan = Lists.newLinkedList();
        @Option(name={"--type-regex"}, title="Regex to restrict the Java types loaded")
        public String typeRegex;
        @Option(name={"--all-classes"}, description="When scanning JAR files, whether to include all items rather than only those annotated with @Catalog")
        protected boolean allClasses;
        @Option(name={"--include-impls"}, description="Include Entity class implementation where there is an Entity interface with @ImplementedBy")
        public boolean includeImpls;
        @Option(name={"--headings-only"}, description="Whether to only show name/type, and not config keys etc")
        public boolean headingsOnly;
        @Option(name={"--output-folder"}, title="If supplied, generate HTML pages in the given folder; otherwise only generates JSON")
        public String outputFolder;
        int itemCount = 0;

        @Override
        public Void call() throws Exception {
            Map<String, Object> result = this.populateDescriptors();
            String json = this.toJson(result);
            if (this.outputFolder == null) {
                System.out.println(json);
            } else {
                LOG.info("Outputting item list (size " + this.itemCount + ") to " + this.outputFolder);
                String outputPath = Os.mergePaths((String[])new String[]{this.outputFolder, "index.html"});
                String parentDir = new File(outputPath).getParentFile().getAbsolutePath();
                this.mkdir(parentDir, "entities");
                this.mkdir(parentDir, "policies");
                this.mkdir(parentDir, "enrichers");
                this.mkdir(parentDir, "locations");
                this.mkdir(parentDir, "locationResolvers");
                this.mkdir(parentDir, "style");
                this.mkdir(Os.mergePaths((String[])new String[]{parentDir, "style"}), "js");
                this.mkdir(Os.mergePaths((String[])new String[]{parentDir, "style", "js"}), "catalog");
                this.mkdir(parentDir, "images");
                Files.write((CharSequence)("var items = " + json), (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "items.js"})), (Charset)Charsets.UTF_8);
                Files.write((CharSequence)json, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "items.json"})), (Charset)Charsets.UTF_8);
                ResourceUtils resourceUtils = ResourceUtils.create((Object)this);
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "brooklyn-object-list.html", "index.html");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "common.js");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "items.css");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "images/brooklyn.gif");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "style/js/underscore-min.js");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "style/js/underscore-min.map");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "style/js/catalog/typeahead.js");
                List entities = (List)result.get("entities");
                String entityTemplateHtml = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_TEMPLATES, "entity.html"}));
                for (Map entity : entities) {
                    String type = (String)entity.get("type");
                    String name = (String)entity.get("name");
                    String entityHtml = TemplateProcessor.processTemplateContents((String)entityTemplateHtml, (Map)ImmutableMap.of((Object)"type", (Object)type, (Object)"name", (Object)name));
                    Files.write((CharSequence)entityHtml, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "entities", (String)type + ".html"})), (Charset)Charsets.UTF_8);
                }
                List policies = (List)result.get("policies");
                String policyTemplateHtml = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_TEMPLATES, "policy.html"}));
                for (Map policy : policies) {
                    String type = (String)policy.get("type");
                    String name = (String)policy.get("name");
                    String policyHtml = TemplateProcessor.processTemplateContents((String)policyTemplateHtml, (Map)ImmutableMap.of((Object)"type", (Object)type, (Object)"name", (Object)name));
                    Files.write((CharSequence)policyHtml, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "policies", (String)type + ".html"})), (Charset)Charsets.UTF_8);
                }
                List enrichers = (List)result.get("enrichers");
                String enricherTemplateHtml = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_TEMPLATES, "enricher.html"}));
                for (Map enricher : enrichers) {
                    String type = (String)enricher.get("type");
                    String name = (String)enricher.get("name");
                    String enricherHtml = TemplateProcessor.processTemplateContents((String)enricherTemplateHtml, (Map)ImmutableMap.of((Object)"type", (Object)type, (Object)"name", (Object)name));
                    Files.write((CharSequence)enricherHtml, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "enrichers", type + ".html"})), (Charset)Charsets.UTF_8);
                }
                List locations = (List)result.get("locations");
                String locationTemplateHtml = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_TEMPLATES, "location.html"}));
                for (Map location : locations) {
                    String type = (String)location.get("type");
                    String locationHtml = TemplateProcessor.processTemplateContents((String)locationTemplateHtml, (Map)ImmutableMap.of((Object)"type", (Object)type));
                    Files.write((CharSequence)locationHtml, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "locations", type + ".html"})), (Charset)Charsets.UTF_8);
                }
                LOG.info("Finished outputting item list to " + this.outputFolder);
            }
            return null;
        }

        protected List<String> getJars() {
            return MutableList.builder().addAll(this.jarsToScan).addAll(this.jarsToScanOld).build();
        }

        protected Map<String, Object> populateDescriptors() throws MalformedURLException, IOException {
            List<URL> urls;
            ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> policies = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> enrichers = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> locations = new ArrayList<Map<String, Object>>();
            ArrayList<Object> locationResolvers = new ArrayList<Object>();
            if (!this.getJars().isEmpty() || this.yamlToScan.isEmpty()) {
                urls = this.getJarUrls();
                LOG.info("Retrieving classes from " + urls);
                entities.addAll(ItemDescriptors.toItemDescriptors(this.getTypes(urls, Entity.class), this.headingsOnly, "name"));
                policies.addAll(ItemDescriptors.toItemDescriptors(this.getTypes(urls, Policy.class), this.headingsOnly, "name"));
                enrichers.addAll(ItemDescriptors.toItemDescriptors(this.getTypes(urls, Enricher.class), this.headingsOnly, "name"));
                locations.addAll(ItemDescriptors.toItemDescriptors(this.getTypes(urls, Location.class, false), this.headingsOnly, "type"));
                locationResolvers.addAll(ItemDescriptors.toItemDescriptors((List<LocationResolver>)ImmutableList.copyOf((Iterable)FrameworkLookup.lookupAll(LocationResolver.class)), (Boolean)true));
            }
            if (!this.yamlToScan.isEmpty()) {
                urls = this.getYamlUrls();
                LOG.info("Retrieving items from " + urls);
                LocalManagementContext lmgmt = new LocalManagementContext(BrooklynProperties.Factory.newEmpty());
                BrooklynCampPlatform platform = new BrooklynCampPlatform((PlatformRootSummary)((PlatformRootSummary.Builder)PlatformRootSummary.builder().name("Brooklyn CAMP Platform")).build(), (ManagementContext)lmgmt).setConfigKeyAtManagmentContext();
                BrooklynCatalog catalog = lmgmt.getCatalog();
                for (URL url : urls) {
                    String yamlContent = Streams.readFullyStringAndClose((InputStream)url.openStream());
                    Iterable items = catalog.addItems(yamlContent);
                    for (CatalogItem item : items) {
                        Map<String, Object> itemDescriptor = ItemDescriptors.toItemDescriptor(catalog, item, this.headingsOnly);
                        ++this.itemCount;
                        if (item.getCatalogItemType() == CatalogItem.CatalogItemType.ENTITY || item.getCatalogItemType() == CatalogItem.CatalogItemType.TEMPLATE) {
                            entities.add(itemDescriptor);
                            continue;
                        }
                        if (item.getCatalogItemType() == CatalogItem.CatalogItemType.POLICY) {
                            policies.add(itemDescriptor);
                            continue;
                        }
                        if (item.getCatalogItemType() == CatalogItem.CatalogItemType.LOCATION) {
                            locations.add(itemDescriptor);
                            continue;
                        }
                        LOG.warn("Skipping unknown catalog item type " + item.getCatalogItemType() + ": " + item);
                        --this.itemCount;
                    }
                }
                Entities.destroyAll((ManagementContext)lmgmt);
            }
            ImmutableMap result = ImmutableMap.builder().put((Object)"entities", entities).put((Object)"policies", policies).put((Object)"enrichers", enrichers).put((Object)"locations", locations).put((Object)"locationResolvers", locationResolvers).build();
            return result;
        }

        private void copyFromItemListerClasspathBaseStaticsToOutputDir(ResourceUtils resourceUtils, String item) throws IOException {
            this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, item, item);
        }

        private void copyFromItemListerClasspathBaseStaticsToOutputDir(ResourceUtils resourceUtils, String item, String dest) throws IOException {
            String js = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_STATICS, item}));
            Files.write((CharSequence)js, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, dest})), (Charset)Charsets.UTF_8);
        }

        private void mkdir(String rootDir, String dirName) {
            new File(Os.mergePaths((String[])new String[]{rootDir, dirName})).mkdirs();
        }

        protected List<URL> getJarUrls() throws MalformedURLException, IOException {
            ArrayList urls = Lists.newArrayList();
            if (!this.getJars().isEmpty()) {
                for (String jar : this.getJars()) {
                    List<URL> expanded = ClassFinder.toJarUrls(jar);
                    if (expanded.isEmpty()) {
                        LOG.warn("No jars found at: " + jar);
                    }
                    urls.addAll(expanded);
                }
            } else if (this.yamlToScan.isEmpty()) {
                String classpath = System.getenv("INITIAL_CLASSPATH");
                if (Strings.isNonBlank((CharSequence)classpath)) {
                    List entries = Splitter.on((String)":").omitEmptyStrings().trimResults().splitToList((CharSequence)classpath);
                    for (String entry : entries) {
                        if (!entry.endsWith(".jar") && !entry.endsWith("/*")) continue;
                        urls.addAll(ClassFinder.toJarUrls(entry.replace("/*", "")));
                    }
                } else {
                    throw new FatalConfigurationRuntimeException("No JARs to process and could not infer from INITIAL_CLASSPATH env var.");
                }
            }
            return urls;
        }

        protected List<URL> getYamlUrls() throws MalformedURLException, IOException {
            ArrayList urls = Lists.newArrayList();
            if (!this.yamlToScan.isEmpty()) {
                for (String y : this.yamlToScan) {
                    File yamlFolder = new File(y);
                    if (yamlFolder.isDirectory()) {
                        File[] fileList;
                        for (File file : fileList = yamlFolder.listFiles()) {
                            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".yaml") && !file.getName().toLowerCase().endsWith(".bom")) continue;
                            urls.add(file.toURI().toURL());
                        }
                        continue;
                    }
                    urls.add(new File(y).toURI().toURL());
                }
            }
            return urls;
        }

        private <T extends BrooklynObject> List<Class<? extends T>> getTypes(List<URL> urls, Class<T> type) {
            return this.getTypes(urls, type, null);
        }

        private <T extends BrooklynObject> List<Class<? extends T>> getTypes(List<URL> urls, Class<T> type, Boolean catalogOnlyOverride) {
            ImmutableList result;
            FluentIterable fluent = FluentIterable.from(ClassFinder.findClasses(urls, type));
            if (this.typeRegex != null) {
                fluent = fluent.filter(ClassFinder.withClassNameMatching(this.typeRegex));
            }
            if (catalogOnlyOverride == null ? !this.allClasses : catalogOnlyOverride != false) {
                fluent = fluent.filter(ClassFinder.withAnnotation(Catalog.class));
            }
            ImmutableList filtered = fluent.toList();
            if (!this.includeImpls) {
                result = MutableSet.copyOf((Iterable)filtered);
                for (Class clazz : filtered) {
                    ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
                    if (implementedBy == null) continue;
                    result.remove(implementedBy.value());
                }
            } else {
                result = filtered;
            }
            this.itemCount += result.size();
            return ImmutableList.copyOf((Collection)result);
        }

        private String toJson(Object obj) throws JsonProcessingException {
            ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).enable(SerializationFeature.INDENT_OUTPUT).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).setSerializationInclusion(JsonInclude.Include.ALWAYS).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            return objectMapper.writeValueAsString(obj);
        }
    }
}

