/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.azurecompute.domain.DataVirtualHardDisk;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.azurecompute.domain.VMImage;
import org.jclouds.azurecompute.xml.DataVirtualHardDiskHandler;
import org.jclouds.azurecompute.xml.OSConfigHandler;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class VMImageHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<VMImage> {
    private String name;
    private String label;
    private String category;
    private String description;
    private VMImage.OSDiskConfiguration osDiskConfiguration;
    private String serviceName;
    private String deploymentName;
    private String roleName;
    private String location;
    private String affinityGroup;
    private Date createdTime;
    private Date modifiedTime;
    private String language;
    private String imageFamily;
    private RoleSize.Type recommendedVMSize;
    private Boolean isPremium;
    private String eula;
    private URI iconUri;
    private URI smallIconUri;
    private URI privacyUri;
    private Date publishedDate;
    private final StringBuilder currentText = new StringBuilder();
    private final DataVirtualHardDiskHandler dataVirtualHardDiskHandler;
    private final OSConfigHandler osConfigHandler;
    private List<DataVirtualHardDisk> dataDiskConfigurations = Lists.newArrayList();
    private boolean inOSConfig;
    private boolean inDataConfig;
    private final DateService dateService = new SimpleDateFormatDateService();

    @Inject
    VMImageHandler(DataVirtualHardDiskHandler dataVirtualHardDiskHandler, OSConfigHandler osConfigHandler) {
        this.dataVirtualHardDiskHandler = dataVirtualHardDiskHandler;
        this.osConfigHandler = osConfigHandler;
    }

    public VMImage getResult() {
        VMImage result = VMImage.create(this.name, this.label, this.category, this.description, this.osDiskConfiguration, this.dataDiskConfigurations, this.serviceName, this.deploymentName, this.roleName, this.location, this.affinityGroup, this.createdTime, this.modifiedTime, this.language, this.imageFamily, this.recommendedVMSize, this.isPremium, this.eula, this.iconUri, this.smallIconUri, this.privacyUri, this.publishedDate);
        this.resetState();
        return result;
    }

    public void startElement(String ignoredUri, String ignoredLocalName, String qName, Attributes ignoredAttributes) throws SAXException {
        if (qName.equals("OSDiskConfiguration")) {
            this.inOSConfig = true;
        }
        if (this.inOSConfig) {
            this.osConfigHandler.endElement(ignoredUri, ignoredLocalName, qName);
        }
        if (qName.equals("DataDiskConfiguration")) {
            this.inDataConfig = true;
        }
        if (this.inDataConfig) {
            this.dataVirtualHardDiskHandler.startElement(ignoredUri, ignoredLocalName, qName, ignoredAttributes);
        }
    }

    private void resetState() {
        this.category = null;
        this.description = null;
        this.label = null;
        this.affinityGroup = null;
        this.name = null;
        this.affinityGroup = null;
        this.location = null;
        this.roleName = null;
        this.deploymentName = null;
        this.serviceName = null;
        this.modifiedTime = null;
        this.createdTime = null;
        this.eula = null;
        this.imageFamily = null;
        this.language = null;
        this.recommendedVMSize = null;
        this.isPremium = Boolean.FALSE;
        this.privacyUri = null;
        this.smallIconUri = null;
        this.iconUri = null;
        this.publishedDate = null;
        this.osDiskConfiguration = null;
        this.dataDiskConfigurations = Lists.newArrayList();
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Name") && !this.inDataConfig && !this.inOSConfig) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Label")) {
            this.label = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Category")) {
            this.category = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Description")) {
            this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("OSDiskConfiguration")) {
            this.osDiskConfiguration = this.osConfigHandler.getResult();
            this.inOSConfig = false;
        } else if (this.inOSConfig) {
            this.osConfigHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("DataDiskConfiguration") && !this.inOSConfig) {
            this.dataDiskConfigurations.add(this.dataVirtualHardDiskHandler.getResult());
            this.inDataConfig = false;
        } else if (this.inDataConfig) {
            this.dataVirtualHardDiskHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("ServiceName")) {
            this.serviceName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("DeploymentName")) {
            this.deploymentName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("RoleName")) {
            this.roleName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Location")) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("AffinityGroup")) {
            this.affinityGroup = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("CreatedTime")) {
            this.createdTime = this.dateService.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("ModifiedTime")) {
            this.modifiedTime = this.dateService.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Language")) {
            this.language = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("ImageFamily")) {
            this.imageFamily = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Label")) {
            this.label = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("RecommendedVMSize")) {
            String vmSizeText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (vmSizeText != null) {
                this.recommendedVMSize = VMImageHandler.parseRoleSize(vmSizeText);
            }
        } else if (qName.equals("IconUri")) {
            String uri = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (uri != null) {
                this.iconUri = URI.create(uri);
            }
        } else if (qName.equals("SmallIconUri")) {
            String uri = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (uri != null) {
                this.smallIconUri = URI.create(uri);
            }
        } else if (qName.equals("PrivacyUri")) {
            String uri = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (uri != null) {
                this.privacyUri = URI.create(uri);
            }
        } else if (qName.equals("IsPremium")) {
            String isPremiumText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (isPremiumText != null) {
                this.isPremium = Boolean.parseBoolean(isPremiumText);
            }
        } else if (qName.equals("Eula")) {
            this.eula = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("PublishedDate")) {
            this.publishedDate = this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inDataConfig) {
            this.dataVirtualHardDiskHandler.characters(ch, start, length);
        } else if (this.inOSConfig) {
            this.osConfigHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    private static RoleSize.Type parseRoleSize(String roleSize) {
        try {
            return RoleSize.Type.valueOf(roleSize.toUpperCase().replace(" ", ""));
        }
        catch (IllegalArgumentException e) {
            return RoleSize.Type.UNRECOGNIZED;
        }
    }
}

