/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.azurecompute.xml.InstanceEndpointHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class RoleInstanceHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Deployment.RoleInstance> {
    private String roleName;
    private String instanceName;
    private Deployment.InstanceStatus instanceStatus;
    private Deployment.PowerState powerState;
    private int instanceUpgradeDomain;
    private int instanceFaultDomain;
    private RoleSize.Type instanceSize;
    private String ipAddress;
    private String hostname;
    private boolean inInstanceEndpoints;
    private final InstanceEndpointHandler instanceEndpointHandler = new InstanceEndpointHandler();
    private List<Deployment.InstanceEndpoint> instanceEndpoints = Lists.newArrayList();
    private StringBuilder currentText = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("InstanceEndpoints")) {
            this.inInstanceEndpoints = true;
        }
        if (this.inInstanceEndpoints) {
            this.instanceEndpointHandler.startElement(uri, localName, qName, attributes);
        }
    }

    private void resetState() {
        this.hostname = null;
        this.ipAddress = null;
        this.instanceName = null;
        this.roleName = null;
        this.instanceStatus = null;
        this.powerState = null;
        this.instanceFaultDomain = -1;
        this.instanceUpgradeDomain = -1;
        this.instanceSize = null;
        this.instanceEndpoints = Lists.newArrayList();
    }

    public Deployment.RoleInstance getResult() {
        Deployment.RoleInstance result = Deployment.RoleInstance.create(this.roleName, this.instanceName, this.instanceStatus, this.powerState, this.instanceUpgradeDomain, this.instanceFaultDomain, this.instanceSize, this.ipAddress, this.hostname, this.instanceEndpoints);
        this.resetState();
        return result;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("InstanceEndpoints")) {
            this.inInstanceEndpoints = false;
        } else if (qName.equals("InstanceEndpoint")) {
            this.instanceEndpoints.add(this.instanceEndpointHandler.getResult());
        } else if (this.inInstanceEndpoints) {
            this.instanceEndpointHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("RoleName")) {
            this.roleName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("InstanceName")) {
            this.instanceName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("InstanceStatus")) {
            this.instanceStatus = Deployment.InstanceStatus.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("PowerState")) {
            this.powerState = Deployment.PowerState.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("InstanceUpgradeDomain")) {
            String upgradeDomain = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (upgradeDomain != null) {
                this.instanceUpgradeDomain = Integer.parseInt(upgradeDomain);
            }
        } else if (qName.equals("InstanceFaultDomain")) {
            String faultDomain = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (faultDomain != null) {
                this.instanceFaultDomain = Integer.parseInt(faultDomain);
            }
        } else if (qName.equals("InstanceSize")) {
            String size = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (size != null) {
                this.instanceSize = RoleSize.Type.fromString(size);
            }
        } else if (qName.equals("IpAddress")) {
            this.ipAddress = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("HostName")) {
            this.hostname = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inInstanceEndpoints) {
            this.instanceEndpointHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

