/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.azurecompute.domain.ProfileDefinition;
import org.jclouds.azurecompute.domain.ProfileDefinitionEndpoint;
import org.jclouds.azurecompute.domain.ProfileDefinitionMonitor;
import org.jclouds.azurecompute.xml.ProfileDefinitionEndpointHandler;
import org.jclouds.azurecompute.xml.ProfileDefinitionMonitorHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class ProfileDefinitionHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ProfileDefinition> {
    private Integer ttl;
    private ProfileDefinition.Status status;
    private String version;
    private ImmutableList.Builder<ProfileDefinitionMonitor> monitors = ImmutableList.builder();
    private ProfileDefinition.LBMethod lb;
    private ImmutableList.Builder<ProfileDefinitionEndpoint> endpoints = ImmutableList.builder();
    private ProfileDefinition.HealthStatus healthStatus;
    private final StringBuilder currentText = new StringBuilder();
    private final ProfileDefinitionMonitorHandler monitorHandler;
    private final ProfileDefinitionEndpointHandler endpointHandler;
    private boolean inMonitor = false;
    private boolean inEndpoint = false;

    @Inject
    public ProfileDefinitionHandler(ProfileDefinitionMonitorHandler monitorHandler, ProfileDefinitionEndpointHandler endpointHandler) {
        this.monitorHandler = monitorHandler;
        this.endpointHandler = endpointHandler;
    }

    public ProfileDefinition getResult() {
        ProfileDefinition result = ProfileDefinition.create(this.ttl, this.status, this.version, (List<ProfileDefinitionMonitor>)this.monitors.build(), this.lb, (List<ProfileDefinitionEndpoint>)this.endpoints.build(), this.healthStatus);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.ttl = null;
        this.status = null;
        this.version = null;
        this.monitors = ImmutableList.builder();
        this.lb = null;
        this.endpoints = ImmutableList.builder();
        this.inMonitor = false;
        this.inEndpoint = false;
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (!this.inEndpoint && qName.equals("Monitor")) {
            this.inMonitor = true;
        }
        if (!this.inMonitor && qName.equals("Endpoint")) {
            this.inEndpoint = true;
        }
        if (this.inMonitor) {
            this.monitorHandler.startElement(url, name, qName, attributes);
        } else if (this.inEndpoint) {
            this.endpointHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (!this.inEndpoint && qName.equals("Monitor")) {
            this.inMonitor = false;
            this.monitors.add((Object)this.monitorHandler.getResult());
        } else if (!this.inMonitor && qName.equals("Endpoint")) {
            this.inEndpoint = false;
            this.endpoints.add((Object)this.endpointHandler.getResult());
        } else if (this.inMonitor) {
            this.monitorHandler.endElement(uri, name, qName);
        } else if (this.inEndpoint) {
            this.endpointHandler.endElement(uri, name, qName);
        } else {
            if (qName.equals("TimeToLiveInSeconds")) {
                this.ttl = Integer.parseInt(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            } else if (qName.equals("Status")) {
                this.status = ProfileDefinition.Status.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            } else if (qName.equals("Version")) {
                this.version = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("LoadBalancingMethod")) {
                this.lb = ProfileDefinition.LBMethod.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            } else if (qName.equals("MonitorStatus")) {
                String value = this.currentText.toString().trim();
                this.healthStatus = value.isEmpty() ? null : ProfileDefinition.HealthStatus.fromString(value);
            }
            this.currentText.setLength(0);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inMonitor) {
            this.monitorHandler.characters(ch, start, length);
        } else if (this.inEndpoint) {
            this.endpointHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

