/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class InstanceEndpointHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Deployment.InstanceEndpoint> {
    private String name;
    private String vip;
    private Integer publicPort;
    private Integer localPort;
    private String protocol;
    private StringBuilder currentText = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
    }

    public Deployment.InstanceEndpoint getResult() {
        Deployment.InstanceEndpoint result = Deployment.InstanceEndpoint.create(this.name, this.vip, this.publicPort, this.localPort, this.protocol);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.protocol = null;
        this.vip = null;
        this.name = null;
        this.localPort = null;
        this.publicPort = null;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Vip")) {
            this.vip = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("PublicPort")) {
            String publicPortText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (publicPortText != null) {
                this.publicPort = Integer.parseInt(publicPortText);
            }
        } else if (qName.equals("LocalPort")) {
            String localPortText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (localPortText != null) {
                this.localPort = Integer.parseInt(localPortText);
            }
        } else if (qName.equals("Protocol")) {
            this.protocol = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

