/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.azurecompute.domain.ComputeCapabilities;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ComputeCapabilitiesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ComputeCapabilities> {
    private final StringBuilder currentText = new StringBuilder();
    private final List<RoleSize.Type> virtualMachineRoleSizes = Lists.newArrayList();
    private final List<RoleSize.Type> webWorkerRoleSizes = Lists.newArrayList();
    private boolean inVirtualMachineRoleSizes = false;
    private boolean inWebWorkerRoleSizes = false;

    public ComputeCapabilities getResult() {
        ComputeCapabilities result = ComputeCapabilities.create(this.virtualMachineRoleSizes, this.webWorkerRoleSizes);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.virtualMachineRoleSizes.clear();
        this.webWorkerRoleSizes.clear();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("WebWorkerRoleSizes".equals(qName)) {
            this.inWebWorkerRoleSizes = true;
        } else if ("VirtualMachinesRoleSizes".equals(qName)) {
            this.inVirtualMachineRoleSizes = true;
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if ("RoleSize".equals(qName)) {
            RoleSize.Type roleSizeType = RoleSize.Type.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            if (this.inVirtualMachineRoleSizes) {
                this.virtualMachineRoleSizes.add(roleSizeType);
            } else if (this.inWebWorkerRoleSizes) {
                this.webWorkerRoleSizes.add(roleSizeType);
            }
        } else if ("WebWorkerRoleSizes".equals(qName)) {
            this.inWebWorkerRoleSizes = false;
        } else if ("VirtualMachinesRoleSizes".equals(qName)) {
            this.inVirtualMachineRoleSizes = false;
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

