/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import org.jclouds.azurecompute.domain.AutoValue_ProfileDefinitionEndpointParams;
import org.jclouds.azurecompute.domain.ProfileDefinition;
import org.jclouds.azurecompute.domain.ProfileDefinitionEndpoint;
import org.jclouds.javax.annotation.Nullable;

public abstract class ProfileDefinitionEndpointParams {
    ProfileDefinitionEndpointParams() {
    }

    public abstract String domain();

    public abstract ProfileDefinition.Status status();

    @Nullable
    public abstract ProfileDefinitionEndpoint.Type type();

    @Nullable
    public abstract String location();

    @Nullable
    public abstract Integer min();

    @Nullable
    public abstract Integer weight();

    public Builder toBuilder() {
        return ProfileDefinitionEndpointParams.builder().fromImageParams(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ProfileDefinitionEndpointParams create(String domain, ProfileDefinition.Status status, ProfileDefinitionEndpoint.Type type, String location, Integer min, Integer weight) {
        return new AutoValue_ProfileDefinitionEndpointParams(domain, status, type, location, min, weight);
    }

    public static final class Builder {
        private String domain;
        private ProfileDefinition.Status status;
        private ProfileDefinitionEndpoint.Type type;
        private String location;
        private Integer min;
        private Integer weight;

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder status(ProfileDefinition.Status status) {
            this.status = status;
            return this;
        }

        public Builder type(ProfileDefinitionEndpoint.Type type) {
            this.type = type;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder min(Integer min) {
            this.min = min;
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public ProfileDefinitionEndpointParams build() {
            return ProfileDefinitionEndpointParams.create(this.domain, this.status, this.type, this.location, this.min, this.weight);
        }

        public Builder fromImageParams(ProfileDefinitionEndpointParams in) {
            return this.domain(in.domain()).status(in.status()).type(in.type()).location(in.location()).min(in.min()).weight(in.weight());
        }
    }
}

