/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import java.net.URI;
import java.util.List;
import java.util.Set;
import org.jclouds.azurecompute.domain.DeploymentParams;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.SinceApiVersion;

final class AutoValue_DeploymentParams
extends DeploymentParams {
    private final String name;
    private final RoleSize.Type size;
    private final String username;
    private final String password;
    private final String sourceImageName;
    private final URI mediaLink;
    private final OSImage.Type os;
    private final Set<DeploymentParams.ExternalEndpoint> externalEndpoints;
    private final String virtualNetworkName;
    private final String reservedIPName;
    private final List<String> subnetNames;
    private final Boolean provisionGuestAgent;
    private final Boolean winrmUseHttps;

    private AutoValue_DeploymentParams(String name, RoleSize.Type size, String username, String password, String sourceImageName, URI mediaLink, OSImage.Type os, Set<DeploymentParams.ExternalEndpoint> externalEndpoints, @Nullable String virtualNetworkName, @Nullable String reservedIPName, List<String> subnetNames, @Nullable Boolean provisionGuestAgent, @Nullable Boolean winrmUseHttps) {
        this.name = name;
        this.size = size;
        this.username = username;
        this.password = password;
        this.sourceImageName = sourceImageName;
        this.mediaLink = mediaLink;
        this.os = os;
        this.externalEndpoints = externalEndpoints;
        this.virtualNetworkName = virtualNetworkName;
        this.reservedIPName = reservedIPName;
        this.subnetNames = subnetNames;
        this.provisionGuestAgent = provisionGuestAgent;
        this.winrmUseHttps = winrmUseHttps;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public RoleSize.Type size() {
        return this.size;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public String sourceImageName() {
        return this.sourceImageName;
    }

    @Override
    public URI mediaLink() {
        return this.mediaLink;
    }

    @Override
    public OSImage.Type os() {
        return this.os;
    }

    @Override
    public Set<DeploymentParams.ExternalEndpoint> externalEndpoints() {
        return this.externalEndpoints;
    }

    @Override
    @Nullable
    public String virtualNetworkName() {
        return this.virtualNetworkName;
    }

    @Override
    @SinceApiVersion(value="2014-05-01")
    @Nullable
    public String reservedIPName() {
        return this.reservedIPName;
    }

    @Override
    public List<String> subnetNames() {
        return this.subnetNames;
    }

    @Override
    @Nullable
    public Boolean provisionGuestAgent() {
        return this.provisionGuestAgent;
    }

    @Override
    @Nullable
    public Boolean winrmUseHttps() {
        return this.winrmUseHttps;
    }

    public String toString() {
        return "DeploymentParams{name=" + this.name + ", " + "size=" + (Object)((Object)this.size) + ", " + "username=" + this.username + ", " + "password=" + this.password + ", " + "sourceImageName=" + this.sourceImageName + ", " + "mediaLink=" + this.mediaLink + ", " + "os=" + (Object)((Object)this.os) + ", " + "externalEndpoints=" + this.externalEndpoints + ", " + "virtualNetworkName=" + this.virtualNetworkName + ", " + "reservedIPName=" + this.reservedIPName + ", " + "subnetNames=" + this.subnetNames + ", " + "provisionGuestAgent=" + this.provisionGuestAgent + ", " + "winrmUseHttps=" + this.winrmUseHttps + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DeploymentParams) {
            DeploymentParams that = (DeploymentParams)o;
            return this.name.equals(that.name()) && this.size.equals((Object)that.size()) && this.username.equals(that.username()) && this.password.equals(that.password()) && this.sourceImageName.equals(that.sourceImageName()) && this.mediaLink.equals(that.mediaLink()) && this.os.equals((Object)that.os()) && this.externalEndpoints.equals(that.externalEndpoints()) && (this.virtualNetworkName == null ? that.virtualNetworkName() == null : this.virtualNetworkName.equals(that.virtualNetworkName())) && (this.reservedIPName == null ? that.reservedIPName() == null : this.reservedIPName.equals(that.reservedIPName())) && this.subnetNames.equals(that.subnetNames()) && (this.provisionGuestAgent == null ? that.provisionGuestAgent() == null : this.provisionGuestAgent.equals(that.provisionGuestAgent())) && (this.winrmUseHttps == null ? that.winrmUseHttps() == null : this.winrmUseHttps.equals(that.winrmUseHttps()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.size.hashCode();
        h *= 1000003;
        h ^= this.username.hashCode();
        h *= 1000003;
        h ^= this.password.hashCode();
        h *= 1000003;
        h ^= this.sourceImageName.hashCode();
        h *= 1000003;
        h ^= this.mediaLink.hashCode();
        h *= 1000003;
        h ^= this.os.hashCode();
        h *= 1000003;
        h ^= this.externalEndpoints.hashCode();
        h *= 1000003;
        h ^= this.virtualNetworkName == null ? 0 : this.virtualNetworkName.hashCode();
        h *= 1000003;
        h ^= this.reservedIPName == null ? 0 : this.reservedIPName.hashCode();
        h *= 1000003;
        h ^= this.subnetNames.hashCode();
        h *= 1000003;
        h ^= this.provisionGuestAgent == null ? 0 : this.provisionGuestAgent.hashCode();
        h *= 1000003;
        return h ^= this.winrmUseHttps == null ? 0 : this.winrmUseHttps.hashCode();
    }

    @Override
    DeploymentParams.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends DeploymentParams.Builder {
        private String name;
        private RoleSize.Type size;
        private String username;
        private String password;
        private String sourceImageName;
        private URI mediaLink;
        private OSImage.Type os;
        private Set<DeploymentParams.ExternalEndpoint> externalEndpoints;
        private String virtualNetworkName;
        private String reservedIPName;
        private List<String> subnetNames;
        private Boolean provisionGuestAgent;
        private Boolean winrmUseHttps;

        Builder() {
        }

        private Builder(DeploymentParams source) {
            this.name = source.name();
            this.size = source.size();
            this.username = source.username();
            this.password = source.password();
            this.sourceImageName = source.sourceImageName();
            this.mediaLink = source.mediaLink();
            this.os = source.os();
            this.externalEndpoints = source.externalEndpoints();
            this.virtualNetworkName = source.virtualNetworkName();
            this.reservedIPName = source.reservedIPName();
            this.subnetNames = source.subnetNames();
            this.provisionGuestAgent = source.provisionGuestAgent();
            this.winrmUseHttps = source.winrmUseHttps();
        }

        @Override
        public DeploymentParams.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public DeploymentParams.Builder size(RoleSize.Type size) {
            if (size == null) {
                throw new NullPointerException("Null size");
            }
            this.size = size;
            return this;
        }

        @Override
        public DeploymentParams.Builder username(String username) {
            if (username == null) {
                throw new NullPointerException("Null username");
            }
            this.username = username;
            return this;
        }

        @Override
        public DeploymentParams.Builder password(String password) {
            if (password == null) {
                throw new NullPointerException("Null password");
            }
            this.password = password;
            return this;
        }

        @Override
        public DeploymentParams.Builder sourceImageName(String sourceImageName) {
            if (sourceImageName == null) {
                throw new NullPointerException("Null sourceImageName");
            }
            this.sourceImageName = sourceImageName;
            return this;
        }

        @Override
        public DeploymentParams.Builder mediaLink(URI mediaLink) {
            if (mediaLink == null) {
                throw new NullPointerException("Null mediaLink");
            }
            this.mediaLink = mediaLink;
            return this;
        }

        @Override
        public DeploymentParams.Builder os(OSImage.Type os) {
            if (os == null) {
                throw new NullPointerException("Null os");
            }
            this.os = os;
            return this;
        }

        @Override
        public DeploymentParams.Builder externalEndpoints(Set<DeploymentParams.ExternalEndpoint> externalEndpoints) {
            if (externalEndpoints == null) {
                throw new NullPointerException("Null externalEndpoints");
            }
            this.externalEndpoints = externalEndpoints;
            return this;
        }

        @Override
        Set<DeploymentParams.ExternalEndpoint> externalEndpoints() {
            if (this.externalEndpoints == null) {
                throw new IllegalStateException("Property \"externalEndpoints\" has not been set");
            }
            return this.externalEndpoints;
        }

        @Override
        public DeploymentParams.Builder virtualNetworkName(@Nullable String virtualNetworkName) {
            this.virtualNetworkName = virtualNetworkName;
            return this;
        }

        @Override
        public DeploymentParams.Builder reservedIPName(@Nullable String reservedIPName) {
            this.reservedIPName = reservedIPName;
            return this;
        }

        @Override
        public DeploymentParams.Builder subnetNames(List<String> subnetNames) {
            if (subnetNames == null) {
                throw new NullPointerException("Null subnetNames");
            }
            this.subnetNames = subnetNames;
            return this;
        }

        @Override
        List<String> subnetNames() {
            if (this.subnetNames == null) {
                throw new IllegalStateException("Property \"subnetNames\" has not been set");
            }
            return this.subnetNames;
        }

        @Override
        public DeploymentParams.Builder provisionGuestAgent(@Nullable Boolean provisionGuestAgent) {
            this.provisionGuestAgent = provisionGuestAgent;
            return this;
        }

        @Override
        public DeploymentParams.Builder winrmUseHttps(@Nullable Boolean winrmUseHttps) {
            this.winrmUseHttps = winrmUseHttps;
            return this;
        }

        @Override
        DeploymentParams autoBuild() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.size == null) {
                missing = missing + " size";
            }
            if (this.username == null) {
                missing = missing + " username";
            }
            if (this.password == null) {
                missing = missing + " password";
            }
            if (this.sourceImageName == null) {
                missing = missing + " sourceImageName";
            }
            if (this.mediaLink == null) {
                missing = missing + " mediaLink";
            }
            if (this.os == null) {
                missing = missing + " os";
            }
            if (this.externalEndpoints == null) {
                missing = missing + " externalEndpoints";
            }
            if (this.subnetNames == null) {
                missing = missing + " subnetNames";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DeploymentParams(this.name, this.size, this.username, this.password, this.sourceImageName, this.mediaLink, this.os, this.externalEndpoints, this.virtualNetworkName, this.reservedIPName, this.subnetNames, this.provisionGuestAgent, this.winrmUseHttps);
        }
    }
}

