/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.strategy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.AzureComputeApi;
import org.jclouds.azurecompute.compute.config.AzureComputeServiceContextModule;
import org.jclouds.azurecompute.compute.options.AzureComputeTemplateOptions;
import org.jclouds.azurecompute.compute.predicates.StorageServicePredicates;
import org.jclouds.azurecompute.domain.CreateStorageServiceParams;
import org.jclouds.azurecompute.domain.StorageService;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;

@Singleton
public class GetOrCreateStorageServiceAndVirtualNetworkThenCreateNodes
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    private static final String DEFAULT_STORAGE_ACCOUNT_PREFIX = "jclouds";
    private static final String DEFAULT_STORAGE_SERVICE_TYPE = "Standard_GRS";
    private final AzureComputeApi api;
    private final Predicate<String> operationSucceededPredicate;
    private final AzureComputeServiceContextModule.AzureComputeConstants azureComputeConstants;

    @Inject
    protected GetOrCreateStorageServiceAndVirtualNetworkThenCreateNodes(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, AzureComputeApi api, Predicate<String> operationSucceededPredicate, AzureComputeServiceContextModule.AzureComputeConstants azureComputeConstants) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = api;
        this.operationSucceededPredicate = operationSucceededPredicate;
        this.azureComputeConstants = azureComputeConstants;
    }

    protected ListenableFuture<AtomicReference<NodeMetadata>> createNodeInGroupWithNameAndTemplate(String group, String name, Template template) {
        return super.createNodeInGroupWithNameAndTemplate(group, name, template);
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        AzureComputeTemplateOptions templateOptions = (AzureComputeTemplateOptions)template.getOptions().as(AzureComputeTemplateOptions.class);
        String location = template.getLocation().getId();
        String storageAccountName = templateOptions.getStorageAccountName();
        String storageAccountType = (String)MoreObjects.firstNonNull((Object)templateOptions.getStorageAccountType(), (Object)DEFAULT_STORAGE_SERVICE_TYPE);
        String virtualNetworkName = templateOptions.getVirtualNetworkName();
        if (storageAccountName != null) {
            if (this.api.getStorageAccountApi().get(storageAccountName) == null) {
                String message = String.format("storageAccountName %s specified via AzureComputeTemplateOptions doesn't exist", storageAccountName);
                this.logger.error(message, new Object[0]);
                throw new IllegalStateException(message);
            }
        } else {
            StorageService storageService = this.tryFindExistingStorageServiceAccountOrCreate(this.api, location, GetOrCreateStorageServiceAndVirtualNetworkThenCreateNodes.generateStorageServiceName(DEFAULT_STORAGE_ACCOUNT_PREFIX), storageAccountType);
            templateOptions.storageAccountName(storageService.serviceName());
        }
        if (virtualNetworkName != null && templateOptions.getSubnetNames().isEmpty()) {
            String message = "AzureComputeTemplateOption.subnetNames must not be empty, if AzureComputeTemplateOption.virtualNetworkName is defined.";
            this.logger.warn(message, new Object[0]);
            throw new IllegalArgumentException(message);
        }
        return super.execute(group, count, template, goodNodes, badNodes, customizationResponses);
    }

    private StorageService tryFindExistingStorageServiceAccountOrCreate(AzureComputeApi api, String location, String storageAccountName, String type) {
        List<StorageService> storageServices = api.getStorageAccountApi().list();
        this.logger.debug("Looking for a suitable existing storage account ...", new Object[0]);
        Predicate storageServicePredicate = Predicates.and((Predicate[])new Predicate[]{Predicates.notNull(), StorageServicePredicates.sameLocation(location), StorageServicePredicates.status(StorageService.Status.Created), StorageServicePredicates.matchesName(DEFAULT_STORAGE_ACCOUNT_PREFIX)});
        Optional storageServiceOptional = Iterables.tryFind(storageServices, (Predicate)storageServicePredicate);
        if (storageServiceOptional.isPresent()) {
            StorageService storageService = (StorageService)storageServiceOptional.get();
            this.logger.debug("Found a suitable existing storage service account '%s'", new Object[]{storageService});
            return storageService;
        }
        if (!this.checkAvailability(storageAccountName)) {
            this.logger.warn("The storage service account name %s is not available", new Object[]{storageAccountName});
            throw new IllegalStateException(String.format("Can't create a valid storage account with name %s. Please, try by choosing a different `storageAccountName` in templateOptions and try again", storageAccountName));
        }
        this.logger.debug("Creating a storage service account '%s' in location '%s' ...", new Object[]{storageAccountName, location});
        String createStorageServiceRequestId = api.getStorageAccountApi().create(CreateStorageServiceParams.builder().serviceName(storageAccountName).label(storageAccountName).location(location).accountType(StorageService.AccountType.valueOf(type)).build());
        if (!this.operationSucceededPredicate.apply((Object)createStorageServiceRequestId)) {
            String warnMessage = String.format("Create storage service account has not been completed within %sms.", this.azureComputeConstants.operationTimeout());
            this.logger.warn(warnMessage, new Object[0]);
            String illegalStateExceptionMessage = String.format("%s. Please, try by increasing `%s` and try again", warnMessage, "jclouds.azurecompute.operation.timeout");
            throw new IllegalStateException(illegalStateExceptionMessage);
        }
        return api.getStorageAccountApi().get(storageAccountName);
    }

    private boolean checkAvailability(String name) {
        return this.api.getStorageAccountApi().isAvailable(name).result();
    }

    private static String generateStorageServiceName(String prefix) {
        String characters = "abcdefghijklmnopqrstuvwxyz";
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        int charactersLength = characters.length();
        for (int i = 0; i < 10; ++i) {
            double index = Math.random() * (double)charactersLength;
            builder.append(characters.charAt((int)index));
        }
        return builder.toString();
    }
}

