/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.CaseFormat;
import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.azurecompute.domain.VMImageParams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public final class VMImageParamsToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        VMImageParams params = (VMImageParams)VMImageParams.class.cast(input);
        try {
            XMLBuilder builder = XMLBuilder.create((String)"VMImage", (String)"http://schemas.microsoft.com/windowsazure");
            this.add(builder, "Name", params.name());
            this.add(builder, "Label", params.label());
            this.add(builder, "Description", params.description());
            VMImageParams.OSDiskConfigurationParams osDiskConfig = params.osDiskConfiguration();
            if (osDiskConfig != null) {
                String cache = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, osDiskConfig.hostCaching().toString());
                XMLBuilder osConfigBuilder = builder.e("OSDiskConfiguration");
                osConfigBuilder.e("HostCaching").t(cache).up().e("OSState").t(osDiskConfig.osState().toString()).up().e("OS").t(osDiskConfig.os().toString()).up().e("MediaLink").t(osDiskConfig.mediaLink().toASCIIString()).up().up();
            }
            builder.up();
            builder.e("DataDiskConfigurations").up();
            this.add(builder, "Language", params.language());
            this.add(builder, "ImageFamily", params.imageFamily());
            RoleSize.Type vmSize = params.recommendedVMSize();
            if (vmSize != null) {
                String vmSizeText = params.recommendedVMSize().getText();
                builder.e("RecommendedVMSize").t(vmSizeText).up();
            }
            this.add(builder, "Eula", params.eula());
            this.add(builder, "IconUri", params.iconUri());
            this.add(builder, "SmallIconUri", params.smallIconUri());
            this.add(builder, "PrivacyUri", params.privacyUri());
            if (params.showGui() != null) {
                String showGuiText = params.showGui().toString();
                builder.e("ShowGui").t(showGuiText).up();
            }
            builder.up();
            return (R)((HttpRequest.Builder)request.toBuilder().payload(builder.asString())).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private XMLBuilder add(XMLBuilder xmlBuilder, String entity, String text) {
        if (text != null) {
            return xmlBuilder.e(entity).t(text).up();
        }
        return xmlBuilder.e(entity).up();
    }

    private XMLBuilder add(XMLBuilder xmlBuilder, String entity, URI text) {
        if (text != null) {
            return xmlBuilder.e(entity).t(text.toASCIIString()).up();
        }
        return xmlBuilder.e(entity).up();
    }
}

