/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import org.jclouds.azurecompute.domain.ProfileDefinitionEndpointParams;
import org.jclouds.azurecompute.domain.ProfileDefinitionParams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public final class ProfileDefinitionParamsToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        ProfileDefinitionParams params = (ProfileDefinitionParams)ProfileDefinitionParams.class.cast(input);
        try {
            XMLBuilder bld = XMLBuilder.create((String)"Definition", (String)"http://schemas.microsoft.com/windowsazure");
            bld.e("DnsOptions").e("TimeToLiveInSeconds").t(params.ttl().toString()).up().up();
            bld.e("Monitors").e("Monitor").e("IntervalInSeconds").t("30").up().e("TimeoutInSeconds").t("10").up().e("ToleratedNumberOfFailures").t("3").up().e("Protocol").t(params.protocol().name()).up().e("Port").t(params.port().toString()).up().e("HttpOptions").e("Verb").t("GET").up().e("RelativePath").t(params.path()).up().e("ExpectedStatusCode").t("200");
            bld = bld.e("Policy").e("LoadBalancingMethod").t(params.lb().getValue()).up().e("Endpoints");
            for (ProfileDefinitionEndpointParams endpoint : params.endpoints()) {
                bld = bld.e("Endpoint").e("DomainName").t(endpoint.domain()).up().e("Status").t(endpoint.status().getValue()).up();
                if (endpoint.type() != null) {
                    bld = bld.e("Type").t(endpoint.type().getValue()).up();
                }
                if (endpoint.location() != null) {
                    bld = bld.e("Location").t(endpoint.location()).up();
                }
                if (endpoint.min() != null) {
                    bld = bld.e("MinChildEndpoints").t(endpoint.min().toString()).up();
                }
                if (endpoint.weight() != null) {
                    bld = bld.e("Weight").t(endpoint.weight().toString()).up();
                }
                bld = bld.up();
            }
            bld.up().up();
            return (R)((HttpRequest.Builder)request.toBuilder().payload(bld.up().asString())).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

