/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos;

import org.jclouds.atmos.domain.AtmosError;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;

public class AtmosResponseException
extends HttpResponseException {
    private AtmosError error;

    public AtmosResponseException(HttpCommand command, HttpResponse response, AtmosError error) {
        super(String.format("command %s failed with code %s, error: %s", command.getCurrentRequest().getRequestLine(), response.getStatusCode(), error.toString()), command, response);
        this.setError(error);
    }

    public AtmosResponseException(HttpCommand command, HttpResponse response, AtmosError error, Throwable cause) {
        super(String.format("command %1$s failed with error: %2$s", command.getCurrentRequest().getRequestLine(), error.toString()), command, response, cause);
        this.setError(error);
    }

    public AtmosResponseException(String message, HttpCommand command, HttpResponse response, AtmosError error) {
        super(message, command, response);
        this.setError(error);
    }

    public AtmosResponseException(String message, HttpCommand command, HttpResponse response, AtmosError error, Throwable cause) {
        super(message, command, response, cause);
        this.setError(error);
    }

    public void setError(AtmosError error) {
        this.error = error;
    }

    public AtmosError getError() {
        return this.error;
    }
}

