/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.options.GetOptions;
import org.jclouds.location.Provider;

@Singleton
public class AzureBlobRequestSigner
implements BlobRequestSigner {
    private static final int DEFAULT_EXPIRY_SECONDS = 900;
    private static final String API_VERSION = "2017-04-17";
    private final String identity;
    private final URI storageUrl;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final com.google.inject.Provider<String> timeStampProvider;
    private final DateService dateService;
    private final SharedKeyLiteAuthentication auth;

    @Inject
    public AzureBlobRequestSigner(BlobToHttpGetOptions blob2HttpGetOptions, @TimeStamp com.google.inject.Provider<String> timeStampProvider, DateService dateService, SharedKeyLiteAuthentication auth, @Provider Supplier<Credentials> creds) throws SecurityException, NoSuchMethodException {
        this.identity = ((Credentials)creds.get()).identity;
        this.storageUrl = URI.create("https://" + ((Credentials)creds.get()).identity + ".blob.core.windows.net/");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.timeStampProvider = (com.google.inject.Provider)Preconditions.checkNotNull(timeStampProvider, (Object)"timeStampProvider");
        this.dateService = (DateService)Preconditions.checkNotNull((Object)dateService, (Object)"dateService");
        this.auth = auth;
    }

    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, 900L);
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.sign("GET", container, name, null, timeInSeconds, null);
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        return this.signPutBlob(container, blob, 900L);
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        return this.sign("PUT", container, blob.getMetadata().getName(), null, timeInSeconds, blob.getMetadata().getContentMetadata().getContentLength());
    }

    @Deprecated
    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.sign("DELETE", container, name, null, 900L, null);
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.sign("GET", container, name, this.blob2HttpGetOptions.apply((org.jclouds.blobstore.options.GetOptions)Preconditions.checkNotNull((Object)options, (Object)"options")), 900L, null);
    }

    private HttpRequest sign(String method, String container, String name, GetOptions options, long expires, Long contentLength) {
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        String nowString = (String)this.timeStampProvider.get();
        Date now = this.dateService.rfc1123DateParse(nowString);
        Date expiration = new Date(now.getTime() + TimeUnit.SECONDS.toMillis(expires));
        String iso8601 = this.dateService.iso8601SecondsDateFormat(expiration);
        String signedPermission = method.equals("PUT") ? "w" : (method.equals("DELETE") ? "d" : "r");
        HttpRequest.Builder request = ((HttpRequest.Builder)HttpRequest.builder().method(method).endpoint(Uris.uriBuilder((URI)this.storageUrl).appendPath(container).appendPath(name).build()).replaceHeader("Date", new String[]{nowString})).addQueryParam("sv", new String[]{API_VERSION}).addQueryParam("se", new String[]{iso8601}).addQueryParam("sr", new String[]{"b"}).addQueryParam("sp", new String[]{signedPermission});
        if (contentLength != null) {
            request.replaceHeader("Content-Length", new String[]{contentLength.toString()});
        }
        if (options != null) {
            request.headers(options.buildRequestHeaders());
        }
        if (method.equals("PUT")) {
            request.replaceHeader("x-ms-blob-type", new String[]{"BlockBlob"});
        }
        String stringToSign = signedPermission + "\n" + "\n" + iso8601 + "\n" + "/blob/" + this.identity + "/" + container + "/" + name + "\n" + "\n" + "\n" + "\n" + API_VERSION + "\n" + "\n" + "\n" + "\n" + "\n" + "";
        String signature = this.auth.calculateSignature(stringToSign);
        request.addQueryParam("sig", new String[]{signature});
        return request.build();
    }
}

