/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.test.framework.TestFrameworkAssertions;
import org.apache.brooklyn.test.framework.TestWinrmCommand;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.internal.winrm.WinRmToolResponse;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWinrmCommandImpl
extends TargetableTestComponentImpl
implements TestWinrmCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TestWinrmCommandImpl.class);
    private static final int A_LINE = 80;

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        this.execute();
    }

    public void stop() {
        LOG.debug("{} Stopping simple command", (Object)this);
        this.setUpAndRunState(false, Lifecycle.STOPPED);
    }

    public void restart() {
        LOG.debug("{} Restarting simple command", (Object)this);
        this.execute();
    }

    private String shorten(String text) {
        return Strings.maxlenWithEllipsis((String)text, (int)80);
    }

    public void execute() {
        try {
            this.checkConfig();
            final WinRmMachineLocation machineLocation = (WinRmMachineLocation)Machines.findUniqueMachineLocation((Iterable)this.resolveTarget().getLocations(), WinRmMachineLocation.class).get();
            Duration timeout = (Duration)this.getRequiredConfig(TIMEOUT);
            Duration backoffToPeriod = (Duration)this.getRequiredConfig(BACKOFF_TO_PERIOD);
            ReferenceWithError result = Repeater.create((String)"Running winrm-command tests").limitTimeTo(timeout).limitIterationsTo(((Integer)this.getRequiredConfig(ITERATION_LIMIT)).intValue()).backoffTo(backoffToPeriod != null ? backoffToPeriod : Duration.millis((Number)500)).until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        WinRmToolResponse result = TestWinrmCommandImpl.this.execute(machineLocation);
                        TestWinrmCommandImpl.this.handle(result);
                    }
                    catch (AssertionError e) {
                        throw new MarkerException((Throwable)((Object)e));
                    }
                    return true;
                }
            }).runKeepingError();
            if (result.hasError()) {
                this.setUpAndRunState(false, Lifecycle.ON_FIRE);
                Throwable error = result.getError();
                if (error instanceof MarkerException) {
                    error = error.getCause();
                }
                throw Exceptions.propagate((Throwable)error);
            }
            this.setUpAndRunState(true, Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    private WinRmToolResponse execute(WinRmMachineLocation machineLocation) {
        WinRmToolResponse result = null;
        String psScript = (String)this.getConfig(PS_SCRIPT);
        String command = (String)this.getConfig(COMMAND);
        if (Strings.isNonBlank((CharSequence)psScript)) {
            result = this.executePsScript(machineLocation, psScript);
        } else if (Strings.isNonBlank((CharSequence)command)) {
            result = this.executeCommand(machineLocation, command);
        } else {
            throw this.illegal("Must specify exactly one of", PS_SCRIPT.getName(), "and", COMMAND.getName());
        }
        return result;
    }

    protected void checkConfig() {
        String psScript = (String)this.getConfig(PS_SCRIPT);
        String command = (String)this.getConfig(COMMAND);
        if (!(Strings.isNonBlank((CharSequence)psScript) ^ Strings.isNonBlank((CharSequence)command))) {
            String psScriptName = PS_SCRIPT.getName();
            String commandName = COMMAND.getName();
            throw this.illegal("Must specify exactly one of", psScriptName, "and", commandName);
        }
    }

    protected void handle(WinRmToolResponse result) {
        LOG.debug("{}, Result is {}\nwith output [\n{}\n] and error [\n{}\n]", new Object[]{this, result.getStatusCode(), this.shorten(result.getStdOut()), this.shorten(result.getStdErr())});
        TestFrameworkAssertions.AssertionSupport support = new TestFrameworkAssertions.AssertionSupport();
        for (Map<String, Object> assertion : this.exitCodeAssertions()) {
            TestFrameworkAssertions.checkActualAgainstAssertions(support, assertion, "exit code", result.getStatusCode());
        }
        for (Map<String, Object> assertion : TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_OUT)) {
            TestFrameworkAssertions.checkActualAgainstAssertions(support, assertion, "stdout", result.getStdOut());
        }
        for (Map<String, Object> assertion : TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_ERR)) {
            TestFrameworkAssertions.checkActualAgainstAssertions(support, assertion, "stderr", result.getStdErr());
        }
        support.validate();
    }

    private WinRmToolResponse executeCommand(final WinRmMachineLocation machine, final String command) {
        TaskBuilder tb = Tasks.builder().displayName("winrm-exec").body((Callable)new Callable<WinRmToolResponse>(){

            @Override
            public WinRmToolResponse call() throws Exception {
                return machine.executeCommand(command);
            }
        });
        return this.execute((TaskBuilder<WinRmToolResponse>)tb, command);
    }

    private WinRmToolResponse executePsScript(final WinRmMachineLocation machine, final String psScript) {
        TaskBuilder tb = Tasks.builder().displayName("winrm-exec").body((Callable)new Callable<WinRmToolResponse>(){

            @Override
            public WinRmToolResponse call() throws Exception {
                return machine.executePsScript(psScript);
            }
        });
        return this.execute((TaskBuilder<WinRmToolResponse>)tb, psScript);
    }

    private WinRmToolResponse execute(TaskBuilder<WinRmToolResponse> tb, String cmdIn) {
        WinRmToolResponse result;
        try {
            ByteArrayOutputStream stdin = new ByteArrayOutputStream();
            if (cmdIn != null) {
                stdin.write(cmdIn.getBytes());
            }
            tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdin", (ByteArrayOutputStream)stdin));
        }
        catch (IOException e) {
            LOG.warn("Error registering stream stdin on " + tb + ": " + e, (Throwable)e);
        }
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)stdout));
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        tb.tag((Object)BrooklynTaskTags.tagForStreamSoft((String)"stderr", (ByteArrayOutputStream)stderr));
        Task task = tb.build();
        DynamicTasks.queueIfPossible((TaskAdaptable)task).orSubmitAndBlock().getTask().blockUntilEnded();
        try {
            result = (WinRmToolResponse)task.get();
            if (result.getStdOut() != null) {
                stdout.write(result.getStdOut().getBytes());
            }
            if (result.getStdErr() != null) {
                stderr.write(result.getStdErr().getBytes());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return result;
    }

    private IllegalArgumentException illegal(String message, String ... messages) {
        Iterable allmsgs = Iterables.concat((Iterable)MutableList.of((Object)(this.toString() + ":"), (Object)message, (Object[])new String[0]), Arrays.asList(messages));
        return new IllegalArgumentException(Joiner.on((char)' ').join(allmsgs));
    }

    private List<Map<String, Object>> exitCodeAssertions() {
        MutableList result;
        MutableList assertStatus = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_STATUS);
        List<Map<String, Object>> assertOut = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_OUT);
        List<Map<String, Object>> assertErr = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERT_ERR);
        if (assertStatus.isEmpty() && assertOut.isEmpty() && assertErr.isEmpty()) {
            Map shouldSucceed = DEFAULT_ASSERTION;
            result = MutableList.of((Object)shouldSucceed);
        } else {
            result = assertStatus;
        }
        return result;
    }

    private static class MarkerException
    extends Exception {
        public MarkerException(Throwable cause) {
            super(cause);
        }
    }
}

