/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.failover;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.enricher.stock.Propagator;
import org.apache.brooklyn.policy.failover.ElectPrimaryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class PropagatePrimaryEnricher
extends AbstractEnricher
implements SensorEventListener<Object> {
    private static final Logger log = LoggerFactory.getLogger(PropagatePrimaryEnricher.class);
    public static final ConfigKey<String> PRIMARY_SENSOR_NAME = ElectPrimaryConfig.PRIMARY_SENSOR_NAME;
    public static final ConfigKey<Entity> CURRENT_PROPAGATED_PRODUCER = ConfigKeys.newConfigKey(Entity.class, (String)"propagate.primary.enricher.current.producer");
    public static final ConfigKey<String> CURRENT_PROPAGATOR_ID = ConfigKeys.newStringConfigKey((String)"propagate.primary.enricher.current.propagatorId");
    public static final ConfigKey<Collection<? extends Sensor<?>>> PROPAGATING = Propagator.PROPAGATING;

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscriptions().subscribe((Entity)entity, (Sensor)Sensors.newSensor(Entity.class, (String)((String)this.config().get(PRIMARY_SENSOR_NAME))), (SensorEventListener)this);
        this.onEvent(null);
    }

    public synchronized void onEvent(SensorEvent<Object> event) {
        Entity lastPrimary;
        Entity primary = (Entity)this.entity.getAttribute(Sensors.newSensor(Entity.class, (String)((String)this.config().get(PRIMARY_SENSOR_NAME))));
        if (!Objects.equal((Object)primary, (Object)(lastPrimary = (Entity)this.config().get(CURRENT_PROPAGATED_PRODUCER)))) {
            Collection sensorsToRemove;
            log.debug("Removing propagated items from " + lastPrimary + " at " + this.entity);
            Propagator propagator = (Propagator)this.getManagementContext().lookup((String)this.config().get(CURRENT_PROPAGATOR_ID), Propagator.class);
            if (propagator != null) {
                this.entity.enrichers().remove((Enricher)propagator);
                this.config().set(CURRENT_PROPAGATOR_ID, (Object)null);
            }
            if ((sensorsToRemove = (Collection)this.config().get(PROPAGATING)) != null) {
                for (Sensor s : sensorsToRemove) {
                    if (!(s instanceof AttributeSensor)) continue;
                    ((EntityInternal)this.entity).sensors().remove((AttributeSensor)s);
                }
            }
            if (primary != null) {
                this.config().set(CURRENT_PROPAGATED_PRODUCER, (Object)primary);
                this.addPropagatorEnricher(primary);
            }
        }
    }

    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        if (CURRENT_PROPAGATED_PRODUCER.equals(key)) {
            return;
        }
        if (CURRENT_PROPAGATOR_ID.equals(key)) {
            return;
        }
        super.doReconfigureConfig(key, val);
    }

    protected void addPropagatorEnricher(Entity primary) {
        EnricherSpec spec = EnricherSpec.create(Propagator.class);
        spec.configure(Propagator.PRODUCER, (Object)primary);
        Collection sensorsToPropagate = (Collection)this.getConfig(PROPAGATING);
        if (sensorsToPropagate == null || sensorsToPropagate.isEmpty()) {
            log.warn("");
            return;
        }
        spec.configure(Propagator.PROPAGATING, (Object)sensorsToPropagate);
        log.debug("Adding propagator " + spec + " to " + this.entity + " to track " + primary);
        Propagator propagator = (Propagator)this.entity.enrichers().add(spec);
        this.config().set(CURRENT_PROPAGATOR_ID, (Object)propagator.getId());
    }
}

