/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.util.Comparator;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.javalang.Reflections;

public class FieldOrderings {
    public static Comparator<Class<?>> SUB_BEST_CLASS_COMPARATOR = new SubbestClassComparator();
    public static Comparator<Field> SUB_BEST_FIELD_FIST_THEN_DEFAULT = new FieldClassComparator(SUB_BEST_CLASS_COMPARATOR);
    public static Comparator<Field> SUB_BEST_FIELD_LAST_THEN_DEFAULT = new FieldClassComparator((Comparator<Class<?>>)Ordering.from(SUB_BEST_CLASS_COMPARATOR).reverse());
    public static Comparator<Field> SUB_BEST_FIELD_FIRST_THEN_ALPHABETICAL = Ordering.compound(MutableList.of(new FieldClassComparator(SUB_BEST_CLASS_COMPARATOR), new FieldNameComparator((Comparator<String>)Ordering.natural()), new Comparator[0]));
    public static Comparator<Field> SUB_BEST_FIELD_LAST_THEN_ALPHABETICAL = Ordering.compound(MutableList.of(new FieldClassComparator((Comparator<Class<?>>)Ordering.from(SUB_BEST_CLASS_COMPARATOR).reverse()), new FieldNameComparator((Comparator<String>)Ordering.natural()), new Comparator[0]));
    public static Comparator<Field> ALPHABETICAL_FIELD_THEN_SUB_BEST_FIRST = Ordering.compound(MutableList.of(new FieldNameComparator((Comparator<String>)Ordering.natural()), new FieldClassComparator(SUB_BEST_CLASS_COMPARATOR), new Comparator[0]));
    public static Comparator<Field> ALPHABETICAL_FIELD_THEN_SUB_BEST_LAST = Ordering.compound(MutableList.of(new FieldNameComparator((Comparator<String>)Ordering.natural()), new FieldClassComparator((Comparator<Class<?>>)Ordering.from(SUB_BEST_CLASS_COMPARATOR).reverse()), new Comparator[0]));

    private static class SubbestClassComparator
    implements Comparator<Class<?>> {
        private SubbestClassComparator() {
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            Class<?> cS = Reflections.inferSubbest(c1, c2);
            return cS == c1 ? -1 : (cS == c2 ? 1 : 0);
        }
    }

    public static class FieldClassComparator
    implements Comparator<Field> {
        private final Comparator<Class<?>> classComparator;

        public FieldClassComparator(Comparator<Class<?>> classComparator) {
            this.classComparator = classComparator;
        }

        @Override
        public int compare(Field o1, Field o2) {
            return this.classComparator.compare(o1.getDeclaringClass(), o2.getDeclaringClass());
        }
    }

    public static class FieldNameComparator
    implements Comparator<Field> {
        private final Comparator<String> nameComparator;

        public FieldNameComparator(Comparator<String> nameComparator) {
            this.nameComparator = nameComparator;
        }

        @Override
        public int compare(Field o1, Field o2) {
            return this.nameComparator.compare(o1.getName(), o2.getName());
        }
    }
}

