/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class Asserts {
    public static final long THIRTY_SECONDS_TIMEOUT_MS = 30000L;
    public static final Duration DEFAULT_LONG_TIMEOUT;
    public static final Duration DEFAULT_SHORT_TIMEOUT;
    private static final Duration DEFAULT_SHORT_PERIOD;
    private static final Logger log;
    private static final Character OPENING_CHARACTER;
    private static final Character CLOSING_CHARACTER;
    private static final String ASSERT_LEFT;
    private static final String ASSERT_MIDDLE;
    private static final String ASSERT_RIGHT;

    private Asserts() {
    }

    static String format(Object actual, Object expected, String message) {
        String formatted = "";
        if (null != message) {
            formatted = message + " ";
        }
        return formatted + ASSERT_LEFT + expected + ASSERT_MIDDLE + actual + ASSERT_RIGHT;
    }

    private static void failNotEquals(Object actual, Object expected, String message) {
        Asserts.fail(Asserts.format(actual, expected, message));
    }

    public static void assertNull(Object object) {
        Asserts.assertNull(object, null);
    }

    public static void assertNotNull(Object object) {
        Asserts.assertNotNull(object, null);
    }

    public static void assertNull(Object object, String message) {
        if (null != object) {
            throw new AssertionError((Object)(message == null ? "object reference is not null" : message));
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (null == object) {
            throw new AssertionError((Object)(message == null ? "object reference is null" : message));
        }
    }

    public static void assertEquals(Collection<?> actual, Collection<?> expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Collection<?> actual, Collection<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message != null) {
                Asserts.fail(message);
            } else {
                Asserts.fail("Collections not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        Asserts.assertEquals(actual.size(), expected.size(), message + ": lists don't have the same size");
        Iterator<?> actIt = actual.iterator();
        Iterator<?> expIt = expected.iterator();
        int i = -1;
        while (actIt.hasNext() && expIt.hasNext()) {
            Object e = expIt.next();
            Object a = actIt.next();
            String explanation = "Lists differ at element [" + ++i + "]: " + e + " != " + a;
            String errorMessage = message == null ? explanation : message + ": " + explanation;
            Asserts.assertEquals(a, e, errorMessage);
        }
    }

    public static void assertEquals(Iterator<?> actual, Iterator<?> expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Iterator<?> actual, Iterator<?> expected, String message) {
        String errorMessage;
        String explanation;
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message != null) {
                Asserts.fail(message);
            } else {
                Asserts.fail("Iterators not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        int i = -1;
        while (actual.hasNext() && expected.hasNext()) {
            Object e = expected.next();
            Object a = actual.next();
            String explanation2 = "Iterators differ at element [" + ++i + "]: " + e + " != " + a;
            String errorMessage2 = message == null ? explanation2 : message + ": " + explanation2;
            Asserts.assertEquals(a, e, errorMessage2);
        }
        if (actual.hasNext()) {
            explanation = "Actual iterator returned more elements than the expected iterator.";
            errorMessage = message == null ? explanation : message + ": " + explanation;
            Asserts.fail(errorMessage);
        } else if (expected.hasNext()) {
            explanation = "Expected iterator returned more elements than the actual iterator.";
            errorMessage = message == null ? explanation : message + ": " + explanation;
            Asserts.fail(errorMessage);
        }
    }

    public static void assertEquals(Iterable<?> actual, Iterable<?> expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Iterable<?> actual, Iterable<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message != null) {
                Asserts.fail(message);
            } else {
                Asserts.fail("Iterables not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        Iterator<?> actIt = actual.iterator();
        Iterator<?> expIt = expected.iterator();
        Asserts.assertEquals(actIt, expIt, message);
    }

    public static void assertEquals(Set<?> actual, Set<?> expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Set<?> actual, Set<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message == null) {
                Asserts.fail("Sets not equal: expected: " + expected + " and actual: " + actual);
            } else {
                Asserts.failNotEquals(actual, expected, message);
            }
        }
        if (!actual.equals(expected)) {
            if (message == null) {
                Asserts.fail("Sets differ: expected " + expected + " but got " + actual);
            } else {
                Asserts.failNotEquals(actual, expected, message);
            }
        }
    }

    public static void assertEquals(Map<?, ?> actual, Map<?, ?> expected) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            Asserts.fail("Maps not equal: expected: " + expected + " and actual: " + actual);
        }
        if (actual.size() != expected.size()) {
            Asserts.fail("Maps do not have the same size:" + actual.size() + " != " + expected.size());
        }
        Set<Map.Entry<?, ?>> entrySet = actual.entrySet();
        for (Map.Entry<?, ?> entry : entrySet) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object expectedValue = expected.get(key);
            Asserts.assertEquals(value, expectedValue, "Maps do not match for key:" + key + " actual:" + value + " expected:" + expectedValue);
        }
    }

    public static void assertEquals(Object[] actual, Object[] expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            if (message != null) {
                Asserts.fail(message);
            } else {
                Asserts.fail("Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual));
            }
        }
        Asserts.assertEquals(Arrays.asList(actual), Arrays.asList(expected), message);
    }

    public static void assertEquals(Object[] actual, Object[] expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Object actual, Object expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Object actual, Object expected, String message) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null) {
            if (expected.getClass().isArray()) {
                Asserts.assertArrayEquals(actual, expected, message);
                return;
            }
            if (expected.equals(actual)) {
                return;
            }
        }
        Asserts.failNotEquals(actual, expected, message);
    }

    private static void assertArrayEquals(Object actual, Object expected, String message) {
        if (actual.getClass().isArray()) {
            int expectedLength = Array.getLength(expected);
            if (expectedLength == Array.getLength(actual)) {
                for (int i = 0; i < expectedLength; ++i) {
                    Object _actual = Array.get(actual, i);
                    Object _expected = Array.get(expected, i);
                    try {
                        Asserts.assertEquals(_actual, _expected);
                        continue;
                    }
                    catch (AssertionError ae) {
                        Asserts.failNotEquals(actual, expected, message == null ? "" : message + " (values at index " + i + " are not the same)");
                    }
                }
                return;
            }
            Asserts.failNotEquals(Array.getLength(actual), expectedLength, message == null ? "" : message + " (Array lengths are not the same)");
        }
        Asserts.failNotEquals(actual, expected, message);
    }

    public static void assertEquals(String actual, String expected, String message) {
        Asserts.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(String actual, String expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(double actual, double expected, double delta, String message) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                Asserts.failNotEquals(new Double(actual), new Double(expected), message);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            Asserts.failNotEquals(new Double(actual), new Double(expected), message);
        }
    }

    public static void assertEquals(double actual, double expected, double delta) {
        Asserts.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(float actual, float expected, float delta, String message) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                Asserts.failNotEquals(new Float(actual), new Float(expected), message);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            Asserts.failNotEquals(new Float(actual), new Float(expected), message);
        }
    }

    public static void assertEquals(float actual, float expected, float delta) {
        Asserts.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(long actual, long expected, String message) {
        Asserts.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(long actual, long expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(boolean actual, boolean expected, String message) {
        Asserts.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(boolean actual, boolean expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(byte actual, byte expected, String message) {
        Asserts.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(byte actual, byte expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(char actual, char expected, String message) {
        Asserts.assertEquals(Character.valueOf(actual), Character.valueOf(expected), message);
    }

    public static void assertEquals(char actual, char expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(short actual, short expected, String message) {
        Asserts.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(short actual, short expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertEquals(int actual, int expected, String message) {
        Asserts.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(int actual, int expected) {
        Asserts.assertEquals(actual, expected, null);
    }

    public static void assertTrue(boolean condition) {
        if (!condition) {
            Asserts.fail();
        }
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            Asserts.fail(message);
        }
    }

    public static void assertFalse(boolean condition, String message) {
        if (condition) {
            Asserts.fail(message);
        }
    }

    public static void assertFalse(boolean condition) {
        if (condition) {
            Asserts.fail();
        }
    }

    public static AssertionError fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static AssertionError fail(Throwable error) {
        throw new AssertionError((Object)error);
    }

    public static AssertionError fail() {
        throw new AssertionError();
    }

    public static void assertEqualsIgnoringOrder(Iterable<?> actual, Iterable<?> expected) {
        Asserts.assertEqualsIgnoringOrder(actual, expected, false, null);
    }

    public static void assertEqualsIgnoringOrder(Iterable<?> actual, Iterable<?> expected, boolean logDuplicates, String errmsg) {
        LinkedHashSet actualSet = Sets.newLinkedHashSet(actual);
        LinkedHashSet expectedSet = Sets.newLinkedHashSet(expected);
        Sets.SetView extras = Sets.difference((Set)actualSet, (Set)expectedSet);
        Sets.SetView missing = Sets.difference((Set)expectedSet, (Set)actualSet);
        ArrayList duplicates = Lists.newArrayList(actual);
        for (Object a : actualSet) {
            duplicates.remove(a);
        }
        String fullErrmsg = "extras=" + extras + "; missing=" + missing + (logDuplicates ? "; duplicates=" + MutableSet.copyOf(duplicates) : "") + "; actualSize=" + Iterables.size(actual) + "; expectedSize=" + Iterables.size(expected) + "; actual=" + actual + "; expected=" + expected + "; " + errmsg;
        Asserts.assertTrue(extras.isEmpty(), fullErrmsg);
        Asserts.assertTrue(missing.isEmpty(), fullErrmsg);
        Asserts.assertTrue(Iterables.size(actual) == Iterables.size(expected), fullErrmsg);
        Asserts.assertTrue(actualSet.equals(expectedSet), fullErrmsg);
    }

    public static <T> void eventually(Supplier<? extends T> supplier, Predicate<T> predicate) {
        Asserts.eventually(supplier, predicate, null, null, null);
    }

    public static <T> void eventually(Supplier<? extends T> supplier, Predicate<T> predicate, Duration timeout) {
        Asserts.eventually(supplier, predicate, timeout, null, null);
    }

    public static <T> void eventually(Supplier<? extends T> supplier, Predicate<T> predicate, Duration timeout, Duration period, String errMsg) {
        Asserts.eventually(supplier, predicate, timeout, period, errMsg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void eventually(Supplier<? extends T> supplier, Predicate<T> predicate, Duration timeout, Duration period, String errMsg, Object notifyObject) {
        Object supplied;
        if (timeout == null) {
            timeout = DEFAULT_LONG_TIMEOUT;
        }
        if (period == null) {
            period = DEFAULT_SHORT_PERIOD;
        }
        CountdownTimer timeleft = timeout.countdownTimer();
        int count = 0;
        do {
            if (count++ > 0) {
                if (notifyObject != null) {
                    Object object = notifyObject;
                    synchronized (object) {
                        try {
                            notifyObject.wait(period.toMilliseconds());
                        }
                        catch (InterruptedException e) {
                            throw Exceptions.propagate(e);
                        }
                    }
                }
                Duration.sleep(period);
            }
            if (!predicate.apply(supplied = supplier.get())) continue;
            return;
        } while (timeleft.isNotExpired());
        Asserts.fail("Expected: eventually " + predicate + "; got most recently: " + supplied + " (waited " + timeleft.getDurationElapsed() + ", checked " + count + ")" + (errMsg != null ? "; " + errMsg : ""));
    }

    public static <T> void continually(Supplier<? extends T> supplier, Predicate<T> predicate) {
        Asserts.continually(supplier, predicate, null, null, null);
    }

    public static <T> void continually(Supplier<? extends T> supplier, Predicate<T> predicate, Duration duration, Duration period, String errMsg) {
        if (duration == null) {
            duration = DEFAULT_SHORT_TIMEOUT;
        }
        if (period == null) {
            period = DEFAULT_SHORT_PERIOD;
        }
        CountdownTimer timeleft = duration.countdownTimer();
        int count = 0;
        do {
            Object supplied;
            if (count > 0) {
                Duration.sleep(period);
            }
            if (!predicate.apply(supplied = supplier.get())) {
                Asserts.fail("Expected: continually " + predicate + "; got violation: " + supplied + (count > 0 ? " (after " + timeleft.getDurationElapsed() + ", successfully checked " + count + ")" : "") + (errMsg != null ? "; " + errMsg : ""));
            }
            ++count;
        } while (timeleft.isNotExpired());
    }

    public static void succeedsEventually(Runnable r) {
        Asserts.succeedsEventually(ImmutableMap.of(), r);
    }

    public static void succeedsEventually(Map<String, ?> flags, Runnable r) {
        Asserts.succeedsEventually(flags, Asserts.toCallable(r));
    }

    public static <T> T succeedsEventually(Callable<T> c) {
        return Asserts.succeedsEventually(ImmutableMap.of(), c);
    }

    public static <T> T succeedsEventually(Map<String, ?> flags, Callable<T> c) {
        boolean abortOnException = Asserts.get(flags, "abortOnException", false);
        boolean abortOnError = Asserts.get(flags, "abortOnError", false);
        boolean useGroovyTruth = Asserts.get(flags, "useGroovyTruth", false);
        boolean logException = Asserts.get(flags, "logException", true);
        Duration duration = Asserts.toDuration(flags.get("timeout"), DEFAULT_LONG_TIMEOUT);
        Duration fixedPeriod = Asserts.toDuration(flags.get("period"), null);
        Duration minPeriod = fixedPeriod != null ? fixedPeriod : Asserts.toDuration(flags.get("minPeriod"), Duration.millis(1));
        Duration maxPeriod = fixedPeriod != null ? fixedPeriod : Asserts.toDuration(flags.get("maxPeriod"), Duration.millis(500));
        int maxAttempts = Asserts.get(flags, "maxAttempts", Integer.MAX_VALUE);
        int attempt = 0;
        long startTime = System.currentTimeMillis();
        try {
            Throwable lastException = null;
            T result = null;
            long lastAttemptTime = 0L;
            long expireTime = startTime + duration.toMilliseconds();
            long sleepTimeBetweenAttempts = minPeriod.toMilliseconds();
            while (attempt < maxAttempts && lastAttemptTime < expireTime) {
                block16: {
                    try {
                        ++attempt;
                        lastAttemptTime = System.currentTimeMillis();
                        result = c.call();
                        if (log.isTraceEnabled()) {
                            log.trace("Attempt {} after {} ms: {}", new Object[]{attempt, System.currentTimeMillis() - startTime, result});
                        }
                        if (useGroovyTruth) {
                            if (Asserts.groovyTruth(result)) {
                                return result;
                            }
                        } else {
                            if (Boolean.FALSE.equals(result)) {
                                if (result instanceof BooleanWithMessage) {
                                    log.warn("Test returned an instance of BooleanWithMessage but useGroovyTruth is not set! The result of this probably isn't what you intended.");
                                }
                                return result;
                            }
                            return result;
                        }
                        lastException = null;
                    }
                    catch (Throwable e) {
                        Exceptions.propagateIfInterrupt(e);
                        lastException = e;
                        if (log.isTraceEnabled()) {
                            log.trace("Attempt {} after {} ms: {}", new Object[]{attempt, System.currentTimeMillis() - startTime, e.getMessage()});
                        }
                        if (abortOnException) {
                            throw e;
                        }
                        if (!abortOnError || !(e instanceof Error)) break block16;
                        throw e;
                    }
                }
                long sleepTime = Math.min(sleepTimeBetweenAttempts, expireTime - System.currentTimeMillis());
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                sleepTimeBetweenAttempts = Math.min(sleepTimeBetweenAttempts + Math.max(1L, sleepTimeBetweenAttempts / 2L), maxPeriod.toMilliseconds());
            }
            log.info("succeedsEventually exceeded max attempts or timeout - {} attempts lasting {} ms, for {}", new Object[]{attempt, System.currentTimeMillis() - startTime, c});
            if (lastException != null) {
                throw lastException;
            }
            throw Asserts.fail("invalid results; last was: " + result);
        }
        catch (Throwable t) {
            Exceptions.propagateIfInterrupt(t);
            if (logException) {
                log.info("failed succeeds-eventually, " + attempt + " attempts, " + (System.currentTimeMillis() - startTime) + "ms elapsed (rethrowing): " + t);
            }
            throw new AssertionError("failed succeeds-eventually, " + attempt + " attempts, " + (System.currentTimeMillis() - startTime) + "ms elapsed: " + Exceptions.collapseText(t), t);
        }
    }

    public static <T> void succeedsContinually(Runnable r) {
        Asserts.succeedsContinually(ImmutableMap.of(), r);
    }

    public static <T> void succeedsContinually(Map<?, ?> flags, Runnable r) {
        Asserts.succeedsContinually(flags, Asserts.toCallable(r));
    }

    public static <T> T succeedsContinually(Callable<T> c) {
        return Asserts.succeedsContinually(ImmutableMap.of(), c);
    }

    public static <T> T succeedsContinually(Map<?, ?> flags, Callable<T> job) {
        Duration duration = Asserts.toDuration(flags.get("timeout"), DEFAULT_SHORT_TIMEOUT);
        Duration period = Asserts.toDuration(flags.get("period"), Duration.millis(10));
        long periodMs = period.toMilliseconds();
        long startTime = System.currentTimeMillis();
        long expireTime = startTime + duration.toMilliseconds();
        int attempt = 0;
        boolean first = true;
        T result = null;
        while (first || System.currentTimeMillis() <= expireTime) {
            ++attempt;
            try {
                result = job.call();
            }
            catch (Exception e) {
                log.info("succeedsContinually failed - {} attempts lasting {} ms, for {} (rethrowing)", new Object[]{attempt, System.currentTimeMillis() - startTime, job});
                throw Asserts.propagate(e);
            }
            if (periodMs > 0L) {
                Asserts.sleep(periodMs);
            }
            first = false;
        }
        return result;
    }

    private static Duration toDuration(Object duration, Duration defaultVal) {
        if (duration == null) {
            return defaultVal;
        }
        return Duration.of(duration);
    }

    public static void assertFails(Runnable r) {
        Asserts.assertFailsWith(Asserts.toCallable(r), (Predicate<? super Throwable>)Predicates.alwaysTrue());
    }

    public static void assertFails(Callable<?> c) {
        Asserts.assertFailsWith(c, (Predicate<? super Throwable>)Predicates.alwaysTrue());
    }

    @Deprecated
    public static void assertFailsWith(Callable<?> c, final Closure<Boolean> exceptionChecker) {
        Asserts.assertFailsWith(c, (Predicate<? super Throwable>)new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                return (Boolean)exceptionChecker.call((Object)input);
            }
        });
    }

    @SafeVarargs
    public static void assertFailsWith(Runnable c, Class<? extends Throwable> validException, Class<? extends Throwable> ... otherValidExceptions) {
        ImmutableList validExceptions = ImmutableList.builder().add(validException).addAll((Iterable)ImmutableList.copyOf((Object[])otherValidExceptions)).build();
        Asserts.assertFailsWith(c, (Predicate<? super Throwable>)new Predicate<Throwable>((List)validExceptions){
            final /* synthetic */ List val$validExceptions;
            {
                this.val$validExceptions = list;
            }

            public boolean apply(Throwable e) {
                for (Class validException : this.val$validExceptions) {
                    if (!validException.isInstance(e)) continue;
                    return true;
                }
                Asserts.fail("Test threw exception of unexpected type " + e.getClass() + "; expecting " + this.val$validExceptions);
                return false;
            }
        });
    }

    public static void assertFailsWith(Runnable r, Predicate<? super Throwable> exceptionChecker) {
        Asserts.assertFailsWith(Asserts.toCallable(r), exceptionChecker);
    }

    public static void assertFailsWith(Callable<?> c, Predicate<? super Throwable> exceptionChecker) {
        boolean failed = false;
        try {
            c.call();
        }
        catch (Throwable e) {
            failed = true;
            if (!exceptionChecker.apply((Object)e)) {
                log.debug("Test threw invalid exception (failing)", e);
                Asserts.fail("Test threw invalid exception: " + e);
            }
            log.debug("Test for exception successful (" + e + ")");
        }
        if (!failed) {
            Asserts.fail("Test code should have thrown exception but did not");
        }
    }

    public static void assertReturnsEventually(final Runnable r, Duration timeout) throws InterruptedException, ExecutionException, TimeoutException {
        final AtomicReference throwable = new AtomicReference();
        Runnable wrappedR = new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    throwable.set(t);
                    throw Exceptions.propagate(t);
                }
            }
        };
        Thread thread = new Thread(wrappedR, "assertReturnsEventually(" + r + ")");
        try {
            thread.start();
            thread.join(timeout.toMilliseconds());
            if (thread.isAlive()) {
                throw new TimeoutException("Still running: r=" + r + "; thread=" + Arrays.toString(thread.getStackTrace()));
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate(e);
        }
        finally {
            thread.interrupt();
        }
        if (throwable.get() != null) {
            throw new ExecutionException((Throwable)throwable.get());
        }
    }

    public static <T> void assertThat(T object, Predicate<T> condition) {
        Asserts.assertThat(object, condition, null);
    }

    public static <T> void assertThat(T object, Predicate<T> condition, String message) {
        if (condition.apply(object)) {
            return;
        }
        Asserts.fail(Strings.isBlank(message) ? "Failed " + condition + ": " + object : message);
    }

    public static void assertStringContains(String input, String phrase1ToContain, String ... optionalOtherPhrasesToContain) {
        if (input == null) {
            Asserts.fail("Input is null.");
        }
        if (phrase1ToContain != null) {
            Asserts.assertThat(input, StringPredicates.containsLiteral(phrase1ToContain));
        }
        for (String otherPhrase : optionalOtherPhrasesToContain) {
            if (otherPhrase == null) continue;
            Asserts.assertThat(input, StringPredicates.containsLiteral(otherPhrase));
        }
    }

    public static void assertStringDoesNotContain(String input, String phrase1ToNotContain, String ... optionalOtherPhrasesToNotContain) {
        if (input == null) {
            Asserts.fail("Input is null.");
        }
        if (phrase1ToNotContain != null) {
            Asserts.assertThat(input, Predicates.not(StringPredicates.containsLiteral(phrase1ToNotContain)));
        }
        for (String otherPhrase : optionalOtherPhrasesToNotContain) {
            if (otherPhrase == null) continue;
            Asserts.assertThat(input, Predicates.not(StringPredicates.containsLiteral(otherPhrase)));
        }
    }

    public static void assertStringContainsAtLeastOne(String input, String possiblePhrase1ToContain, String ... optionalOtherPossiblePhrasesToContain) {
        if (input == null) {
            Asserts.fail("Input is null.");
        }
        MutableList missing = MutableList.of();
        if (possiblePhrase1ToContain != null) {
            if (input.contains(possiblePhrase1ToContain)) {
                return;
            }
            missing.add(possiblePhrase1ToContain);
        }
        for (String otherPhrase : optionalOtherPossiblePhrasesToContain) {
            if (otherPhrase == null) continue;
            if (input.contains(otherPhrase)) {
                return;
            }
            missing.add(otherPhrase);
        }
        Asserts.fail("Input did not contain any of the expected phrases " + missing + ": " + input);
    }

    public static void assertStringContainsIgnoreCase(String input, String phrase1ToContain, String ... optionalOtherPhrasesToContain) {
        if (input == null) {
            Asserts.fail("Input is null.");
        }
        if (phrase1ToContain != null) {
            Asserts.assertThat(input, StringPredicates.containsLiteralIgnoreCase(phrase1ToContain));
        }
        for (String otherPhrase : optionalOtherPhrasesToContain) {
            if (otherPhrase == null) continue;
            Asserts.assertThat(input, StringPredicates.containsLiteralIgnoreCase(otherPhrase));
        }
    }

    public static void assertStringMatchesRegex(String input, String regex1ToMatch, String ... optionalOtherRegexesToMatch) {
        if (input == null) {
            Asserts.fail("Input is null.");
        }
        if (regex1ToMatch != null) {
            Asserts.assertThat(input, StringPredicates.matchesRegex(regex1ToMatch));
        }
        for (String otherRegex : optionalOtherRegexesToMatch) {
            if (otherRegex == null) continue;
            Asserts.assertThat(input, StringPredicates.matchesRegex(otherRegex));
        }
    }

    public static RuntimeException shouldHaveFailedPreviously() {
        throw new ShouldHaveFailedPreviouslyAssertionError();
    }

    public static void shouldHaveFailedPreviously(String message) {
        throw new ShouldHaveFailedPreviouslyAssertionError(message);
    }

    public static void expectedFailure(Throwable e) {
        if (e instanceof ShouldHaveFailedPreviouslyAssertionError) {
            throw (Error)e;
        }
    }

    public static void expectedFailureOfType(Throwable e, Class<?> permittedSupertype, Class<?> ... permittedSupertypes) {
        if (e instanceof ShouldHaveFailedPreviouslyAssertionError) {
            throw (Error)e;
        }
        Object match = Exceptions.getFirstThrowableOfType(e, permittedSupertype);
        if (match != null) {
            return;
        }
        for (Class<?> clazz : permittedSupertypes) {
            match = Exceptions.getFirstThrowableOfType(e, clazz);
            if (match == null) continue;
            return;
        }
        Asserts.rethrowPreferredException(e, (Throwable)((Object)new AssertionError("Error " + JavaClassNames.simpleClassName(e) + " is not any of the expected types: " + Arrays.asList(permittedSupertypes), e)));
    }

    public static void expectedFailureContains(Throwable e, String phrase1ToContain, String ... optionalOtherPhrasesToContain) {
        if (e instanceof ShouldHaveFailedPreviouslyAssertionError) {
            throw (Error)e;
        }
        try {
            Asserts.assertStringContains(Exceptions.collapseText(e), phrase1ToContain, optionalOtherPhrasesToContain);
        }
        catch (AssertionError ee) {
            Asserts.rethrowPreferredException(e, (Throwable)((Object)ee));
        }
    }

    public static void expectedFailureContainsIgnoreCase(Throwable e, String phrase1ToContain, String ... optionalOtherPhrasesToContain) {
        if (e instanceof ShouldHaveFailedPreviouslyAssertionError) {
            throw (Error)e;
        }
        try {
            Asserts.assertStringContainsIgnoreCase(Exceptions.collapseText(e), phrase1ToContain, optionalOtherPhrasesToContain);
        }
        catch (AssertionError ee) {
            Asserts.rethrowPreferredException(e, (Throwable)((Object)ee));
        }
    }

    public static void expectedFailureDoesNotContain(Throwable e, String phrase1ToNotContain, String ... optionalOtherPhrasesToNotContain) {
        if (e instanceof ShouldHaveFailedPreviouslyAssertionError) {
            throw (Error)e;
        }
        try {
            Asserts.assertStringDoesNotContain(Exceptions.collapseText(e), phrase1ToNotContain, optionalOtherPhrasesToNotContain);
        }
        catch (AssertionError ee) {
            Asserts.rethrowPreferredException(e, (Throwable)((Object)ee));
        }
    }

    private static void rethrowPreferredException(Throwable earlierPreferredIfFatalElseLogged, Throwable laterPreferredOtherwise) throws AssertionError {
        if (!(earlierPreferredIfFatalElseLogged instanceof AssertionError)) {
            Exceptions.propagateIfFatal(earlierPreferredIfFatalElseLogged);
        }
        log.warn("Detail of unexpected error: " + earlierPreferredIfFatalElseLogged, earlierPreferredIfFatalElseLogged);
        throw Exceptions.propagate(laterPreferredOtherwise);
    }

    private static boolean groovyTruth(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return !((String)o).isEmpty();
        }
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        if (o instanceof Iterator) {
            return ((Iterator)o).hasNext();
        }
        if (o instanceof Enumeration) {
            return ((Enumeration)o).hasMoreElements();
        }
        return true;
    }

    private static <T> T get(Map<String, ?> map, String key, T defaultVal) {
        Object val = map.get(key);
        return (T)(val == null ? defaultVal : val);
    }

    private static Callable<?> toCallable(Runnable r) {
        return r instanceof Callable ? (Callable<Object>)((Object)r) : new RunnableAdapter<Object>(r, null);
    }

    private static void sleep(long periodMs) {
        if (periodMs > 0L) {
            try {
                Thread.sleep(periodMs);
            }
            catch (InterruptedException e) {
                throw Asserts.propagate(e);
            }
        }
    }

    private static RuntimeException propagate(Throwable t) {
        throw Exceptions.propagate(t);
    }

    public static <T> void eventuallyOnNotify(Object notifyTarget, Supplier<T> supplier, Predicate<T> predicate) {
        Asserts.eventuallyOnNotify(notifyTarget, supplier, predicate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void eventuallyOnNotify(Object notifyTarget, Supplier<T> supplier, Predicate<T> predicate, Duration timeout) {
        Object supplied = null;
        if (timeout == null) {
            timeout = DEFAULT_SHORT_TIMEOUT;
        }
        CountdownTimer remaining = timeout.countdownTimer();
        int checks = 0;
        Object object = notifyTarget;
        synchronized (object) {
            do {
                if (checks > 0) {
                    remaining.waitOnForExpiryUnchecked(notifyTarget);
                }
                if (predicate.apply(supplied = supplier.get())) {
                    return;
                }
                ++checks;
            } while (remaining.isNotExpired());
        }
        Asserts.fail("Expected: eventually " + predicate + "; got most recently: " + supplied + " (waited " + remaining.getDurationElapsed() + (checks > 2 ? "; notification count " + (checks - 2) : "") + ")");
    }

    public static <T> void eventuallyOnNotify(T object, Predicate<T> predicate, Duration timeout) {
        Asserts.eventuallyOnNotify(object, Suppliers.ofInstance(object), predicate, timeout);
    }

    public static <T> void eventuallyOnNotify(T object, Predicate<T> predicate) {
        Asserts.eventuallyOnNotify(object, Suppliers.ofInstance(object), predicate, null);
    }

    public static void assertSize(Iterable<?> list, int expectedSize) {
        if (list == null) {
            Asserts.fail("Collection is null");
        }
        if (Iterables.size(list) != expectedSize) {
            Asserts.fail("Collection has wrong size " + Iterables.size(list) + " (expected " + expectedSize + "): " + list);
        }
    }

    public static void assertSize(Map<?, ?> map, int expectedSize) {
        if (map == null) {
            Asserts.fail("Map is null");
        }
        if (Iterables.size(map.keySet()) != expectedSize) {
            Asserts.fail("Map has wrong size " + map.size() + " (expected " + expectedSize + "): " + map);
        }
    }

    public static void assertSameUnorderedContents(Iterable<?> i1, Iterable<?> i2) {
        if (i1 == null || i2 == null) {
            if (i1 == null && i2 == null) {
                return;
            }
            Asserts.fail("Collections differ in that one is null: " + i1 + " and " + i2);
        }
        Asserts.assertEquals(MutableSet.copyOf(i1), MutableSet.copyOf(i2));
    }

    public static void assertInstanceOf(Object obj, Class<?> type) {
        Asserts.assertThat(obj, Predicates.instanceOf(type), "Expected " + type + " but found " + (obj == null ? "null" : obj + " (" + obj.getClass() + ")"));
    }

    public static <T> void assertPresent(Maybe<T> candidate) {
        if (candidate.isPresent()) {
            return;
        }
        Asserts.fail(Maybe.getException(candidate));
    }

    public static <T> void assertNotPresent(Maybe<T> candidate) {
        if (candidate.isAbsent()) {
            return;
        }
        Asserts.fail("Expected absent value; instead got: " + candidate.get());
    }

    static {
        String defaultTimeout = System.getProperty("brooklyn.test.defaultTimeout");
        DEFAULT_LONG_TIMEOUT = defaultTimeout == null ? Duration.millis(30000L) : Duration.of(defaultTimeout);
        DEFAULT_SHORT_TIMEOUT = Duration.ONE_SECOND;
        DEFAULT_SHORT_PERIOD = Repeater.DEFAULT_REAL_QUICK_PERIOD;
        log = LoggerFactory.getLogger(Asserts.class);
        OPENING_CHARACTER = Character.valueOf('[');
        CLOSING_CHARACTER = Character.valueOf(']');
        ASSERT_LEFT = "expected " + OPENING_CHARACTER;
        ASSERT_MIDDLE = CLOSING_CHARACTER + " but found " + OPENING_CHARACTER;
        ASSERT_RIGHT = Character.toString(CLOSING_CHARACTER.charValue());
    }

    static final class RunnableAdapter<T>
    implements Callable<T> {
        final Runnable task;
        final T result;

        RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }

        public String toString() {
            return "RunnableAdapter(" + this.task + ")";
        }
    }

    public static class ShouldHaveFailedPreviouslyAssertionError
    extends AssertionError {
        private static final long serialVersionUID = 4359541529633617518L;

        public ShouldHaveFailedPreviouslyAssertionError() {
            this("Should have failed previously.");
        }

        public ShouldHaveFailedPreviouslyAssertionError(String message) {
            super((Object)message);
        }
    }

    public static class BooleanWithMessage {
        boolean value;
        String message;

        public BooleanWithMessage(boolean value, String message) {
            this.value = value;
            this.message = message;
        }

        public boolean asBoolean() {
            return this.value;
        }

        public String toString() {
            return this.message;
        }
    }
}

