/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.List;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.domain.Certificate;
import org.jclouds.azurecompute.arm.domain.Image;
import org.jclouds.azurecompute.arm.domain.Key;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.ResourceDefinition;
import org.jclouds.azurecompute.arm.domain.Secret;
import org.jclouds.azurecompute.arm.domain.Vault;
import org.jclouds.azurecompute.arm.domain.VirtualMachineInstance;
import org.jclouds.azurecompute.arm.functions.ParseJobStatus;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.util.Predicates2;

public class AzurePredicatesModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-running")
    protected VirtualMachineInStatePredicateFactory provideVirtualMachineRunningPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VirtualMachineInStatePredicateFactory(api, VirtualMachineInstance.PowerState.RUNNING, timeouts.nodeRunning, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<URI> provideNodeTerminatedPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ActionDonePredicate(api), (long)timeouts.nodeTerminated, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.image-available")
    protected Predicate<URI> provideImageCapturedPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ImageCapturedPredicate(api), (long)timeouts.imageAvailable, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.timeout.resourcedeleted")
    protected Predicate<URI> provideResourceDeletedPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ActionDonePredicate(api), (long)timeouts.nodeTerminated, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-suspended")
    protected VirtualMachineInStatePredicateFactory provideNodeSuspendedPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VirtualMachineInStatePredicateFactory(api, VirtualMachineInstance.PowerState.STOPPED, timeouts.nodeTerminated, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    protected PublicIpAvailablePredicateFactory providePublicIpAvailablePredicate(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
        return new PublicIpAvailablePredicateFactory(api, resourceAvailable);
    }

    @Provides
    protected SecurityGroupAvailablePredicateFactory provideSecurityGroupAvailablePredicate(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
        return new SecurityGroupAvailablePredicateFactory(api, resourceAvailable);
    }

    @Provides
    protected ImageAvailablePredicateFactory provideImageAvailablePredicate(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new ImageAvailablePredicateFactory(api, (Predicate<Supplier<Provisionable>>)Predicates2.retry((Predicate)new ResourceInStatusPredicate("Succeeded"), (long)timeouts.imageAvailable, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod));
    }

    @Provides
    protected Predicate<Supplier<Provisionable>> provideResourceAvailablePredicate(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ResourceInStatusPredicate("Succeeded"), (long)operationTimeout.intValue(), (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.vault.delete_status")
    protected VaultPredicates.DeletedVaultStatusPredicateFactory provideDeletedVaultStatusPredicateFactory(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VaultPredicates.DeletedVaultStatusPredicateFactory(api, operationTimeout.longValue(), pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.vault.key.delete_status")
    protected VaultKeyPredicates.DeletedKeyStatusPredicateFactory provideDeletedKeyStatusPredicateFactory(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VaultKeyPredicates.DeletedKeyStatusPredicateFactory(api, operationTimeout.longValue(), pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.vault.key.recoverable_status")
    protected VaultKeyPredicates.RecoverableKeyStatusPredicateFactory provideRecoverableKeyStatusPredicateFactory(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VaultKeyPredicates.RecoverableKeyStatusPredicateFactory(api, operationTimeout.longValue(), pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.vault.secret.delete_status")
    protected VaultSecretPredicates.DeletedSecretStatusPredicateFactory provideDeletedSecretStatusPredicateFactory(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VaultSecretPredicates.DeletedSecretStatusPredicateFactory(api, operationTimeout.longValue(), pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.vault.secret.recoverable_status")
    protected VaultSecretPredicates.RecoverableSecretStatusPredicateFactory provideRecoverableSecretStatusPredicateFactory(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VaultSecretPredicates.RecoverableSecretStatusPredicateFactory(api, operationTimeout.longValue(), pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.vault.certificate.delete_status")
    protected VaultCertificatePredicates.DeletedCertificateStatusPredicateFactory provideDeletedCertificateStatusPredicateFactory(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VaultCertificatePredicates.DeletedCertificateStatusPredicateFactory(api, operationTimeout.longValue(), pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.vault.certificate.recoverable_status")
    protected VaultCertificatePredicates.RecoverableCertificateStatusPredicateFactory provideRecoverableCertificateStatusPredicateFactory(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VaultCertificatePredicates.RecoverableCertificateStatusPredicateFactory(api, operationTimeout.longValue(), pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.vault.certificate.operation_status")
    protected VaultCertificatePredicates.CertificateOperationStatusPredicateFactory provideCertificateOperationStatusPredicateFactory(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VaultCertificatePredicates.CertificateOperationStatusPredicateFactory(api, operationTimeout.longValue(), pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    public static class VaultCertificatePredicates {

        public static class CertificateOperationStatusPredicateFactory {
            private final AzureComputeApi api;
            private final long operationTimeout;
            private final long initialPeriod;
            private final long maxPeriod;

            CertificateOperationStatusPredicateFactory(AzureComputeApi api, long operationTimeout, long initialPeriod, long maxPeriod) {
                this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
                this.operationTimeout = operationTimeout;
                this.initialPeriod = initialPeriod;
                this.maxPeriod = maxPeriod;
            }

            public Predicate<String> create(final String resourceGroup, final URI vaultUri, final boolean isCreate) {
                Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
                Preconditions.checkNotNull((Object)vaultUri, (Object)"vaultUri cannot be null");
                return Predicates2.retry((Predicate)new Predicate<String>(){

                    public boolean apply(String name) {
                        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                        boolean result = false;
                        Certificate.CertificateOperation certOp = CertificateOperationStatusPredicateFactory.this.api.getVaultApi(resourceGroup).getCertificateOperation(vaultUri, name);
                        return isCreate ? (certOp != null ? !certOp.status().equals("inProgress") : false) : certOp == null;
                    }
                }, (long)this.operationTimeout, (long)this.initialPeriod, (long)this.maxPeriod);
            }
        }

        public static class RecoverableCertificateStatusPredicateFactory {
            private final AzureComputeApi api;
            private final long operationTimeout;
            private final long initialPeriod;
            private final long maxPeriod;

            RecoverableCertificateStatusPredicateFactory(AzureComputeApi api, long operationTimeout, long initialPeriod, long maxPeriod) {
                this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
                this.operationTimeout = operationTimeout;
                this.initialPeriod = initialPeriod;
                this.maxPeriod = maxPeriod;
            }

            public Predicate<String> create(final String resourceGroup, final URI vaultUri, final boolean isImport) {
                Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
                Preconditions.checkNotNull((Object)vaultUri, (Object)"vaultUri cannot be null");
                return Predicates2.retry((Predicate)new Predicate<String>(){

                    public boolean apply(String name) {
                        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                        Certificate.CertificateBundle cert = RecoverableCertificateStatusPredicateFactory.this.api.getVaultApi(resourceGroup).getCertificate(vaultUri, name, null);
                        return cert != null ? (isImport ? true : cert.attributes().recoveryLevel().contains("Recoverable")) : false;
                    }
                }, (long)this.operationTimeout, (long)this.initialPeriod, (long)this.maxPeriod);
            }
        }

        public static class DeletedCertificateStatusPredicateFactory {
            private final AzureComputeApi api;
            private final long operationTimeout;
            private final long initialPeriod;
            private final long maxPeriod;

            DeletedCertificateStatusPredicateFactory(AzureComputeApi api, long operationTimeout, long initialPeriod, long maxPeriod) {
                this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
                this.operationTimeout = operationTimeout;
                this.initialPeriod = initialPeriod;
                this.maxPeriod = maxPeriod;
            }

            public Predicate<String> create(final String resourceGroup, final URI vaultUri, final boolean shouldBePresent) {
                Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
                Preconditions.checkNotNull((Object)vaultUri, (Object)"vaultUri cannot be null");
                return Predicates2.retry((Predicate)new Predicate<String>(){

                    public boolean apply(String name) {
                        boolean present = false;
                        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                        Certificate.DeletedCertificateBundle cert = DeletedCertificateStatusPredicateFactory.this.api.getVaultApi(resourceGroup).getDeletedCertificate(vaultUri, name);
                        return shouldBePresent == (cert != null);
                    }
                }, (long)this.operationTimeout, (long)this.initialPeriod, (long)this.maxPeriod);
            }
        }
    }

    public static class VaultSecretPredicates {

        public static class RecoverableSecretStatusPredicateFactory {
            private final AzureComputeApi api;
            private final long operationTimeout;
            private final long initialPeriod;
            private final long maxPeriod;

            RecoverableSecretStatusPredicateFactory(AzureComputeApi api, long operationTimeout, long initialPeriod, long maxPeriod) {
                this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
                this.operationTimeout = operationTimeout;
                this.initialPeriod = initialPeriod;
                this.maxPeriod = maxPeriod;
            }

            public Predicate<String> create(final String resourceGroup, final URI vaultUri, final boolean isRecovered) {
                Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
                Preconditions.checkNotNull((Object)vaultUri, (Object)"vaultUri cannot be null");
                return Predicates2.retry((Predicate)new Predicate<String>(){

                    public boolean apply(String name) {
                        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                        Secret.SecretBundle secret = RecoverableSecretStatusPredicateFactory.this.api.getVaultApi(resourceGroup).getSecret(vaultUri, name, null);
                        return secret != null ? (isRecovered ? true : secret.attributes().recoveryLevel().contains("Recoverable")) : false;
                    }
                }, (long)this.operationTimeout, (long)this.initialPeriod, (long)this.maxPeriod);
            }
        }

        public static class DeletedSecretStatusPredicateFactory {
            private final AzureComputeApi api;
            private final long operationTimeout;
            private final long initialPeriod;
            private final long maxPeriod;

            DeletedSecretStatusPredicateFactory(AzureComputeApi api, long operationTimeout, long initialPeriod, long maxPeriod) {
                this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
                this.operationTimeout = operationTimeout;
                this.initialPeriod = initialPeriod;
                this.maxPeriod = maxPeriod;
            }

            public Predicate<String> create(final String resourceGroup, final URI vaultUri, final boolean shouldBePresent) {
                Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
                Preconditions.checkNotNull((Object)vaultUri, (Object)"vaultUri cannot be null");
                return Predicates2.retry((Predicate)new Predicate<String>(){

                    public boolean apply(String name) {
                        boolean present = false;
                        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                        Secret.DeletedSecretBundle secret = DeletedSecretStatusPredicateFactory.this.api.getVaultApi(resourceGroup).getDeletedSecret(vaultUri, name);
                        return shouldBePresent == (secret != null);
                    }
                }, (long)this.operationTimeout, (long)this.initialPeriod, (long)this.maxPeriod);
            }
        }
    }

    public static class VaultKeyPredicates {

        public static class RecoverableKeyStatusPredicateFactory {
            private final AzureComputeApi api;
            private final long operationTimeout;
            private final long initialPeriod;
            private final long maxPeriod;

            RecoverableKeyStatusPredicateFactory(AzureComputeApi api, long operationTimeout, long initialPeriod, long maxPeriod) {
                this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
                this.operationTimeout = operationTimeout;
                this.initialPeriod = initialPeriod;
                this.maxPeriod = maxPeriod;
            }

            public Predicate<String> create(final String resourceGroup, final URI vaultUri, final boolean isRecovered) {
                Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
                Preconditions.checkNotNull((Object)vaultUri, (Object)"vaultUri cannot be null");
                return Predicates2.retry((Predicate)new Predicate<String>(){

                    public boolean apply(String name) {
                        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                        boolean result = false;
                        Key.KeyBundle key = RecoverableKeyStatusPredicateFactory.this.api.getVaultApi(resourceGroup).getKey(vaultUri, name);
                        return key != null ? (isRecovered ? true : key.attributes().recoveryLevel().contains("Recoverable")) : false;
                    }
                }, (long)this.operationTimeout, (long)this.initialPeriod, (long)this.maxPeriod);
            }
        }

        public static class DeletedKeyStatusPredicateFactory {
            private final AzureComputeApi api;
            private final long operationTimeout;
            private final long initialPeriod;
            private final long maxPeriod;

            DeletedKeyStatusPredicateFactory(AzureComputeApi api, long operationTimeout, long initialPeriod, long maxPeriod) {
                this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
                this.operationTimeout = operationTimeout;
                this.initialPeriod = initialPeriod;
                this.maxPeriod = maxPeriod;
            }

            public Predicate<String> create(final String resourceGroup, final URI vaultUri, final boolean shouldBePresent) {
                Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
                Preconditions.checkNotNull((Object)vaultUri, (Object)"vaultUri cannot be null");
                return Predicates2.retry((Predicate)new Predicate<String>(){

                    public boolean apply(String name) {
                        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                        boolean present = false;
                        Key.DeletedKeyBundle key = DeletedKeyStatusPredicateFactory.this.api.getVaultApi(resourceGroup).getDeletedKey(vaultUri, name);
                        return shouldBePresent == (key != null);
                    }
                }, (long)this.operationTimeout, (long)this.initialPeriod, (long)this.maxPeriod);
            }
        }
    }

    public static class VaultPredicates {

        public static class DeletedVaultStatusPredicateFactory {
            private final AzureComputeApi api;
            private final long operationTimeout;
            private final long initialPeriod;
            private final long maxPeriod;

            DeletedVaultStatusPredicateFactory(AzureComputeApi api, long operationTimeout, long initialPeriod, long maxPeriod) {
                this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
                this.operationTimeout = operationTimeout;
                this.initialPeriod = initialPeriod;
                this.maxPeriod = maxPeriod;
            }

            public Predicate<String> create(final String resourceGroup, final boolean shouldBePresent) {
                Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
                return Predicates2.retry((Predicate)new Predicate<String>(){

                    public boolean apply(final String name) {
                        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                        boolean present = false;
                        List<Vault.DeletedVault> vaults = DeletedVaultStatusPredicateFactory.this.api.getVaultApi(resourceGroup).listDeletedVaults();
                        return shouldBePresent == Iterables.any(vaults, (Predicate)new Predicate<Vault.DeletedVault>(){

                            public boolean apply(Vault.DeletedVault input) {
                                return input.name().equals(name);
                            }
                        });
                    }
                }, (long)this.operationTimeout, (long)this.initialPeriod, (long)this.maxPeriod);
            }
        }
    }

    public static class ImageAvailablePredicateFactory {
        private final AzureComputeApi api;
        private final Predicate<Supplier<Provisionable>> resourceAvailable;

        ImageAvailablePredicateFactory(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.resourceAvailable = resourceAvailable;
        }

        public Predicate<String> create(final String resourceGroup) {
            Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
            return new Predicate<String>(){

                public boolean apply(final String name) {
                    Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                    return ImageAvailablePredicateFactory.this.resourceAvailable.apply((Object)new Supplier<Provisionable>(){

                        public Provisionable get() {
                            Image img = ImageAvailablePredicateFactory.this.api.getVirtualMachineImageApi(resourceGroup).get(name);
                            return img == null ? null : img.properties();
                        }
                    });
                }
            };
        }
    }

    public static class SecurityGroupAvailablePredicateFactory {
        private final AzureComputeApi api;
        private final Predicate<Supplier<Provisionable>> resourceAvailable;

        SecurityGroupAvailablePredicateFactory(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.resourceAvailable = resourceAvailable;
        }

        public Predicate<String> create(final String resourceGroup) {
            Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
            return new Predicate<String>(){

                public boolean apply(final String name) {
                    Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                    return SecurityGroupAvailablePredicateFactory.this.resourceAvailable.apply((Object)new Supplier<Provisionable>(){

                        public Provisionable get() {
                            NetworkSecurityGroup sg = SecurityGroupAvailablePredicateFactory.this.api.getNetworkSecurityGroupApi(resourceGroup).get(name);
                            return sg == null ? null : sg.properties();
                        }
                    });
                }
            };
        }
    }

    public static class PublicIpAvailablePredicateFactory {
        private final AzureComputeApi api;
        private final Predicate<Supplier<Provisionable>> resourceAvailable;

        PublicIpAvailablePredicateFactory(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.resourceAvailable = resourceAvailable;
        }

        public Predicate<String> create(final String azureGroup) {
            Preconditions.checkNotNull((Object)azureGroup, (Object)"azureGroup cannot be null");
            return new Predicate<String>(){

                public boolean apply(final String name) {
                    Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                    return PublicIpAvailablePredicateFactory.this.resourceAvailable.apply((Object)new Supplier<Provisionable>(){

                        public Provisionable get() {
                            PublicIPAddress publicIp = PublicIpAvailablePredicateFactory.this.api.getPublicIPAddressApi(azureGroup).get(name);
                            return publicIp == null ? null : publicIp.properties();
                        }
                    });
                }
            };
        }
    }

    public static class ResourceInStatusPredicate
    implements Predicate<Supplier<Provisionable>> {
        private final String expectedStatus;

        ResourceInStatusPredicate(String expectedStatus) {
            this.expectedStatus = (String)Preconditions.checkNotNull((Object)expectedStatus, (Object)"expectedStatus cannot be null");
        }

        public boolean apply(Supplier<Provisionable> provisionableSupplier) {
            Preconditions.checkNotNull(provisionableSupplier, (Object)"provisionableSupplier supplier cannot be null");
            Provisionable provisionable = (Provisionable)provisionableSupplier.get();
            return provisionable != null && provisionable.provisioningState().equalsIgnoreCase(this.expectedStatus);
        }
    }

    public static class VirtualMachineInStatePredicateFactory {
        private final AzureComputeApi api;
        private final VirtualMachineInstance.PowerState powerState;
        private final long timeout;
        private final long period;
        private final long maxPeriod;

        VirtualMachineInStatePredicateFactory(AzureComputeApi api, VirtualMachineInstance.PowerState powerState, long timeout, long period, long maxPeriod) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.powerState = (VirtualMachineInstance.PowerState)((Object)Preconditions.checkNotNull((Object)((Object)powerState), (Object)"powerState cannot be null"));
            this.timeout = timeout;
            this.period = period;
            this.maxPeriod = maxPeriod;
        }

        public Predicate<String> create(final String azureGroup) {
            return Predicates2.retry((Predicate)new Predicate<String>(){

                public boolean apply(String name) {
                    Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                    VirtualMachineInstance vmInstance = VirtualMachineInStatePredicateFactory.this.api.getVirtualMachineApi(azureGroup).getInstanceDetails(name);
                    if (vmInstance == null) {
                        return false;
                    }
                    return VirtualMachineInStatePredicateFactory.this.powerState == vmInstance.powerState();
                }
            }, (long)this.timeout, (long)this.period, (long)this.maxPeriod);
        }
    }

    @VisibleForTesting
    static class ImageCapturedPredicate
    implements Predicate<URI> {
        private final AzureComputeApi api;

        public ImageCapturedPredicate(AzureComputeApi api) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(URI uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"uri cannot be null");
            if (this.api.getJobApi().jobStatus(uri) != ParseJobStatus.JobStatus.DONE) {
                return false;
            }
            List<ResourceDefinition> definitions = this.api.getJobApi().captureStatus(uri);
            return definitions != null;
        }
    }

    @VisibleForTesting
    static class ActionDonePredicate
    implements Predicate<URI> {
        private final AzureComputeApi api;

        public ActionDonePredicate(AzureComputeApi api) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(URI uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"uri cannot be null");
            return ParseJobStatus.JobStatus.DONE == this.api.getJobApi().jobStatus(uri) || ParseJobStatus.JobStatus.NO_CONTENT == this.api.getJobApi().jobStatus(uri);
        }
    }
}

